#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Sexy Brutale
# send your bug reports to contact@dotslashplay.it
###

script_version=20241004.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-sexy-brutale'
GAME_NAME='The Sexy Brutale'

ARCHIVE_BASE_1_NAME='setup_the_sexy_brutale_gog-2_(40574).exe'
ARCHIVE_BASE_1_MD5='ff1e34c2727d01a9f16a1c6d1acedd8e'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='2600000'
ARCHIVE_BASE_1_VERSION='1.0-gog40574'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_sexy_brutale'

ARCHIVE_BASE_0_NAME='setup_the_sexy_brutale_gog-1_(11101).exe'
ARCHIVE_BASE_0_MD5='6d94492d797e199c1e67b05dabbc52e5'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_sexy_brutale_gog-1_(11101)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='3158c4b5d6e9eafb9c4d1a79812601e0'
ARCHIVE_BASE_0_SIZE='3400000'
ARCHIVE_BASE_0_VERSION='1.0-gog11101'

UNITY3D_NAME='tsb'
UNITY3D_NAME_0='the sexy brutale'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/CGS/TSB'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
