/*************************************************************************
**
**    This file is part of the 'forwords' educational programm.
**    Copyright (C) 2024  Alexander Fomin
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
**
**    Contact: fomin_alex@yahoo.com
**
**************************************************************************/

#ifndef DLGSETTINGS_H
#define DLGSETTINGS_H

#include <QDialog>
#include <QFileDialog>
#include <QJsonObject>
#include <QJsonArray>
#include <QJsonValue>
#include <QEvent>
#include <QPointer>
#include <QSharedPointer>

namespace Ui {
class dlgSettings;
}

class dlgSettings : public QDialog
{
    Q_OBJECT

public:
    explicit dlgSettings(QWidget *parent = nullptr);
    ~dlgSettings();
    void Open(QJsonObject config, const QStringList *ttsEng = nullptr);
    void GetUiText(QJsonObject *uitext);
    void SetUiText(QJsonObject *uitext);
    void SetTtsVoices(const QStringList *voices);

private slots:
    void on_pbWorkFolder_clicked();
    void on_pbDeleteLanguage_clicked();
    void on_pbDeleteTopic_clicked();
    void on_pbSave_clicked();
    void on_pbExit_clicked();
    void on_cbLanguage_currentTextChanged(const QString &arg1);
    void on_pbSpeechTest_clicked();
    void on_cbSpeechEngine_currentTextChanged(const QString &arg1);

    void on_cbSpeechVoice_currentTextChanged(const QString &arg1);

signals:
    void textToSpeech(QString,QString,QString);
    void ttsEngineChanged(QString);
    void config_changed(QJsonObject);

private:
    Ui::dlgSettings *ui;
    void        fSetTopics(QString s);
    void        fSetLanguages();
    void        setTtsEngines(const QStringList *engine);
    QJsonObject vConfig;
    bool        vVoiceChangedActionOff;
};

#endif // DLGSETTINGS_H
