/*
 * SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef clc9b0_h_
#define clc9b0_h_

#include "nvtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

#define NVC9B0_VIDEO_DECODER                                                       (0x0000C9B0)

#define NVC9B0_NOP                                                              (0x00000100)
#define NVC9B0_NOP_PARAMETER                                                    31:0
#define NVC9B0_PM_TRIGGER                                                       (0x00000140)
#define NVC9B0_PM_TRIGGER_V                                                     31:0
#define NVC9B0_SET_APPLICATION_ID                                               (0x00000200)
#define NVC9B0_SET_APPLICATION_ID_ID                                            31:0
#define NVC9B0_SET_APPLICATION_ID_ID_MPEG12                                     (0x00000001)
#define NVC9B0_SET_APPLICATION_ID_ID_VC1                                        (0x00000002)
#define NVC9B0_SET_APPLICATION_ID_ID_H264                                       (0x00000003)
#define NVC9B0_SET_APPLICATION_ID_ID_MPEG4                                      (0x00000004)
#define NVC9B0_SET_APPLICATION_ID_ID_VP8                                        (0x00000005)
#define NVC9B0_SET_APPLICATION_ID_ID_CTR64                                      (0x00000006)
#define NVC9B0_SET_APPLICATION_ID_ID_HEVC                                       (0x00000007)
#define NVC9B0_SET_APPLICATION_ID_ID_NEW_H264                                   (0x00000008)
#define NVC9B0_SET_APPLICATION_ID_ID_VP9                                        (0x00000009)
#define NVC9B0_SET_APPLICATION_ID_ID_PASS1                                      (0x0000000A)
#define NVC9B0_SET_APPLICATION_ID_ID_HEVC_PARSER                                (0x0000000C)
#define NVC9B0_SET_APPLICATION_ID_ID_UCODE_TEST                                 (0x0000000D)
#define NVC9B0_SET_APPLICATION_ID_ID_HWDRM_PR_DECRYPTAUDIO                      (0x0000000E)
#define NVC9B0_SET_APPLICATION_ID_ID_HWDRM_PR_DECRYPTAUDIOMULTIPLE              (0x0000000F)
#define NVC9B0_SET_APPLICATION_ID_ID_HWDRM_PR_PREPROCESSENCRYPTEDDATA           (0x00000010)
#define NVC9B0_SET_APPLICATION_ID_ID_VP9_WITH_PARSER                            (0x00000011)
#define NVC9B0_SET_APPLICATION_ID_ID_AVD                                        (0x00000012)
#define NVC9B0_SET_APPLICATION_ID_ID_HW_DRM_PR4_DECRYPTCONTENTMULTIPLE          (0x00000013)
#define NVC9B0_SET_APPLICATION_ID_ID_DHKE                                       (0x00000020)
#define NVC9B0_SET_WATCHDOG_TIMER                                               (0x00000204)
#define NVC9B0_SET_WATCHDOG_TIMER_TIMER                                         31:0
#define NVC9B0_SEMAPHORE_A                                                      (0x00000240)
#define NVC9B0_SEMAPHORE_A_UPPER                                                7:0
#define NVC9B0_SEMAPHORE_B                                                      (0x00000244)
#define NVC9B0_SEMAPHORE_B_LOWER                                                31:0
#define NVC9B0_SEMAPHORE_C                                                      (0x00000248)
#define NVC9B0_SEMAPHORE_C_PAYLOAD                                              31:0
#define NVC9B0_CTX_SAVE_AREA                                                    (0x0000024C)
#define NVC9B0_CTX_SAVE_AREA_OFFSET                                             31:0
#define NVC9B0_CTX_SWITCH                                                       (0x00000250)
#define NVC9B0_CTX_SWITCH_OP                                                    1:0
#define NVC9B0_CTX_SWITCH_OP_CTX_UPDATE                                         (0x00000000)
#define NVC9B0_CTX_SWITCH_OP_CTX_SAVE                                           (0x00000001)
#define NVC9B0_CTX_SWITCH_OP_CTX_RESTORE                                        (0x00000002)
#define NVC9B0_CTX_SWITCH_OP_CTX_FORCERESTORE                                   (0x00000003)
#define NVC9B0_CTX_SWITCH_CTXID_VALID                                           2:2
#define NVC9B0_CTX_SWITCH_CTXID_VALID_FALSE                                     (0x00000000)
#define NVC9B0_CTX_SWITCH_CTXID_VALID_TRUE                                      (0x00000001)
#define NVC9B0_CTX_SWITCH_RESERVED0                                             7:3
#define NVC9B0_CTX_SWITCH_CTX_ID                                                23:8
#define NVC9B0_CTX_SWITCH_RESERVED1                                             31:24
#define NVC9B0_SET_SEMAPHORE_PAYLOAD_LOWER                                      (0x00000254)
#define NVC9B0_SET_SEMAPHORE_PAYLOAD_LOWER_PAYLOAD_LOWER                        31:0
#define NVC9B0_SET_SEMAPHORE_PAYLOAD_UPPER                                      (0x00000258)
#define NVC9B0_SET_SEMAPHORE_PAYLOAD_UPPER_PAYLOAD_UPPER                        31:0
#define NVC9B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A                        (0x0000025C)
#define NVC9B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_A_LOWER                  31:0
#define NVC9B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B                        (0x00000260)
#define NVC9B0_SET_MONITORED_FENCE_SIGNAL_ADDRESS_BASE_B_UPPER                  31:0
#define NVC9B0_EXECUTE                                                          (0x00000300)
#define NVC9B0_EXECUTE_NOTIFY                                                   0:0
#define NVC9B0_EXECUTE_NOTIFY_DISABLE                                           (0x00000000)
#define NVC9B0_EXECUTE_NOTIFY_ENABLE                                            (0x00000001)
#define NVC9B0_EXECUTE_NOTIFY_ON                                                1:1
#define NVC9B0_EXECUTE_NOTIFY_ON_END                                            (0x00000000)
#define NVC9B0_EXECUTE_NOTIFY_ON_BEGIN                                          (0x00000001)
#define NVC9B0_EXECUTE_PREDICATION                                              2:2
#define NVC9B0_EXECUTE_PREDICATION_DISABLE                                      (0x00000000)
#define NVC9B0_EXECUTE_PREDICATION_ENABLE                                       (0x00000001)
#define NVC9B0_EXECUTE_PREDICATION_OP                                           3:3
#define NVC9B0_EXECUTE_PREDICATION_OP_EQUAL_ZERO                                (0x00000000)
#define NVC9B0_EXECUTE_PREDICATION_OP_NOT_EQUAL_ZERO                            (0x00000001)
#define NVC9B0_EXECUTE_AWAKEN                                                   8:8
#define NVC9B0_EXECUTE_AWAKEN_DISABLE                                           (0x00000000)
#define NVC9B0_EXECUTE_AWAKEN_ENABLE                                            (0x00000001)
#define NVC9B0_SEMAPHORE_D                                                      (0x00000304)
#define NVC9B0_SEMAPHORE_D_STRUCTURE_SIZE                                       1:0
#define NVC9B0_SEMAPHORE_D_STRUCTURE_SIZE_ONE                                   (0x00000000)
#define NVC9B0_SEMAPHORE_D_STRUCTURE_SIZE_FOUR                                  (0x00000001)
#define NVC9B0_SEMAPHORE_D_STRUCTURE_SIZE_TWO                                   (0x00000002)
#define NVC9B0_SEMAPHORE_D_AWAKEN_ENABLE                                        8:8
#define NVC9B0_SEMAPHORE_D_AWAKEN_ENABLE_FALSE                                  (0x00000000)
#define NVC9B0_SEMAPHORE_D_AWAKEN_ENABLE_TRUE                                   (0x00000001)
#define NVC9B0_SEMAPHORE_D_OPERATION                                            17:16
#define NVC9B0_SEMAPHORE_D_OPERATION_RELEASE                                    (0x00000000)
#define NVC9B0_SEMAPHORE_D_OPERATION_RESERVED_0                                 (0x00000001)
#define NVC9B0_SEMAPHORE_D_OPERATION_RESERVED_1                                 (0x00000002)
#define NVC9B0_SEMAPHORE_D_OPERATION_TRAP                                       (0x00000003)
#define NVC9B0_SEMAPHORE_D_FLUSH_DISABLE                                        21:21
#define NVC9B0_SEMAPHORE_D_FLUSH_DISABLE_FALSE                                  (0x00000000)
#define NVC9B0_SEMAPHORE_D_FLUSH_DISABLE_TRUE                                   (0x00000001)
#define NVC9B0_SEMAPHORE_D_TRAP_TYPE                                            23:22
#define NVC9B0_SEMAPHORE_D_TRAP_TYPE_UNCONDITIONAL                              (0x00000000)
#define NVC9B0_SEMAPHORE_D_TRAP_TYPE_CONDITIONAL                                (0x00000001)
#define NVC9B0_SEMAPHORE_D_TRAP_TYPE_CONDITIONAL_EXT                            (0x00000002)
#define NVC9B0_SEMAPHORE_D_PAYLOAD_SIZE                                         24:24
#define NVC9B0_SEMAPHORE_D_PAYLOAD_SIZE_32BIT                                   (0x00000000)
#define NVC9B0_SEMAPHORE_D_PAYLOAD_SIZE_64BIT                                   (0x00000001)
#define NVC9B0_SET_PREDICATION_OFFSET_UPPER                                     (0x00000308)
#define NVC9B0_SET_PREDICATION_OFFSET_UPPER_OFFSET                              7:0
#define NVC9B0_SET_PREDICATION_OFFSET_LOWER                                     (0x0000030C)
#define NVC9B0_SET_PREDICATION_OFFSET_LOWER_OFFSET                              31:0
#define NVC9B0_SET_AUXILIARY_DATA_BUFFER                                        (0x00000310)
#define NVC9B0_SET_AUXILIARY_DATA_BUFFER_OFFSET                                 31:0
#define NVC9B0_SET_CONTROL_PARAMS                                               (0x00000400)
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE                                    3:0
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG1                              (0x00000000)
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG2                              (0x00000001)
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_VC1                                (0x00000002)
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_H264                               (0x00000003)
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG4                              (0x00000004)
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_DIVX3                              (0x00000004)
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP8                                (0x00000005)
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_HEVC                               (0x00000007)
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP9                                (0x00000009)
#define NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_AV1                                (0x0000000A)
#define NVC9B0_SET_CONTROL_PARAMS_GPTIMER_ON                                    4:4
#define NVC9B0_SET_CONTROL_PARAMS_RET_ERROR                                     5:5
#define NVC9B0_SET_CONTROL_PARAMS_ERR_CONCEAL_ON                                6:6
#define NVC9B0_SET_CONTROL_PARAMS_ERROR_FRM_IDX                                 12:7
#define NVC9B0_SET_CONTROL_PARAMS_MBTIMER_ON                                    13:13
#define NVC9B0_SET_CONTROL_PARAMS_EC_INTRA_FRAME_USING_PSLC                     14:14
#define NVC9B0_SET_CONTROL_PARAMS_IGNORE_SOME_FIELDS_CRC_CHECK                  15:15
#define NVC9B0_SET_CONTROL_PARAMS_EVENT_TRACE_LOGGING_ON                        16:16
#define NVC9B0_SET_CONTROL_PARAMS_ALL_INTRA_FRAME                               17:17
#define NVC9B0_SET_CONTROL_PARAMS_TESTRUN_ENV                                   19:18
#define NVC9B0_SET_CONTROL_PARAMS_TESTRUN_ENV_TRACE3D_RUN                       (0x00000000)
#define NVC9B0_SET_CONTROL_PARAMS_TESTRUN_ENV_PROD_RUN                          (0x00000001)
#define NVC9B0_SET_CONTROL_PARAMS_HINT_DUMP_EN                                  20:20
#define NVC9B0_SET_CONTROL_PARAMS_RESERVED                                      25:21
#define NVC9B0_SET_CONTROL_PARAMS_NVDECSIM_SKIP_SCP                             26:26
#define NVC9B0_SET_CONTROL_PARAMS_ENABLE_ENCRYPT                                27:27
#define NVC9B0_SET_CONTROL_PARAMS_ENCRYPTMODE                                   31:28
#define NVC9B0_SET_DRV_PIC_SETUP_OFFSET                                         (0x00000404)
#define NVC9B0_SET_DRV_PIC_SETUP_OFFSET_OFFSET                                  31:0
#define NVC9B0_SET_IN_BUF_BASE_OFFSET                                           (0x00000408)
#define NVC9B0_SET_IN_BUF_BASE_OFFSET_OFFSET                                    31:0
#define NVC9B0_SET_PICTURE_INDEX                                                (0x0000040C)
#define NVC9B0_SET_PICTURE_INDEX_INDEX                                          31:0
#define NVC9B0_SET_SLICE_OFFSETS_BUF_OFFSET                                     (0x00000410)
#define NVC9B0_SET_SLICE_OFFSETS_BUF_OFFSET_OFFSET                              31:0
#define NVC9B0_SET_COLOC_DATA_OFFSET                                            (0x00000414)
#define NVC9B0_SET_COLOC_DATA_OFFSET_OFFSET                                     31:0
#define NVC9B0_SET_HISTORY_OFFSET                                               (0x00000418)
#define NVC9B0_SET_HISTORY_OFFSET_OFFSET                                        31:0
#define NVC9B0_SET_DISPLAY_BUF_SIZE                                             (0x0000041C)
#define NVC9B0_SET_DISPLAY_BUF_SIZE_SIZE                                        31:0
#define NVC9B0_SET_HISTOGRAM_OFFSET                                             (0x00000420)
#define NVC9B0_SET_HISTOGRAM_OFFSET_OFFSET                                      31:0
#define NVC9B0_SET_NVDEC_STATUS_OFFSET                                          (0x00000424)
#define NVC9B0_SET_NVDEC_STATUS_OFFSET_OFFSET                                   31:0
#define NVC9B0_SET_DISPLAY_BUF_LUMA_OFFSET                                      (0x00000428)
#define NVC9B0_SET_DISPLAY_BUF_LUMA_OFFSET_OFFSET                               31:0
#define NVC9B0_SET_DISPLAY_BUF_CHROMA_OFFSET                                    (0x0000042C)
#define NVC9B0_SET_DISPLAY_BUF_CHROMA_OFFSET_OFFSET                             31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET0                                         (0x00000430)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET0_OFFSET                                  31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET1                                         (0x00000434)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET1_OFFSET                                  31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET2                                         (0x00000438)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET2_OFFSET                                  31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET3                                         (0x0000043C)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET3_OFFSET                                  31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET4                                         (0x00000440)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET4_OFFSET                                  31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET5                                         (0x00000444)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET5_OFFSET                                  31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET6                                         (0x00000448)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET6_OFFSET                                  31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET7                                         (0x0000044C)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET7_OFFSET                                  31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET8                                         (0x00000450)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET8_OFFSET                                  31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET9                                         (0x00000454)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET9_OFFSET                                  31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET10                                        (0x00000458)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET10_OFFSET                                 31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET11                                        (0x0000045C)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET11_OFFSET                                 31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET12                                        (0x00000460)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET12_OFFSET                                 31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET13                                        (0x00000464)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET13_OFFSET                                 31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET14                                        (0x00000468)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET14_OFFSET                                 31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET15                                        (0x0000046C)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET15_OFFSET                                 31:0
#define NVC9B0_SET_PICTURE_LUMA_OFFSET16                                        (0x00000470)
#define NVC9B0_SET_PICTURE_LUMA_OFFSET16_OFFSET                                 31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET0                                       (0x00000474)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET0_OFFSET                                31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET1                                       (0x00000478)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET1_OFFSET                                31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET2                                       (0x0000047C)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET2_OFFSET                                31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET3                                       (0x00000480)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET3_OFFSET                                31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET4                                       (0x00000484)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET4_OFFSET                                31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET5                                       (0x00000488)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET5_OFFSET                                31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET6                                       (0x0000048C)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET6_OFFSET                                31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET7                                       (0x00000490)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET7_OFFSET                                31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET8                                       (0x00000494)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET8_OFFSET                                31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET9                                       (0x00000498)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET9_OFFSET                                31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET10                                      (0x0000049C)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET10_OFFSET                               31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET11                                      (0x000004A0)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET11_OFFSET                               31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET12                                      (0x000004A4)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET12_OFFSET                               31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET13                                      (0x000004A8)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET13_OFFSET                               31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET14                                      (0x000004AC)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET14_OFFSET                               31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET15                                      (0x000004B0)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET15_OFFSET                               31:0
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET16                                      (0x000004B4)
#define NVC9B0_SET_PICTURE_CHROMA_OFFSET16_OFFSET                               31:0
#define NVC9B0_SET_PIC_SCRATCH_BUF_OFFSET                                       (0x000004B8)
#define NVC9B0_SET_PIC_SCRATCH_BUF_OFFSET_OFFSET                                31:0
#define NVC9B0_SET_EXTERNAL_MVBUFFER_OFFSET                                     (0x000004BC)
#define NVC9B0_SET_EXTERNAL_MVBUFFER_OFFSET_OFFSET                              31:0
#define NVC9B0_SET_SUB_SAMPLE_MAP_OFFSET                                        (0x000004C0)
#define NVC9B0_SET_SUB_SAMPLE_MAP_OFFSET_OFFSET                                 31:0
#define NVC9B0_SET_SUB_SAMPLE_MAP_IV_OFFSET                                     (0x000004C4)
#define NVC9B0_SET_SUB_SAMPLE_MAP_IV_OFFSET_OFFSET                              31:0
#define NVC9B0_SET_INTRA_TOP_BUF_OFFSET                                         (0x000004C8)
#define NVC9B0_SET_INTRA_TOP_BUF_OFFSET_OFFSET                                  31:0
#define NVC9B0_SET_TILE_SIZE_BUF_OFFSET                                         (0x000004CC)
#define NVC9B0_SET_TILE_SIZE_BUF_OFFSET_OFFSET                                  31:0
#define NVC9B0_SET_FILTER_BUFFER_OFFSET                                         (0x000004D0)
#define NVC9B0_SET_FILTER_BUFFER_OFFSET_OFFSET                                  31:0
#define NVC9B0_SET_CRC_STRUCT_OFFSET                                            (0x000004D4)
#define NVC9B0_SET_CRC_STRUCT_OFFSET_OFFSET                                     31:0
#define NVC9B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET                               (0x000004D8)
#define NVC9B0_SET_PR_SSM_CONTENT_INFO_BUF_OFFSET_OFFSET                        31:0
#define NVC9B0_H264_SET_MBHIST_BUF_OFFSET                                       (0x00000500)
#define NVC9B0_H264_SET_MBHIST_BUF_OFFSET_OFFSET                                31:0
#define NVC9B0_VP8_SET_PROB_DATA_OFFSET                                         (0x00000540)
#define NVC9B0_VP8_SET_PROB_DATA_OFFSET_OFFSET                                  31:0
#define NVC9B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET                         (0x00000544)
#define NVC9B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET_OFFSET                  31:0
#define NVC9B0_HEVC_SET_SCALING_LIST_OFFSET                                     (0x00000580)
#define NVC9B0_HEVC_SET_SCALING_LIST_OFFSET_OFFSET                              31:0
#define NVC9B0_HEVC_SET_TILE_SIZES_OFFSET                                       (0x00000584)
#define NVC9B0_HEVC_SET_TILE_SIZES_OFFSET_OFFSET                                31:0
#define NVC9B0_HEVC_SET_FILTER_BUFFER_OFFSET                                    (0x00000588)
#define NVC9B0_HEVC_SET_FILTER_BUFFER_OFFSET_OFFSET                             31:0
#define NVC9B0_HEVC_SET_SAO_BUFFER_OFFSET                                       (0x0000058C)
#define NVC9B0_HEVC_SET_SAO_BUFFER_OFFSET_OFFSET                                31:0
#define NVC9B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET                                (0x00000590)
#define NVC9B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET_OFFSET                         31:0
#define NVC9B0_HEVC_SET_SLICE_GROUP_INDEX                                       (0x00000594)
#define NVC9B0_HEVC_SET_SLICE_GROUP_INDEX_OFFSET                                31:0
#define NVC9B0_VP9_SET_PROB_TAB_BUF_OFFSET                                      (0x000005C0)
#define NVC9B0_VP9_SET_PROB_TAB_BUF_OFFSET_OFFSET                               31:0
#define NVC9B0_VP9_SET_CTX_COUNTER_BUF_OFFSET                                   (0x000005C4)
#define NVC9B0_VP9_SET_CTX_COUNTER_BUF_OFFSET_OFFSET                            31:0
#define NVC9B0_VP9_SET_SEGMENT_READ_BUF_OFFSET                                  (0x000005C8)
#define NVC9B0_VP9_SET_SEGMENT_READ_BUF_OFFSET_OFFSET                           31:0
#define NVC9B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET                                 (0x000005CC)
#define NVC9B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET_OFFSET                          31:0
#define NVC9B0_VP9_SET_TILE_SIZE_BUF_OFFSET                                     (0x000005D0)
#define NVC9B0_VP9_SET_TILE_SIZE_BUF_OFFSET_OFFSET                              31:0
#define NVC9B0_VP9_SET_COL_MVWRITE_BUF_OFFSET                                   (0x000005D4)
#define NVC9B0_VP9_SET_COL_MVWRITE_BUF_OFFSET_OFFSET                            31:0
#define NVC9B0_VP9_SET_COL_MVREAD_BUF_OFFSET                                    (0x000005D8)
#define NVC9B0_VP9_SET_COL_MVREAD_BUF_OFFSET_OFFSET                             31:0
#define NVC9B0_VP9_SET_FILTER_BUFFER_OFFSET                                     (0x000005DC)
#define NVC9B0_VP9_SET_FILTER_BUFFER_OFFSET_OFFSET                              31:0
#define NVC9B0_VP9_PARSER_SET_PIC_SETUP_OFFSET                                  (0x000005E0)
#define NVC9B0_VP9_PARSER_SET_PIC_SETUP_OFFSET_OFFSET                           31:0
#define NVC9B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET                             (0x000005E4)
#define NVC9B0_VP9_PARSER_SET_PREV_PIC_SETUP_OFFSET_OFFSET                      31:0
#define NVC9B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET                               (0x000005E8)
#define NVC9B0_VP9_PARSER_SET_PROB_TAB_BUF_OFFSET_OFFSET                        31:0
#define NVC9B0_VP9_SET_HINT_DUMP_BUF_OFFSET                                     (0x000005EC)
#define NVC9B0_VP9_SET_HINT_DUMP_BUF_OFFSET_OFFSET                              31:0
#define NVC9B0_PASS1_SET_CLEAR_HEADER_OFFSET                                    (0x00000600)
#define NVC9B0_PASS1_SET_CLEAR_HEADER_OFFSET_OFFSET                             31:0
#define NVC9B0_PASS1_SET_RE_ENCRYPT_OFFSET                                      (0x00000604)
#define NVC9B0_PASS1_SET_RE_ENCRYPT_OFFSET_OFFSET                               31:0
#define NVC9B0_PASS1_SET_VP8_TOKEN_OFFSET                                       (0x00000608)
#define NVC9B0_PASS1_SET_VP8_TOKEN_OFFSET_OFFSET                                31:0
#define NVC9B0_PASS1_SET_INPUT_DATA_OFFSET                                      (0x0000060C)
#define NVC9B0_PASS1_SET_INPUT_DATA_OFFSET_OFFSET                               31:0
#define NVC9B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET                                (0x00000610)
#define NVC9B0_PASS1_SET_OUTPUT_DATA_SIZE_OFFSET_OFFSET                         31:0
#define NVC9B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET                                 (0x00000640)
#define NVC9B0_AV1_SET_PROB_TAB_READ_BUF_OFFSET_OFFSET                          31:0
#define NVC9B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET                                (0x00000644)
#define NVC9B0_AV1_SET_PROB_TAB_WRITE_BUF_OFFSET_OFFSET                         31:0
#define NVC9B0_AV1_SET_SEGMENT_READ_BUF_OFFSET                                  (0x00000648)
#define NVC9B0_AV1_SET_SEGMENT_READ_BUF_OFFSET_OFFSET                           31:0
#define NVC9B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET                                 (0x0000064C)
#define NVC9B0_AV1_SET_SEGMENT_WRITE_BUF_OFFSET_OFFSET                          31:0
#define NVC9B0_AV1_SET_COL_MV0_READ_BUF_OFFSET                                  (0x00000650)
#define NVC9B0_AV1_SET_COL_MV0_READ_BUF_OFFSET_OFFSET                           31:0
#define NVC9B0_AV1_SET_COL_MV1_READ_BUF_OFFSET                                  (0x00000654)
#define NVC9B0_AV1_SET_COL_MV1_READ_BUF_OFFSET_OFFSET                           31:0
#define NVC9B0_AV1_SET_COL_MV2_READ_BUF_OFFSET                                  (0x00000658)
#define NVC9B0_AV1_SET_COL_MV2_READ_BUF_OFFSET_OFFSET                           31:0
#define NVC9B0_AV1_SET_COL_MVWRITE_BUF_OFFSET                                   (0x0000065C)
#define NVC9B0_AV1_SET_COL_MVWRITE_BUF_OFFSET_OFFSET                            31:0
#define NVC9B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET                                  (0x00000660)
#define NVC9B0_AV1_SET_GLOBAL_MODEL_BUF_OFFSET_OFFSET                           31:0
#define NVC9B0_AV1_SET_FILM_GRAIN_BUF_OFFSET                                    (0x00000664)
#define NVC9B0_AV1_SET_FILM_GRAIN_BUF_OFFSET_OFFSET                             31:0
#define NVC9B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET                              (0x00000668)
#define NVC9B0_AV1_SET_TILE_STREAM_INFO_BUF_OFFSET_OFFSET                       31:0
#define NVC9B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET                              (0x0000066C)
#define NVC9B0_AV1_SET_SUB_STREAM_ENTRY_BUF_OFFSET_OFFSET                       31:0
#define NVC9B0_AV1_SET_HINT_DUMP_BUF_OFFSET                                     (0x00000670)
#define NVC9B0_AV1_SET_HINT_DUMP_BUF_OFFSET_OFFSET                              31:0
#define NVC9B0_H264_SET_SCALING_LIST_OFFSET                                     (0x00000680)
#define NVC9B0_H264_SET_SCALING_LIST_OFFSET_OFFSET                              31:0
#define NVC9B0_H264_SET_VLDHIST_BUF_OFFSET                                      (0x00000684)
#define NVC9B0_H264_SET_VLDHIST_BUF_OFFSET_OFFSET                               31:0
#define NVC9B0_H264_SET_EDOBOFFSET0                                             (0x00000688)
#define NVC9B0_H264_SET_EDOBOFFSET0_OFFSET                                      31:0
#define NVC9B0_H264_SET_EDOBOFFSET1                                             (0x0000068C)
#define NVC9B0_H264_SET_EDOBOFFSET1_OFFSET                                      31:0
#define NVC9B0_H264_SET_EDOBOFFSET2                                             (0x00000690)
#define NVC9B0_H264_SET_EDOBOFFSET2_OFFSET                                      31:0
#define NVC9B0_H264_SET_EDOBOFFSET3                                             (0x00000694)
#define NVC9B0_H264_SET_EDOBOFFSET3_OFFSET                                      31:0
#define NVC9B0_SET_CONTENT_INITIAL_VECTOR(b)                                    (0x00000C00 + (b)*0x00000004)
#define NVC9B0_SET_CONTENT_INITIAL_VECTOR_VALUE                                 31:0
#define NVC9B0_SET_CTL_COUNT                                                    (0x00000C10)
#define NVC9B0_SET_CTL_COUNT_VALUE                                              31:0
#define NVC9B0_SET_UPPER_SRC                                                    (0x00000C14)
#define NVC9B0_SET_UPPER_SRC_OFFSET                                             7:0
#define NVC9B0_SET_LOWER_SRC                                                    (0x00000C18)
#define NVC9B0_SET_LOWER_SRC_OFFSET                                             31:0
#define NVC9B0_SET_UPPER_DST                                                    (0x00000C1C)
#define NVC9B0_SET_UPPER_DST_OFFSET                                             7:0
#define NVC9B0_SET_LOWER_DST                                                    (0x00000C20)
#define NVC9B0_SET_LOWER_DST_OFFSET                                             31:0
#define NVC9B0_SET_BLOCK_COUNT                                                  (0x00000C24)
#define NVC9B0_SET_BLOCK_COUNT_VALUE                                            31:0
#define NVC9B0_PR_SET_REQUEST_BUF_OFFSET                                        (0x00000D00)
#define NVC9B0_PR_SET_REQUEST_BUF_OFFSET_OFFSET                                 31:0
#define NVC9B0_PR_SET_REQUEST_BUF_SIZE                                          (0x00000D04)
#define NVC9B0_PR_SET_REQUEST_BUF_SIZE_SIZE                                     31:0
#define NVC9B0_PR_SET_RESPONSE_BUF_OFFSET                                       (0x00000D08)
#define NVC9B0_PR_SET_RESPONSE_BUF_OFFSET_OFFSET                                31:0
#define NVC9B0_PR_SET_RESPONSE_BUF_SIZE                                         (0x00000D0C)
#define NVC9B0_PR_SET_RESPONSE_BUF_SIZE_SIZE                                    31:0
#define NVC9B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET                                (0x00000D10)
#define NVC9B0_PR_SET_REQUEST_MESSAGE_BUF_OFFSET_OFFSET                         31:0
#define NVC9B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET                               (0x00000D14)
#define NVC9B0_PR_SET_RESPONSE_MESSAGE_BUF_OFFSET_OFFSET                        31:0
#define NVC9B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET                                  (0x00000D18)
#define NVC9B0_PR_SET_LOCAL_DECRYPT_BUF_OFFSET_OFFSET                           31:0
#define NVC9B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE                                    (0x00000D1C)
#define NVC9B0_PR_SET_LOCAL_DECRYPT_BUF_SIZE_SIZE                               31:0
#define NVC9B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET                           (0x00000D20)
#define NVC9B0_PR_SET_CONTENT_DECRYPT_INFO_BUF_OFFSET_OFFSET                    31:0
#define NVC9B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET                          (0x00000D24)
#define NVC9B0_PR_SET_REENCRYPTED_BITSTREAM_BUF_OFFSET_OFFSET                   31:0
#define NVC9B0_DH_KE_SET_CHALLENGE_BUF_OFFSET                                   (0x00000E00)
#define NVC9B0_DH_KE_SET_CHALLENGE_BUF_OFFSET_OFFSET                            31:0
#define NVC9B0_DH_KE_SET_RESPONSE_BUF_OFFSET                                    (0x00000E04)
#define NVC9B0_DH_KE_SET_RESPONSE_BUF_OFFSET_OFFSET                             31:0
#define NVC9B0_SET_SESSION_KEY(b)                                               (0x00000F00 + (b)*0x00000004)
#define NVC9B0_SET_SESSION_KEY_VALUE                                            31:0
#define NVC9B0_SET_CONTENT_KEY(b)                                               (0x00000F10 + (b)*0x00000004)
#define NVC9B0_SET_CONTENT_KEY_VALUE                                            31:0
#define NVC9B0_PM_TRIGGER_END                                                   (0x00001114)
#define NVC9B0_PM_TRIGGER_END_V                                                 31:0

#define NVC9B0_ERROR_NONE                                                       (0x00000000)
#define NVC9B0_OS_ERROR_EXECUTE_INSUFFICIENT_DATA                               (0x00000001)
#define NVC9B0_OS_ERROR_SEMAPHORE_INSUFFICIENT_DATA                             (0x00000002)
#define NVC9B0_OS_ERROR_INVALID_METHOD                                          (0x00000003)
#define NVC9B0_OS_ERROR_INVALID_DMA_PAGE                                        (0x00000004)
#define NVC9B0_OS_ERROR_UNHANDLED_INTERRUPT                                     (0x00000005)
#define NVC9B0_OS_ERROR_EXCEPTION                                               (0x00000006)
#define NVC9B0_OS_ERROR_INVALID_CTXSW_REQUEST                                   (0x00000007)
#define NVC9B0_OS_ERROR_APPLICATION                                             (0x00000008)
#define NVC9B0_OS_ERROR_SW_BREAKPT                                              (0x00000009)
#define NVC9B0_OS_INTERRUPT_EXECUTE_AWAKEN                                      (0x00000100)
#define NVC9B0_OS_INTERRUPT_BACKEND_SEMAPHORE_AWAKEN                            (0x00000200)
#define NVC9B0_OS_INTERRUPT_CTX_ERROR_FBIF                                      (0x00000300)
#define NVC9B0_OS_INTERRUPT_LIMIT_VIOLATION                                     (0x00000400)
#define NVC9B0_OS_INTERRUPT_LIMIT_AND_FBIF_CTX_ERROR                            (0x00000500)
#define NVC9B0_OS_INTERRUPT_HALT_ENGINE                                         (0x00000600)
#define NVC9B0_OS_INTERRUPT_TRAP_NONSTALL                                       (0x00000700)
#define NVC9B0_H264_VLD_ERR_SEQ_DATA_INCONSISTENT                               (0x00004001)
#define NVC9B0_H264_VLD_ERR_PIC_DATA_INCONSISTENT                               (0x00004002)
#define NVC9B0_H264_VLD_ERR_SLC_DATA_BUF_ADDR_OUT_OF_BOUNDS                     (0x00004100)
#define NVC9B0_H264_VLD_ERR_BITSTREAM_ERROR                                     (0x00004101)
#define NVC9B0_H264_VLD_ERR_CTX_DMA_ID_CTRL_IN_INVALID                          (0x000041F8)
#define NVC9B0_H264_VLD_ERR_SLC_HDR_OUT_SIZE_NOT_MULT256                        (0x00004200)
#define NVC9B0_H264_VLD_ERR_SLC_DATA_OUT_SIZE_NOT_MULT256                       (0x00004201)
#define NVC9B0_H264_VLD_ERR_CTX_DMA_ID_FLOW_CTRL_INVALID                        (0x00004203)
#define NVC9B0_H264_VLD_ERR_CTX_DMA_ID_SLC_HDR_OUT_INVALID                      (0x00004204)
#define NVC9B0_H264_VLD_ERR_SLC_HDR_OUT_BUF_TOO_SMALL                           (0x00004205)
#define NVC9B0_H264_VLD_ERR_SLC_HDR_OUT_BUF_ALREADY_VALID                       (0x00004206)
#define NVC9B0_H264_VLD_ERR_SLC_DATA_OUT_BUF_TOO_SMALL                          (0x00004207)
#define NVC9B0_H264_VLD_ERR_DATA_BUF_CNT_TOO_SMALL                              (0x00004208)
#define NVC9B0_H264_VLD_ERR_BITSTREAM_EMPTY                                     (0x00004209)
#define NVC9B0_H264_VLD_ERR_FRAME_WIDTH_TOO_LARGE                               (0x0000420A)
#define NVC9B0_H264_VLD_ERR_FRAME_HEIGHT_TOO_LARGE                              (0x0000420B)
#define NVC9B0_H264_VLD_ERR_HIST_BUF_TOO_SMALL                                  (0x00004300)
#define NVC9B0_VC1_VLD_ERR_PIC_DATA_BUF_ADDR_OUT_OF_BOUND                       (0x00005100)
#define NVC9B0_VC1_VLD_ERR_BITSTREAM_ERROR                                      (0x00005101)
#define NVC9B0_VC1_VLD_ERR_PIC_HDR_OUT_SIZE_NOT_MULT256                         (0x00005200)
#define NVC9B0_VC1_VLD_ERR_PIC_DATA_OUT_SIZE_NOT_MULT256                        (0x00005201)
#define NVC9B0_VC1_VLD_ERR_CTX_DMA_ID_CTRL_IN_INVALID                           (0x00005202)
#define NVC9B0_VC1_VLD_ERR_CTX_DMA_ID_FLOW_CTRL_INVALID                         (0x00005203)
#define NVC9B0_VC1_VLD_ERR_CTX_DMA_ID_PIC_HDR_OUT_INVALID                       (0x00005204)
#define NVC9B0_VC1_VLD_ERR_SLC_HDR_OUT_BUF_TOO_SMALL                            (0x00005205)
#define NVC9B0_VC1_VLD_ERR_PIC_HDR_OUT_BUF_ALREADY_VALID                        (0x00005206)
#define NVC9B0_VC1_VLD_ERR_PIC_DATA_OUT_BUF_TOO_SMALL                           (0x00005207)
#define NVC9B0_VC1_VLD_ERR_DATA_INFO_IN_BUF_TOO_SMALL                           (0x00005208)
#define NVC9B0_VC1_VLD_ERR_BITSTREAM_EMPTY                                      (0x00005209)
#define NVC9B0_VC1_VLD_ERR_FRAME_WIDTH_TOO_LARGE                                (0x0000520A)
#define NVC9B0_VC1_VLD_ERR_FRAME_HEIGHT_TOO_LARGE                               (0x0000520B)
#define NVC9B0_VC1_VLD_ERR_PIC_DATA_OUT_BUF_FULL_TIME_OUT                       (0x00005300)
#define NVC9B0_MPEG12_VLD_ERR_SLC_DATA_BUF_ADDR_OUT_OF_BOUNDS                   (0x00006100)
#define NVC9B0_MPEG12_VLD_ERR_BITSTREAM_ERROR                                   (0x00006101)
#define NVC9B0_MPEG12_VLD_ERR_SLC_DATA_OUT_SIZE_NOT_MULT256                     (0x00006200)
#define NVC9B0_MPEG12_VLD_ERR_CTX_DMA_ID_CTRL_IN_INVALID                        (0x00006201)
#define NVC9B0_MPEG12_VLD_ERR_CTX_DMA_ID_FLOW_CTRL_INVALID                      (0x00006202)
#define NVC9B0_MPEG12_VLD_ERR_SLC_DATA_OUT_BUF_TOO_SMALL                        (0x00006203)
#define NVC9B0_MPEG12_VLD_ERR_DATA_INFO_IN_BUF_TOO_SMALL                        (0x00006204)
#define NVC9B0_MPEG12_VLD_ERR_BITSTREAM_EMPTY                                   (0x00006205)
#define NVC9B0_MPEG12_VLD_ERR_INVALID_PIC_STRUCTURE                             (0x00006206)
#define NVC9B0_MPEG12_VLD_ERR_INVALID_PIC_CODING_TYPE                           (0x00006207)
#define NVC9B0_MPEG12_VLD_ERR_FRAME_WIDTH_TOO_LARGE                             (0x00006208)
#define NVC9B0_MPEG12_VLD_ERR_FRAME_HEIGHT_TOO_LARGE                            (0x00006209)
#define NVC9B0_MPEG12_VLD_ERR_SLC_DATA_OUT_BUF_FULL_TIME_OUT                    (0x00006300)
#define NVC9B0_CMN_VLD_ERR_PDEC_RETURNED_ERROR                                  (0x00007101)
#define NVC9B0_CMN_VLD_ERR_EDOB_FLUSH_TIME_OUT                                  (0x00007102)
#define NVC9B0_CMN_VLD_ERR_EDOB_REWIND_TIME_OUT                                 (0x00007103)
#define NVC9B0_CMN_VLD_ERR_VLD_WD_TIME_OUT                                      (0x00007104)
#define NVC9B0_CMN_VLD_ERR_NUM_SLICES_ZERO                                      (0x00007105)
#define NVC9B0_MPEG4_VLD_ERR_PIC_DATA_BUF_ADDR_OUT_OF_BOUND                     (0x00008100)
#define NVC9B0_MPEG4_VLD_ERR_BITSTREAM_ERROR                                    (0x00008101)
#define NVC9B0_MPEG4_VLD_ERR_PIC_HDR_OUT_SIZE_NOT_MULT256                       (0x00008200)
#define NVC9B0_MPEG4_VLD_ERR_PIC_DATA_OUT_SIZE_NOT_MULT256                      (0x00008201)
#define NVC9B0_MPEG4_VLD_ERR_CTX_DMA_ID_CTRL_IN_INVALID                         (0x00008202)
#define NVC9B0_MPEG4_VLD_ERR_CTX_DMA_ID_FLOW_CTRL_INVALID                       (0x00008203)
#define NVC9B0_MPEG4_VLD_ERR_CTX_DMA_ID_PIC_HDR_OUT_INVALID                     (0x00008204)
#define NVC9B0_MPEG4_VLD_ERR_SLC_HDR_OUT_BUF_TOO_SMALL                          (0x00008205)
#define NVC9B0_MPEG4_VLD_ERR_PIC_HDR_OUT_BUF_ALREADY_VALID                      (0x00008206)
#define NVC9B0_MPEG4_VLD_ERR_PIC_DATA_OUT_BUF_TOO_SMALL                         (0x00008207)
#define NVC9B0_MPEG4_VLD_ERR_DATA_INFO_IN_BUF_TOO_SMALL                         (0x00008208)
#define NVC9B0_MPEG4_VLD_ERR_BITSTREAM_EMPTY                                    (0x00008209)
#define NVC9B0_MPEG4_VLD_ERR_FRAME_WIDTH_TOO_LARGE                              (0x0000820A)
#define NVC9B0_MPEG4_VLD_ERR_FRAME_HEIGHT_TOO_LARGE                             (0x0000820B)
#define NVC9B0_MPEG4_VLD_ERR_PIC_DATA_OUT_BUF_FULL_TIME_OUT                     (0x00051E01)
#define NVC9B0_DEC_ERROR_MPEG12_APPTIMER_EXPIRED                                (0xDEC10001)
#define NVC9B0_DEC_ERROR_MPEG12_MVTIMER_EXPIRED                                 (0xDEC10002)
#define NVC9B0_DEC_ERROR_MPEG12_INVALID_TOKEN                                   (0xDEC10003)
#define NVC9B0_DEC_ERROR_MPEG12_SLICEDATA_MISSING                               (0xDEC10004)
#define NVC9B0_DEC_ERROR_MPEG12_HWERR_INTERRUPT                                 (0xDEC10005)
#define NVC9B0_DEC_ERROR_MPEG12_DETECTED_VLD_FAILURE                            (0xDEC10006)
#define NVC9B0_DEC_ERROR_MPEG12_PICTURE_INIT                                    (0xDEC10100)
#define NVC9B0_DEC_ERROR_MPEG12_STATEMACHINE_FAILURE                            (0xDEC10101)
#define NVC9B0_DEC_ERROR_MPEG12_INVALID_CTXID_PIC                               (0xDEC10901)
#define NVC9B0_DEC_ERROR_MPEG12_INVALID_CTXID_UCODE                             (0xDEC10902)
#define NVC9B0_DEC_ERROR_MPEG12_INVALID_CTXID_FC                                (0xDEC10903)
#define NVC9B0_DEC_ERROR_MPEG12_INVALID_CTXID_SLH                               (0xDEC10904)
#define NVC9B0_DEC_ERROR_MPEG12_INVALID_UCODE_SIZE                              (0xDEC10905)
#define NVC9B0_DEC_ERROR_MPEG12_INVALID_SLICE_COUNT                             (0xDEC10906)
#define NVC9B0_DEC_ERROR_VC1_APPTIMER_EXPIRED                                   (0xDEC20001)
#define NVC9B0_DEC_ERROR_VC1_MVTIMER_EXPIRED                                    (0xDEC20002)
#define NVC9B0_DEC_ERROR_VC1_INVALID_TOKEN                                      (0xDEC20003)
#define NVC9B0_DEC_ERROR_VC1_SLICEDATA_MISSING                                  (0xDEC20004)
#define NVC9B0_DEC_ERROR_VC1_HWERR_INTERRUPT                                    (0xDEC20005)
#define NVC9B0_DEC_ERROR_VC1_DETECTED_VLD_FAILURE                               (0xDEC20006)
#define NVC9B0_DEC_ERROR_VC1_TIMEOUT_POLLING_FOR_DATA                           (0xDEC20007)
#define NVC9B0_DEC_ERROR_VC1_PDEC_PIC_END_UNALIGNED                             (0xDEC20008)
#define NVC9B0_DEC_ERROR_VC1_WDTIMER_EXPIRED                                    (0xDEC20009)
#define NVC9B0_DEC_ERROR_VC1_ERRINTSTART                                        (0xDEC20010)
#define NVC9B0_DEC_ERROR_VC1_IQT_ERRINT                                         (0xDEC20011)
#define NVC9B0_DEC_ERROR_VC1_MC_ERRINT                                          (0xDEC20012)
#define NVC9B0_DEC_ERROR_VC1_MC_IQT_ERRINT                                      (0xDEC20013)
#define NVC9B0_DEC_ERROR_VC1_REC_ERRINT                                         (0xDEC20014)
#define NVC9B0_DEC_ERROR_VC1_REC_IQT_ERRINT                                     (0xDEC20015)
#define NVC9B0_DEC_ERROR_VC1_REC_MC_ERRINT                                      (0xDEC20016)
#define NVC9B0_DEC_ERROR_VC1_REC_MC_IQT_ERRINT                                  (0xDEC20017)
#define NVC9B0_DEC_ERROR_VC1_DBF_ERRINT                                         (0xDEC20018)
#define NVC9B0_DEC_ERROR_VC1_DBF_IQT_ERRINT                                     (0xDEC20019)
#define NVC9B0_DEC_ERROR_VC1_DBF_MC_ERRINT                                      (0xDEC2001A)
#define NVC9B0_DEC_ERROR_VC1_DBF_MC_IQT_ERRINT                                  (0xDEC2001B)
#define NVC9B0_DEC_ERROR_VC1_DBF_REC_ERRINT                                     (0xDEC2001C)
#define NVC9B0_DEC_ERROR_VC1_DBF_REC_IQT_ERRINT                                 (0xDEC2001D)
#define NVC9B0_DEC_ERROR_VC1_DBF_REC_MC_ERRINT                                  (0xDEC2001E)
#define NVC9B0_DEC_ERROR_VC1_DBF_REC_MC_IQT_ERRINT                              (0xDEC2001F)
#define NVC9B0_DEC_ERROR_VC1_PICTURE_INIT                                       (0xDEC20100)
#define NVC9B0_DEC_ERROR_VC1_STATEMACHINE_FAILURE                               (0xDEC20101)
#define NVC9B0_DEC_ERROR_VC1_INVALID_CTXID_PIC                                  (0xDEC20901)
#define NVC9B0_DEC_ERROR_VC1_INVALID_CTXID_UCODE                                (0xDEC20902)
#define NVC9B0_DEC_ERROR_VC1_INVALID_CTXID_FC                                   (0xDEC20903)
#define NVC9B0_DEC_ERROR_VC1_INVAILD_CTXID_SLH                                  (0xDEC20904)
#define NVC9B0_DEC_ERROR_VC1_INVALID_UCODE_SIZE                                 (0xDEC20905)
#define NVC9B0_DEC_ERROR_VC1_INVALID_SLICE_COUNT                                (0xDEC20906)
#define NVC9B0_DEC_ERROR_H264_APPTIMER_EXPIRED                                  (0xDEC30001)
#define NVC9B0_DEC_ERROR_H264_MVTIMER_EXPIRED                                   (0xDEC30002)
#define NVC9B0_DEC_ERROR_H264_INVALID_TOKEN                                     (0xDEC30003)
#define NVC9B0_DEC_ERROR_H264_SLICEDATA_MISSING                                 (0xDEC30004)
#define NVC9B0_DEC_ERROR_H264_HWERR_INTERRUPT                                   (0xDEC30005)
#define NVC9B0_DEC_ERROR_H264_DETECTED_VLD_FAILURE                              (0xDEC30006)
#define NVC9B0_DEC_ERROR_H264_ERRINTSTART                                       (0xDEC30010)
#define NVC9B0_DEC_ERROR_H264_IQT_ERRINT                                        (0xDEC30011)
#define NVC9B0_DEC_ERROR_H264_MC_ERRINT                                         (0xDEC30012)
#define NVC9B0_DEC_ERROR_H264_MC_IQT_ERRINT                                     (0xDEC30013)
#define NVC9B0_DEC_ERROR_H264_REC_ERRINT                                        (0xDEC30014)
#define NVC9B0_DEC_ERROR_H264_REC_IQT_ERRINT                                    (0xDEC30015)
#define NVC9B0_DEC_ERROR_H264_REC_MC_ERRINT                                     (0xDEC30016)
#define NVC9B0_DEC_ERROR_H264_REC_MC_IQT_ERRINT                                 (0xDEC30017)
#define NVC9B0_DEC_ERROR_H264_DBF_ERRINT                                        (0xDEC30018)
#define NVC9B0_DEC_ERROR_H264_DBF_IQT_ERRINT                                    (0xDEC30019)
#define NVC9B0_DEC_ERROR_H264_DBF_MC_ERRINT                                     (0xDEC3001A)
#define NVC9B0_DEC_ERROR_H264_DBF_MC_IQT_ERRINT                                 (0xDEC3001B)
#define NVC9B0_DEC_ERROR_H264_DBF_REC_ERRINT                                    (0xDEC3001C)
#define NVC9B0_DEC_ERROR_H264_DBF_REC_IQT_ERRINT                                (0xDEC3001D)
#define NVC9B0_DEC_ERROR_H264_DBF_REC_MC_ERRINT                                 (0xDEC3001E)
#define NVC9B0_DEC_ERROR_H264_DBF_REC_MC_IQT_ERRINT                             (0xDEC3001F)
#define NVC9B0_DEC_ERROR_H264_PICTURE_INIT                                      (0xDEC30100)
#define NVC9B0_DEC_ERROR_H264_STATEMACHINE_FAILURE                              (0xDEC30101)
#define NVC9B0_DEC_ERROR_H264_INVALID_CTXID_PIC                                 (0xDEC30901)
#define NVC9B0_DEC_ERROR_H264_INVALID_CTXID_UCODE                               (0xDEC30902)
#define NVC9B0_DEC_ERROR_H264_INVALID_CTXID_FC                                  (0xDEC30903)
#define NVC9B0_DEC_ERROR_H264_INVALID_CTXID_SLH                                 (0xDEC30904)
#define NVC9B0_DEC_ERROR_H264_INVALID_UCODE_SIZE                                (0xDEC30905)
#define NVC9B0_DEC_ERROR_H264_INVALID_SLICE_COUNT                               (0xDEC30906)
#define NVC9B0_DEC_ERROR_MPEG4_APPTIMER_EXPIRED                                 (0xDEC40001)
#define NVC9B0_DEC_ERROR_MPEG4_MVTIMER_EXPIRED                                  (0xDEC40002)
#define NVC9B0_DEC_ERROR_MPEG4_INVALID_TOKEN                                    (0xDEC40003)
#define NVC9B0_DEC_ERROR_MPEG4_SLICEDATA_MISSING                                (0xDEC40004)
#define NVC9B0_DEC_ERROR_MPEG4_HWERR_INTERRUPT                                  (0xDEC40005)
#define NVC9B0_DEC_ERROR_MPEG4_DETECTED_VLD_FAILURE                             (0xDEC40006)
#define NVC9B0_DEC_ERROR_MPEG4_TIMEOUT_POLLING_FOR_DATA                         (0xDEC40007)
#define NVC9B0_DEC_ERROR_MPEG4_PDEC_PIC_END_UNALIGNED                           (0xDEC40008)
#define NVC9B0_DEC_ERROR_MPEG4_WDTIMER_EXPIRED                                  (0xDEC40009)
#define NVC9B0_DEC_ERROR_MPEG4_ERRINTSTART                                      (0xDEC40010)
#define NVC9B0_DEC_ERROR_MPEG4_IQT_ERRINT                                       (0xDEC40011)
#define NVC9B0_DEC_ERROR_MPEG4_MC_ERRINT                                        (0xDEC40012)
#define NVC9B0_DEC_ERROR_MPEG4_MC_IQT_ERRINT                                    (0xDEC40013)
#define NVC9B0_DEC_ERROR_MPEG4_REC_ERRINT                                       (0xDEC40014)
#define NVC9B0_DEC_ERROR_MPEG4_REC_IQT_ERRINT                                   (0xDEC40015)
#define NVC9B0_DEC_ERROR_MPEG4_REC_MC_ERRINT                                    (0xDEC40016)
#define NVC9B0_DEC_ERROR_MPEG4_REC_MC_IQT_ERRINT                                (0xDEC40017)
#define NVC9B0_DEC_ERROR_MPEG4_DBF_ERRINT                                       (0xDEC40018)
#define NVC9B0_DEC_ERROR_MPEG4_DBF_IQT_ERRINT                                   (0xDEC40019)
#define NVC9B0_DEC_ERROR_MPEG4_DBF_MC_ERRINT                                    (0xDEC4001A)
#define NVC9B0_DEC_ERROR_MPEG4_DBF_MC_IQT_ERRINT                                (0xDEC4001B)
#define NVC9B0_DEC_ERROR_MPEG4_DBF_REC_ERRINT                                   (0xDEC4001C)
#define NVC9B0_DEC_ERROR_MPEG4_DBF_REC_IQT_ERRINT                               (0xDEC4001D)
#define NVC9B0_DEC_ERROR_MPEG4_DBF_REC_MC_ERRINT                                (0xDEC4001E)
#define NVC9B0_DEC_ERROR_MPEG4_DBF_REC_MC_IQT_ERRINT                            (0xDEC4001F)
#define NVC9B0_DEC_ERROR_MPEG4_PICTURE_INIT                                     (0xDEC40100)
#define NVC9B0_DEC_ERROR_MPEG4_STATEMACHINE_FAILURE                             (0xDEC40101)
#define NVC9B0_DEC_ERROR_MPEG4_INVALID_CTXID_PIC                                (0xDEC40901)
#define NVC9B0_DEC_ERROR_MPEG4_INVALID_CTXID_UCODE                              (0xDEC40902)
#define NVC9B0_DEC_ERROR_MPEG4_INVALID_CTXID_FC                                 (0xDEC40903)
#define NVC9B0_DEC_ERROR_MPEG4_INVALID_CTXID_SLH                                (0xDEC40904)
#define NVC9B0_DEC_ERROR_MPEG4_INVALID_UCODE_SIZE                               (0xDEC40905)
#define NVC9B0_DEC_ERROR_MPEG4_INVALID_SLICE_COUNT                              (0xDEC40906)

#ifdef __cplusplus
};     /* extern "C" */
#endif
#endif // clc9b0_h

