# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Property to select authentication type to access the selected storage account. Available
    options: SystemAssignedIdentity, UserAssignedIdentity, StorageAccountConnectionString.
    """

    SYSTEM_ASSIGNED_IDENTITY = "SystemAssignedIdentity"
    USER_ASSIGNED_IDENTITY = "UserAssignedIdentity"
    STORAGE_ACCOUNT_CONNECTION_STRING = "StorageAccountConnectionString"


class AutoGeneratedDomainNameLabelScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the scope of uniqueness for the default hostname during resource creation."""

    TENANT_REUSE = "TenantReuse"
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    NO_REUSE = "NoReuse"


class AutoHealActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Predefined action to be taken."""

    RECYCLE = "Recycle"
    LOG_EVENT = "LogEvent"
    CUSTOM_ACTION = "CustomAction"


class AzureResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Azure resource type."""

    WEBSITE = "Website"
    TRAFFIC_MANAGER = "TrafficManager"


class AzureStorageProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Mounting protocol to use for the storage account."""

    SMB = "Smb"
    HTTP = "Http"
    NFS = "Nfs"


class AzureStorageState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the storage account."""

    OK = "Ok"
    INVALID_CREDENTIALS = "InvalidCredentials"
    INVALID_SHARE = "InvalidShare"
    NOT_VALIDATED = "NotValidated"


class AzureStorageType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of storage."""

    AZURE_FILES = "AzureFiles"
    AZURE_BLOB = "AzureBlob"


class CertificateOrderActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Action type."""

    CERTIFICATE_ISSUED = "CertificateIssued"
    CERTIFICATE_ORDER_CANCELED = "CertificateOrderCanceled"
    CERTIFICATE_ORDER_CREATED = "CertificateOrderCreated"
    CERTIFICATE_REVOKED = "CertificateRevoked"
    DOMAIN_VALIDATION_COMPLETE = "DomainValidationComplete"
    FRAUD_DETECTED = "FraudDetected"
    ORG_NAME_CHANGE = "OrgNameChange"
    ORG_VALIDATION_COMPLETE = "OrgValidationComplete"
    SAN_DROP = "SanDrop"
    FRAUD_CLEARED = "FraudCleared"
    CERTIFICATE_EXPIRED = "CertificateExpired"
    CERTIFICATE_EXPIRATION_WARNING = "CertificateExpirationWarning"
    FRAUD_DOCUMENTATION_REQUIRED = "FraudDocumentationRequired"
    UNKNOWN = "Unknown"


class CertificateOrderStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current order status."""

    PENDINGISSUANCE = "Pendingissuance"
    ISSUED = "Issued"
    REVOKED = "Revoked"
    CANCELED = "Canceled"
    DENIED = "Denied"
    PENDINGREVOCATION = "Pendingrevocation"
    PENDING_REKEY = "PendingRekey"
    UNUSED = "Unused"
    EXPIRED = "Expired"
    NOT_SUBMITTED = "NotSubmitted"


class CertificateProductType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Certificate product type."""

    STANDARD_DOMAIN_VALIDATED_SSL = "StandardDomainValidatedSsl"
    STANDARD_DOMAIN_VALIDATED_WILD_CARD_SSL = "StandardDomainValidatedWildCardSsl"


class ClientCertMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This composes with ClientCertEnabled setting.


    * ClientCertEnabled: false means ClientCert is ignored.
    * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
    * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
    accepted.
    """

    REQUIRED = "Required"
    OPTIONAL = "Optional"
    OPTIONAL_INTERACTIVE_USER = "OptionalInteractiveUser"


class ConnectionStringType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of database."""

    MY_SQL = "MySql"
    SQL_SERVER = "SQLServer"
    SQL_AZURE = "SQLAzure"
    CUSTOM = "Custom"
    NOTIFICATION_HUB = "NotificationHub"
    SERVICE_BUS = "ServiceBus"
    EVENT_HUB = "EventHub"
    API_HUB = "ApiHub"
    DOC_DB = "DocDb"
    REDIS_CACHE = "RedisCache"
    POSTGRE_SQL = "PostgreSQL"


class CustomDnsSuffixProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CustomDnsSuffixProvisioningState."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    DEGRADED = "Degraded"
    IN_PROGRESS = "InProgress"


class CustomHostNameDnsRecordType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Custom DNS record type."""

    C_NAME = "CName"
    A = "A"


class DaprLogLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default
    is info.
    """

    INFO = "info"
    DEBUG = "debug"
    WARN = "warn"
    ERROR = "error"


class DefaultAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Default action for main access restriction if no rules are matched."""

    ALLOW = "Allow"
    DENY = "Deny"


class DetectorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether this detector is an Analysis Detector or not."""

    DETECTOR = "Detector"
    ANALYSIS = "Analysis"
    CATEGORY_OVERVIEW = "CategoryOverview"


class FtpsState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of FTP / FTPS service."""

    ALL_ALLOWED = "AllAllowed"
    FTPS_ONLY = "FtpsOnly"
    DISABLED = "Disabled"


class FunctionsDeploymentStorageType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Property to select Azure Storage type. Available options: blobContainer."""

    BLOB_CONTAINER = "blobContainer"


class HostingEnvironmentStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current status of the App Service Environment."""

    PREPARING = "Preparing"
    READY = "Ready"
    SCALING = "Scaling"
    DELETING = "Deleting"


class HostNameType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Hostname type."""

    VERIFIED = "Verified"
    MANAGED = "Managed"


class HostType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the hostname is a standard or repository hostname."""

    STANDARD = "Standard"
    REPOSITORY = "Repository"


class InsightStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Level of the most severe insight generated by the detector."""

    CRITICAL = "Critical"
    WARNING = "Warning"
    INFO = "Info"
    SUCCESS = "Success"
    NONE = "None"


class IpFilterTag(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines what this IP filter will be used for. This is to support IP filtering on proxies."""

    DEFAULT = "Default"
    XFF_PROXY = "XffProxy"
    SERVICE_TAG = "ServiceTag"


class IPMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the IP mode of the app."""

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"
    I_PV4_AND_I_PV6 = "IPv4AndIPv6"


class KeyVaultSecretStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the Key Vault secret."""

    INITIALIZED = "Initialized"
    WAITING_ON_CERTIFICATE_ORDER = "WaitingOnCertificateOrder"
    SUCCEEDED = "Succeeded"
    CERTIFICATE_ORDER_FAILED = "CertificateOrderFailed"
    OPERATION_NOT_PERMITTED_ON_KEY_VAULT = "OperationNotPermittedOnKeyVault"
    AZURE_SERVICE_UNAUTHORIZED_TO_ACCESS_KEY_VAULT = "AzureServiceUnauthorizedToAccessKeyVault"
    KEY_VAULT_DOES_NOT_EXIST = "KeyVaultDoesNotExist"
    KEY_VAULT_SECRET_DOES_NOT_EXIST = "KeyVaultSecretDoesNotExist"
    UNKNOWN_ERROR = "UnknownError"
    EXTERNAL_PRIVATE_KEY = "ExternalPrivateKey"
    UNKNOWN = "Unknown"


class LoadBalancingMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies which endpoints to serve internally in the Virtual Network for the App Service
    Environment.
    """

    NONE = "None"
    WEB = "Web"
    PUBLISHING = "Publishing"
    WEB_PUBLISHING = "Web, Publishing"


class ManagedPipelineMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Managed pipeline mode."""

    INTEGRATED = "Integrated"
    CLASSIC = "Classic"


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the operation."""

    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    TIMED_OUT = "TimedOut"
    CREATED = "Created"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of certificate order."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    IN_PROGRESS = "InProgress"
    DELETING = "Deleting"


class RedundancyMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Site redundancy mode."""

    NONE = "None"
    MANUAL = "Manual"
    FAILOVER = "Failover"
    ACTIVE_ACTIVE = "ActiveActive"
    GEO_REDUNDANT = "GeoRedundant"


class RenderingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Rendering Type."""

    NO_GRAPH = "NoGraph"
    TABLE = "Table"
    TIME_SERIES = "TimeSeries"
    TIME_SERIES_PER_INSTANCE = "TimeSeriesPerInstance"
    PIE_CHART = "PieChart"
    DATA_SUMMARY = "DataSummary"
    EMAIL = "Email"
    INSIGHTS = "Insights"
    DYNAMIC_INSIGHT = "DynamicInsight"
    MARKDOWN = "Markdown"
    DETECTOR = "Detector"
    DROP_DOWN = "DropDown"
    CARD = "Card"
    SOLUTION = "Solution"
    GUAGE = "Guage"
    FORM = "Form"
    CHANGE_SETS = "ChangeSets"
    CHANGE_ANALYSIS_ONBOARDING = "ChangeAnalysisOnboarding"
    CHANGES_VIEW = "ChangesView"
    APP_INSIGHT = "AppInsight"
    DEPENDENCY_GRAPH = "DependencyGraph"
    DOWN_TIME = "DownTime"
    SUMMARY_CARD = "SummaryCard"
    SEARCH_COMPONENT = "SearchComponent"
    APP_INSIGHT_ENABLEMENT = "AppInsightEnablement"


class ResourceNotRenewableReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ResourceNotRenewableReason."""

    REGISTRATION_STATUS_NOT_SUPPORTED_FOR_RENEWAL = "RegistrationStatusNotSupportedForRenewal"
    EXPIRATION_NOT_IN_RENEWAL_TIME_RANGE = "ExpirationNotInRenewalTimeRange"
    SUBSCRIPTION_NOT_ACTIVE = "SubscriptionNotActive"


class RouteType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of route this is:
    DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
    INHERITED - Routes inherited from the real Virtual Network routes
    STATIC - Static route set on the app only

    These values will be used for syncing an app's routes with those from a Virtual Network.
    """

    DEFAULT = "DEFAULT"
    INHERITED = "INHERITED"
    STATIC = "STATIC"


class RuntimeName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Function app runtime name. Available options: dotnet-isolated, node, java, powershell, python,
    custom.
    """

    DOTNET_ISOLATED = "dotnet-isolated"
    NODE = "node"
    JAVA = "java"
    POWERSHELL = "powershell"
    PYTHON = "python"
    CUSTOM = "custom"


class ScmType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SCM type."""

    NONE = "None"
    DROPBOX = "Dropbox"
    TFS = "Tfs"
    LOCAL_GIT = "LocalGit"
    GIT_HUB = "GitHub"
    CODE_PLEX_GIT = "CodePlexGit"
    CODE_PLEX_HG = "CodePlexHg"
    BITBUCKET_GIT = "BitbucketGit"
    BITBUCKET_HG = "BitbucketHg"
    EXTERNAL_GIT = "ExternalGit"
    EXTERNAL_HG = "ExternalHg"
    ONE_DRIVE = "OneDrive"
    VSO = "VSO"
    VSTSRM = "VSTSRM"


class SiteAvailabilityState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Management information availability state for the app."""

    NORMAL = "Normal"
    LIMITED = "Limited"
    DISASTER_RECOVERY_MODE = "DisasterRecoveryMode"


class SiteLoadBalancing(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Site load balancing."""

    WEIGHTED_ROUND_ROBIN = "WeightedRoundRobin"
    LEAST_REQUESTS = "LeastRequests"
    LEAST_RESPONSE_TIME = "LeastResponseTime"
    WEIGHTED_TOTAL_TRAFFIC = "WeightedTotalTraffic"
    REQUEST_HASH = "RequestHash"
    PER_SITE_ROUND_ROBIN = "PerSiteRoundRobin"
    LEAST_REQUESTS_WITH_TIE_BREAKER = "LeastRequestsWithTieBreaker"


class SslState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SSL type."""

    DISABLED = "Disabled"
    SNI_ENABLED = "SniEnabled"
    IP_BASED_ENABLED = "IpBasedEnabled"


class StatusOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """App Service plan status."""

    READY = "Ready"
    PENDING = "Pending"
    CREATING = "Creating"


class SupportedTlsVersions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MinTlsVersion: configures the minimum version of TLS required for SSL requests."""

    ONE0 = "1.0"
    ONE1 = "1.1"
    ONE2 = "1.2"
    ONE3 = "1.3"


class TlsCipherSuites(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The minimum strength TLS cipher suite allowed for an application."""

    TLS_AES256_GCM_SHA384 = "TLS_AES_256_GCM_SHA384"
    TLS_AES128_GCM_SHA256 = "TLS_AES_128_GCM_SHA256"
    TLS_ECDHE_ECDSA_WITH_AES256_GCM_SHA384 = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"
    TLS_ECDHE_ECDSA_WITH_AES128_CBC_SHA256 = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"
    TLS_ECDHE_ECDSA_WITH_AES128_GCM_SHA256 = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"
    TLS_ECDHE_RSA_WITH_AES256_GCM_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"
    TLS_ECDHE_RSA_WITH_AES128_GCM_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"
    TLS_ECDHE_RSA_WITH_AES256_CBC_SHA384 = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384"
    TLS_ECDHE_RSA_WITH_AES128_CBC_SHA256 = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"
    TLS_ECDHE_RSA_WITH_AES256_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"
    TLS_ECDHE_RSA_WITH_AES128_CBC_SHA = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"
    TLS_RSA_WITH_AES256_GCM_SHA384 = "TLS_RSA_WITH_AES_256_GCM_SHA384"
    TLS_RSA_WITH_AES128_GCM_SHA256 = "TLS_RSA_WITH_AES_128_GCM_SHA256"
    TLS_RSA_WITH_AES256_CBC_SHA256 = "TLS_RSA_WITH_AES_256_CBC_SHA256"
    TLS_RSA_WITH_AES128_CBC_SHA256 = "TLS_RSA_WITH_AES_128_CBC_SHA256"
    TLS_RSA_WITH_AES256_CBC_SHA = "TLS_RSA_WITH_AES_256_CBC_SHA"
    TLS_RSA_WITH_AES128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA"


class UpgradeAvailability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether an upgrade is available for this App Service Environment."""

    NONE = "None"
    """No upgrade is currently available for this App Service Environment"""
    READY = "Ready"
    """An upgrade is ready to be manually initiated on this App Service Environment"""


class UpgradePreference(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Upgrade Preference."""

    NONE = "None"
    """No preference on when this App Service Environment will be upgraded"""
    EARLY = "Early"
    """This App Service Environment will be upgraded before others in the same region that have
    Upgrade Preference 'Late'"""
    LATE = "Late"
    """This App Service Environment will be upgraded after others in the same region that have Upgrade
    Preference 'Early'"""
    MANUAL = "Manual"
    """ASEv3 only. Once an upgrade is available, this App Service Environment will wait 10 days for
    the upgrade to be manually initiated. After 10 days the upgrade will begin automatically"""


class UsageState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State indicating whether the app has exceeded its quota usage. Read-only."""

    NORMAL = "Normal"
    EXCEEDED = "Exceeded"
