% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zeallous.R
\name{zeallous}
\alias{zeallous}
\title{Allow zeallous assignment}
\usage{
zeallous()
}
\description{
Using zeallot within an R package may cause \verb{R CMD check} to raise NOTEs
concerning variables with \code{"no visible binding"}. To avoid these NOTEs,
include a call to \code{zeallous()} in a package's \code{.onLoad()} function.
}
\details{
The \verb{R CMD check} process uses a package \code{{codetools}} to check for assigned
variables. However, due to the non-standard nature of zeallot assignment the
codetools package does not identify these variables. To work around this, the
\code{zeallous()} function modifies the variables found by codetools to avoid
the NOTEs raised by \verb{R CMD check}.
}
\examples{

.onLoad <- function(libname, pkgname) {
  zeallous()
}

}
