#!./perl

BEGIN {
    chdir 't' if -d 't';
    require './test.pl';
    set_up_inc('../lib');
    require Config;

    skip_all_without_config('useithreads');
    skip_all_if_miniperl("no dynamic loading on miniperl, no threads");
}

use v5.36;
use feature 'class';
no warnings 'experimental::class';

use threads;

class Testcase1 {
    field $x :param;
    method x { return $x }
}

class WithNoFields {
    # a class with no fields, in order to test [GH23771]
}

{
    my $ret = threads->create(sub {
        pass("Created dummy thread");
        return 1;
    })->join;
    next_test(); # account for pass() inside thread
    is($ret, 1, "Returned from dummy thread");
}

{
    my $obj = Testcase1->new(x => 10);
    threads->create(sub {
        is($obj->x, 10, '$obj->x inside thread created before');
    })->join;
    next_test(); # account for is() inside thread
}

class WithTwoMethods {
    # a class with two methods sharing the same field, in order to test [GH24150]
    # We don't even need to create any instances; the mere presence of this
    # class at compiletime would crash a thread join operation if the bug is
    # present. If this .t file succeeds to the end without crashing it
    # demonstrates this bug is fixed.
    field $xxx :param;
    method xxy { $xxx; }
    method xxz { $xxx; }
}

threads->create(sub {
    my $obj = Testcase1->new(x => 20);
    is($obj->x, 20, '$obj->x created inside thread');
})->join;
next_test(); # account for is() inside thread

done_testing;
