# FOLIO inventory fields used by the Z39.50 server

<!-- md2toc -l 2 inventory-fields-used.md -->
* [Introduction](#introduction)
* [Instance level](#instance-level)
* [Holdings level](#holdings-level)
* [Summary](#summary)
* [Caveat](#caveat)


## Introduction

The FOLIO Z39.50 server fetches from `mod-graphql` a representation of an instance together with its holdings and their items. This is used in two ways: to generate the `holdings` part of OPAC XML records; and to furnish the data from which MARC holdings information is inserted into MARC records.

In both cases, the form of the data that is used is what's generated by the `makeHoldingsRecords` function in `Net::Z3950::FOLIO::HoldingsRecords`, so we can determine from that function (and its subfunctions) which fields from the GraphQL response are actually used.


## Instance level

Notably, no fields at all from the instance record are used, since equivalent information is always included in the MARC record obtained from SRS and which is included as the `bibliographicRecord` part of OPAC records.

The `makeHoldingsRecords` function shows that the only relevant part of the instance record is the array of holdings objects:

| OPAC field             | FOLIO instance field          | Notes
| :--------------------- | :---------------------------- | :----
| (top level)            | `holdingsRecords2`            | See below


## Holdings level

The `_makeSingleHoldingsRecord` function (and its subfunctions) show that the following fields from the FOLIO holdings record are used (as well as information extracted from the MARC leader):

| OPAC field             | FOLIO holdings field          | Notes
| :--------------------- | :---------------------------- | :----
| `nucCode`              | `location->institution->name` | May be temporary or permanent location
| `localLocation`        | `location->library->name`     | May be temporary or permanent location
| `shelvingLocation`     | `location->name`              | May be temporary or permanent location
| `_callNumberPrefix`    | `callNumberPrefix`
| `callNumber`           | `callNumber`
| `_callNumberSuffix`    | `callNumberSuffix`
| `shelvingData`         | `shelvingTitle`
| `copyNumber`           | `copyNumber`
| `publicNote`           | `notes->holdingsNoteType->name`,<br />`notes->note`
| `reproductionNote`     | `notes->holdingsNoteType->name`,<br />`notes->note`
| `circulations`         | `bareHoldingsItems`           | See below



# Item level

The `_makeSingleItemRecord` function (and its subfunctions) show that the following fields from the FOLIO item record are used (as well as location fields from the holdings record):

| OPAC field             | FOLIO item field              | Notes |
| :--------------------- | :---------------------------- | :---- |
| `availableNow`         | `discoverySuppress`, `status->name`
| `availableThru`        | `materialType->name`
| `restrictions`         | `status->name`
| `itemId`               | `barcode`
| `_enumeration`         | `enumeration`
| `_chronology`          | `chronology`
| `enumAndChron`         | `enumeration`, `chronology`
| `temporaryLocation`    | See note 1                    | May be temporary or permanent location
| `_permanentLocation`   | See note 1                    | Based on `permanentLocation` only
| `callNumber`           | `effectiveCallNumberComponents->callNumber`
| `_callNumberPrefix`    | `effectiveCallNumberComponents->prefix`
| `_callNumberSuffix`    | `effectiveCallNumberComponents->suffix`
| `_volume`              | `volume`
| `_yearCaption`         | `yearCaption`
| `_accessionNumber`     | `accessionNumber`
| `_copyNumber`          | `copyNumber`
| `_descriptionOfPieces` | `descriptionOfPieces`
| `_discoverySuppress`   | `discoverySuppress`
| `_hrid`                | `hrid`
| `_id`                  | `id`
| `_itemIdentifier`      | `itemIdentifier`


**Note 1.**
Location calculation is complex. It uses `location->name` when that exists, and otherwise uses and or all of
`location->institution->name`,
`location->campus->name`,
`location->library->name`,
and
`location->primaryServicePointObject->name`.


## Summary

The following FOLIO-inventory fields are used in creating the Z39.50 holdings information for the OPAC record and MARC holdings:

```
holdingsRecords2
  temporaryLocation
    institution
      name
    library
      name
  permanentLocation
    institution
      name
    library
      name
  name
  callNumberPrefix
  callNumber
  callNumberSuffix
  shelvingTitle
  copyNumber
  notes
    holdingsNoteType
      name
    note
  bareHoldingsItems
    discoverySuppress
    status
      name
    materialType
      name
    barcode
    enumeration
    chronology
    temporaryLocation
      name
      institution
        name
      campus
        name
      library
        name
      primaryServicePointObject
        name
    permanentLocation
      name
      institution
        name
      campus
        name
      library
        name
      primaryServicePointObject
        name
    effectiveCallNumberComponents
      callNumber
      prefix
      suffix
    volume
    yearCaption
    accessionNumber
    copyNumber
    descriptionOfPieces
    hrid
    id
    itemIdentifier
```

## Caveat

The whole GraphQL response is included in records requested with syntax `json` nd (in transliterated form) with syntax `xml` and element-set `raw`. So fields not used in OPAC or MARC holdings may conceivable be in use by client code that uses these record syntaxes.


