/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookie;

import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerCache;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.util.LedgerIdFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToDBStorageCommand
extends BookieCommand<CTDBFlags> {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertToDBStorageCommand.class);
    private static final String NAME = "converttodbstorage";
    private static final String DESC = "Convert bookie indexes from InterleavedStorage to DbLedgerStorage format";
    private static final String NOT_INIT = "default formatter";
    private LedgerIdFormatter ledgerIdFormatter;

    public ConvertToDBStorageCommand() {
        this(new CTDBFlags());
    }

    public ConvertToDBStorageCommand(CTDBFlags flags) {
        super(CliSpec.newBuilder().withFlags((CliFlags)flags).withName(NAME).withDescription(DESC).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CTDBFlags cmdFlags) {
        this.initLedgerIdFormatter(conf, cmdFlags);
        try {
            return this.handle(conf);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean handle(ServerConfiguration conf) throws Exception {
        LOG.info("=== Converting to DbLedgerStorage ===");
        ServerConfiguration bkConf = new ServerConfiguration(conf);
        InterleavedLedgerStorage interleavedStorage = new InterleavedLedgerStorage();
        BookieImpl.mountLedgerStorageOffline(bkConf, interleavedStorage);
        DbLedgerStorage dbStorage = new DbLedgerStorage();
        BookieImpl.mountLedgerStorageOffline(bkConf, dbStorage);
        int convertedLedgers = 0;
        for (long ledgerId : interleavedStorage.getActiveLedgersInRange(0L, Long.MAX_VALUE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Converting ledger {}", (Object)this.ledgerIdFormatter.formatLedgerId(ledgerId));
            }
            LedgerCache.LedgerIndexMetadata fi = interleavedStorage.readLedgerIndexMetadata(ledgerId);
            LedgerCache.PageEntriesIterable pages = interleavedStorage.getIndexEntries(ledgerId);
            long numberOfEntries = dbStorage.addLedgerToIndex(ledgerId, fi.fenced, fi.masterKey, pages);
            if (LOG.isDebugEnabled()) {
                LOG.debug("   -- done. fenced={} entries={}", (Object)fi.fenced, (Object)numberOfEntries);
            }
            interleavedStorage.deleteLedger(ledgerId);
            if (++convertedLedgers % 1000 != 0) continue;
            LOG.info("Converted {} ledgers", (Object)convertedLedgers);
        }
        dbStorage.shutdown();
        interleavedStorage.shutdown();
        LOG.info("---- Done Converting ----");
        return true;
    }

    private void initLedgerIdFormatter(ServerConfiguration conf, CTDBFlags flags) {
        if (this.ledgerIdFormatter != null) {
            return;
        }
        this.ledgerIdFormatter = flags.ledgerIdFormatter.equals(NOT_INIT) ? LedgerIdFormatter.newLedgerIdFormatter(conf) : LedgerIdFormatter.newLedgerIdFormatter(flags.ledgerIdFormatter, conf);
    }

    public void setLedgerIdFormatter(LedgerIdFormatter ledgerIdFormatter) {
        this.ledgerIdFormatter = ledgerIdFormatter;
    }

    public static class CTDBFlags
    extends CliFlags {
        @Parameter(names={"-l", "--ledgeridformatter"}, description="Set ledger id formatter")
        private String ledgerIdFormatter = "default formatter";

        public CTDBFlags ledgerIdFormatter(String ledgerIdFormatter) {
            this.ledgerIdFormatter = ledgerIdFormatter;
            return this;
        }
    }
}

