/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.util;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.util.List;
import java.util.Optional;
import org.apache.zookeeper.common.BaseX509ParameterizedTestCase;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.zookeeper.common.X509KeyType;
import org.apache.zookeeper.util.PemReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class PemReaderTest
extends BaseX509ParameterizedTestCase {
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPrivateKeyFromKeyStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Optional optPassword = this.x509TestContext.getKeyStorePassword().length() > 0 ? Optional.of(this.x509TestContext.getKeyStorePassword()) : Optional.empty();
        PrivateKey privateKey = PemReader.loadPrivateKey((File)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM), optPassword);
        Assertions.assertEquals((Object)this.x509TestContext.getKeyStoreKeyPair().getPrivate(), (Object)privateKey);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadEncryptedPrivateKeyFromKeyStoreWithoutPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(GeneralSecurityException.class, () -> {
            if (!this.x509TestContext.isKeyStoreEncrypted()) {
                throw new GeneralSecurityException();
            }
            PemReader.loadPrivateKey((File)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM), Optional.empty());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadEncryptedPrivateKeyFromKeyStoreWithWrongPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(GeneralSecurityException.class, () -> {
            if (!this.x509TestContext.isKeyStoreEncrypted()) {
                throw new GeneralSecurityException();
            }
            PemReader.loadPrivateKey((File)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM), Optional.of("wrong password"));
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadUnencryptedPrivateKeyFromKeyStoreWithWrongPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(IOException.class, () -> {
            if (this.x509TestContext.isKeyStoreEncrypted()) {
                throw new IOException();
            }
            PemReader.loadPrivateKey((File)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM), Optional.of("wrong password"));
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPrivateKeyFromTrustStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(KeyStoreException.class, () -> PemReader.loadPrivateKey((File)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM), Optional.empty()));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPrivateKeyFromTrustStoreWithPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(KeyStoreException.class, () -> PemReader.loadPrivateKey((File)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM), Optional.of("foobar")));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadCertificateFromKeyStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        List certs = PemReader.readCertificateChain((File)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM));
        Assertions.assertEquals((int)1, (int)certs.size());
        Assertions.assertEquals((Object)this.x509TestContext.getKeyStoreCertificate(), certs.get(0));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadCertificateFromTrustStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        List certs = PemReader.readCertificateChain((File)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM));
        Assertions.assertEquals((int)1, (int)certs.size());
        Assertions.assertEquals((Object)this.x509TestContext.getTrustStoreCertificate(), certs.get(0));
    }
}

