/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.genai;

import io.opentelemetry.api.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.opentelemetry.api.incubator.metrics.ExtendedLongHistogramBuilder;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiAttributesExtractor;
import io.opentelemetry.instrumentation.api.incubator.semconv.genai.GenAiClientMetrics;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class GenAiMetricsAdvice {
    static final List<Double> CLIENT_OPERATION_DURATION_BUCKETS = Collections.unmodifiableList(Arrays.asList(0.01, 0.02, 0.04, 0.08, 0.16, 0.32, 0.64, 1.28, 2.56, 5.12, 10.24, 20.48, 40.96, 81.92));
    static final List<Long> CLIENT_TOKEN_USAGE_BUCKETS = Collections.unmodifiableList(Arrays.asList(1L, 4L, 16L, 64L, 256L, 1024L, 4096L, 16384L, 65536L, 262144L, 0x100000L, 0x400000L, 0x1000000L, 0x4000000L));

    static void applyClientTokenUsageAdvice(LongHistogramBuilder builder) {
        if (!(builder instanceof ExtendedLongHistogramBuilder)) {
            return;
        }
        ((ExtendedLongHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(GenAiAttributesExtractor.GEN_AI_OPERATION_NAME, GenAiAttributesExtractor.GEN_AI_PROVIDER_NAME, GenAiClientMetrics.GEN_AI_TOKEN_TYPE, GenAiAttributesExtractor.GEN_AI_REQUEST_MODEL, ServerAttributes.SERVER_PORT, GenAiAttributesExtractor.GEN_AI_RESPONSE_MODEL, ServerAttributes.SERVER_ADDRESS));
    }

    static void applyClientOperationDurationAdvice(DoubleHistogramBuilder builder) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        ((ExtendedDoubleHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(GenAiAttributesExtractor.GEN_AI_OPERATION_NAME, GenAiAttributesExtractor.GEN_AI_PROVIDER_NAME, ErrorAttributes.ERROR_TYPE, GenAiAttributesExtractor.GEN_AI_REQUEST_MODEL, ServerAttributes.SERVER_PORT, GenAiAttributesExtractor.GEN_AI_RESPONSE_MODEL, ServerAttributes.SERVER_ADDRESS));
    }

    private GenAiMetricsAdvice() {
    }
}

