/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.db.marshal.AbstractType;

public final class CqlBuilder {
    private static final char NEW_LINE = '\n';
    private static final String INDENTATION = "    ";
    private final StringBuilder builder;
    private int indent;
    private boolean isNewLine = false;

    public CqlBuilder() {
        this(64);
    }

    public CqlBuilder(int capacity) {
        this.builder = new StringBuilder(capacity);
    }

    public CqlBuilder append(String str) {
        this.indentIfNeeded();
        this.builder.append(str);
        return this;
    }

    public CqlBuilder appendQuotingIfNeeded(String str) {
        return this.append(ColumnIdentifier.maybeQuote(str));
    }

    public CqlBuilder appendWithSingleQuotes(String str) {
        this.indentIfNeeded();
        this.builder.append('\'').append(str.replaceAll("'", "''")).append('\'');
        return this;
    }

    public CqlBuilder append(char c) {
        this.indentIfNeeded();
        this.builder.append(c);
        return this;
    }

    public CqlBuilder append(boolean b) {
        this.indentIfNeeded();
        this.builder.append(b);
        return this;
    }

    public CqlBuilder append(int i) {
        this.indentIfNeeded();
        this.builder.append(i);
        return this;
    }

    public CqlBuilder append(long l) {
        this.indentIfNeeded();
        this.builder.append(l);
        return this;
    }

    public CqlBuilder append(float f) {
        this.indentIfNeeded();
        this.builder.append(f);
        return this;
    }

    public CqlBuilder append(double d) {
        this.indentIfNeeded();
        this.builder.append(d);
        return this;
    }

    public CqlBuilder newLine() {
        this.builder.append('\n');
        this.isNewLine = true;
        return this;
    }

    public CqlBuilder append(AbstractType<?> type) {
        return this.append(type.asCQL3Type().toString());
    }

    public CqlBuilder append(ColumnIdentifier column) {
        return this.append(column.toCQLString());
    }

    public CqlBuilder append(FunctionName name) {
        name.appendCqlTo(this);
        return this;
    }

    public CqlBuilder append(Map<String, String> map) {
        return this.append(map, true);
    }

    public CqlBuilder append(Map<String, String> map, boolean quoteValue) {
        this.indentIfNeeded();
        this.builder.append('{');
        Iterator<Map.Entry<String, String>> iter = new TreeMap<String, String>(map).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> e = iter.next();
            this.appendWithSingleQuotes(e.getKey());
            this.builder.append(": ");
            if (quoteValue) {
                this.appendWithSingleQuotes(e.getValue());
            } else {
                this.builder.append(e.getValue());
            }
            if (!iter.hasNext()) continue;
            this.builder.append(", ");
        }
        this.builder.append('}');
        return this;
    }

    public <T> CqlBuilder appendWithSeparators(Iterable<T> iterable, Appender<T> appender, String separator) {
        return this.appendWithSeparators(iterable.iterator(), appender, separator);
    }

    public <T> CqlBuilder appendWithSeparators(Iterator<T> iter, Appender<T> appender, String separator) {
        while (iter.hasNext()) {
            appender.appendTo(this, iter.next());
            if (!iter.hasNext()) continue;
            this.append(separator);
        }
        return this;
    }

    public CqlBuilder increaseIndent() {
        ++this.indent;
        return this;
    }

    public CqlBuilder decreaseIndent() {
        if (this.indent > 0) {
            --this.indent;
        }
        return this;
    }

    private void indentIfNeeded() {
        if (this.isNewLine) {
            for (int i = 0; i < this.indent; ++i) {
                this.builder.append(INDENTATION);
            }
            this.isNewLine = false;
        }
    }

    public String toString() {
        return this.builder.toString();
    }

    @FunctionalInterface
    public static interface Appender<T> {
        public void appendTo(CqlBuilder var1, T var2);
    }
}

