/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;

public abstract class NumberType<T extends Number>
extends AbstractType<T> {
    protected NumberType(AbstractType.ComparisonType comparisonType) {
        super(comparisonType);
    }

    public boolean isFloatingPoint() {
        return false;
    }

    protected BigInteger toBigInteger(ByteBuffer value) {
        return BigInteger.valueOf(this.toLong(value));
    }

    protected BigDecimal toBigDecimal(ByteBuffer value) {
        double d = this.toDouble(value);
        if (Double.isNaN(d)) {
            throw new NumberFormatException("A NaN cannot be converted into a decimal");
        }
        if (Double.isInfinite(d)) {
            throw new NumberFormatException("An infinite number cannot be converted into a decimal");
        }
        return BigDecimal.valueOf(d);
    }

    protected byte toByte(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    protected short toShort(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    protected int toInt(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    protected long toLong(ByteBuffer value) {
        return this.toInt(value);
    }

    protected float toFloat(ByteBuffer value) {
        return this.toInt(value);
    }

    protected double toDouble(ByteBuffer value) {
        return this.toLong(value);
    }

    public abstract ByteBuffer add(NumberType<?> var1, ByteBuffer var2, NumberType<?> var3, ByteBuffer var4);

    public abstract ByteBuffer substract(NumberType<?> var1, ByteBuffer var2, NumberType<?> var3, ByteBuffer var4);

    public abstract ByteBuffer multiply(NumberType<?> var1, ByteBuffer var2, NumberType<?> var3, ByteBuffer var4);

    public abstract ByteBuffer divide(NumberType<?> var1, ByteBuffer var2, NumberType<?> var3, ByteBuffer var4);

    public abstract ByteBuffer mod(NumberType<?> var1, ByteBuffer var2, NumberType<?> var3, ByteBuffer var4);

    public abstract ByteBuffer negate(ByteBuffer var1);
}

