/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.queries;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeCqlNameParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.KeyspaceFilter;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableListMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class CassandraSchemaRows
implements SchemaRows {
    private final Node node;
    private final DataTypeParser dataTypeParser;
    private final List<AdminRow> keyspaces;
    private final List<AdminRow> virtualKeyspaces;
    private final Multimap<CqlIdentifier, AdminRow> tables;
    private final Multimap<CqlIdentifier, AdminRow> virtualTables;
    private final Multimap<CqlIdentifier, AdminRow> views;
    private final Multimap<CqlIdentifier, AdminRow> types;
    private final Multimap<CqlIdentifier, AdminRow> functions;
    private final Multimap<CqlIdentifier, AdminRow> aggregates;
    private final Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> columns;
    private final Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> virtualColumns;
    private final Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> indexes;
    private final Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> vertices;
    private final Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> edges;

    private CassandraSchemaRows(Node node, DataTypeParser dataTypeParser, List<AdminRow> keyspaces, List<AdminRow> virtualKeyspaces, Multimap<CqlIdentifier, AdminRow> tables, Multimap<CqlIdentifier, AdminRow> virtualTables, Multimap<CqlIdentifier, AdminRow> views, Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> columns, Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> virtualColumns, Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> indexes, Multimap<CqlIdentifier, AdminRow> types, Multimap<CqlIdentifier, AdminRow> functions, Multimap<CqlIdentifier, AdminRow> aggregates, Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> vertices, Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> edges) {
        this.node = node;
        this.dataTypeParser = dataTypeParser;
        this.keyspaces = keyspaces;
        this.virtualKeyspaces = virtualKeyspaces;
        this.tables = tables;
        this.virtualTables = virtualTables;
        this.views = views;
        this.columns = columns;
        this.virtualColumns = virtualColumns;
        this.indexes = indexes;
        this.types = types;
        this.functions = functions;
        this.aggregates = aggregates;
        this.vertices = vertices;
        this.edges = edges;
    }

    @Override
    @NonNull
    public Node getNode() {
        return this.node;
    }

    @Override
    public DataTypeParser dataTypeParser() {
        return this.dataTypeParser;
    }

    @Override
    public List<AdminRow> keyspaces() {
        return this.keyspaces;
    }

    @Override
    public List<AdminRow> virtualKeyspaces() {
        return this.virtualKeyspaces;
    }

    @Override
    public Multimap<CqlIdentifier, AdminRow> tables() {
        return this.tables;
    }

    @Override
    public Multimap<CqlIdentifier, AdminRow> virtualTables() {
        return this.virtualTables;
    }

    @Override
    public Multimap<CqlIdentifier, AdminRow> views() {
        return this.views;
    }

    @Override
    public Multimap<CqlIdentifier, AdminRow> types() {
        return this.types;
    }

    @Override
    public Multimap<CqlIdentifier, AdminRow> functions() {
        return this.functions;
    }

    @Override
    public Multimap<CqlIdentifier, AdminRow> aggregates() {
        return this.aggregates;
    }

    @Override
    public Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> columns() {
        return this.columns;
    }

    @Override
    public Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> virtualColumns() {
        return this.virtualColumns;
    }

    @Override
    public Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> indexes() {
        return this.indexes;
    }

    @Override
    public Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> vertices() {
        return this.vertices;
    }

    @Override
    public Map<CqlIdentifier, Multimap<CqlIdentifier, AdminRow>> edges() {
        return this.edges;
    }

    public static class Builder {
        private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        private final Node node;
        private final DataTypeParser dataTypeParser;
        private final String tableNameColumn;
        private final KeyspaceFilter keyspaceFilter;
        private final String logPrefix;
        private final ImmutableList.Builder<AdminRow> keyspacesBuilder = ImmutableList.builder();
        private final ImmutableList.Builder<AdminRow> virtualKeyspacesBuilder = ImmutableList.builder();
        private final ImmutableMultimap.Builder<CqlIdentifier, AdminRow> tablesBuilder = ImmutableListMultimap.builder();
        private final ImmutableMultimap.Builder<CqlIdentifier, AdminRow> virtualTablesBuilder = ImmutableListMultimap.builder();
        private final ImmutableMultimap.Builder<CqlIdentifier, AdminRow> viewsBuilder = ImmutableListMultimap.builder();
        private final ImmutableMultimap.Builder<CqlIdentifier, AdminRow> typesBuilder = ImmutableListMultimap.builder();
        private final ImmutableMultimap.Builder<CqlIdentifier, AdminRow> functionsBuilder = ImmutableListMultimap.builder();
        private final ImmutableMultimap.Builder<CqlIdentifier, AdminRow> aggregatesBuilder = ImmutableListMultimap.builder();
        private final Map<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>> columnsBuilders = new LinkedHashMap<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>>();
        private final Map<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>> virtualColumnsBuilders = new LinkedHashMap<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>>();
        private final Map<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>> indexesBuilders = new LinkedHashMap<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>>();
        private final Map<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>> verticesBuilders = new LinkedHashMap<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>>();
        private final Map<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>> edgesBuilders = new LinkedHashMap<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>>();

        public Builder(Node node, KeyspaceFilter keyspaceFilter, String logPrefix) {
            this.node = node;
            this.keyspaceFilter = keyspaceFilter;
            this.logPrefix = logPrefix;
            if (Builder.isCassandraV3OrAbove(node)) {
                this.tableNameColumn = "table_name";
                this.dataTypeParser = new DataTypeCqlNameParser();
            } else {
                this.tableNameColumn = "columnfamily_name";
                this.dataTypeParser = new DataTypeClassNameParser();
            }
        }

        private static boolean isCassandraV3OrAbove(Node node) {
            Version dseVersion = (Version)node.getExtras().get("DSE_VERSION");
            if (dseVersion != null) {
                return (dseVersion = dseVersion.nextStable()).compareTo(Version.V5_0_0) >= 0;
            }
            Version cassandraVersion = node.getCassandraVersion();
            cassandraVersion = cassandraVersion == null ? Version.V3_0_0 : cassandraVersion.nextStable();
            return cassandraVersion.compareTo(Version.V3_0_0) >= 0;
        }

        public Builder withKeyspaces(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.put(this.keyspacesBuilder, row);
            }
            return this;
        }

        public Builder withVirtualKeyspaces(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.put(this.virtualKeyspacesBuilder, row);
            }
            return this;
        }

        public Builder withTables(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspace(row, this.tablesBuilder);
            }
            return this;
        }

        public Builder withVirtualTables(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspace(row, this.virtualTablesBuilder);
            }
            return this;
        }

        public Builder withViews(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspace(row, this.viewsBuilder);
            }
            return this;
        }

        public Builder withTypes(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspace(row, this.typesBuilder);
            }
            return this;
        }

        public Builder withFunctions(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspace(row, this.functionsBuilder);
            }
            return this;
        }

        public Builder withAggregates(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspace(row, this.aggregatesBuilder);
            }
            return this;
        }

        public Builder withColumns(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspaceAndTable(row, this.columnsBuilders);
            }
            return this;
        }

        public Builder withVirtualColumns(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspaceAndTable(row, this.virtualColumnsBuilders);
            }
            return this;
        }

        public Builder withIndexes(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspaceAndTable(row, this.indexesBuilders);
            }
            return this;
        }

        public Builder withVertices(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspaceAndTable(row, this.verticesBuilders);
            }
            return this;
        }

        public Builder withEdges(Iterable<AdminRow> rows) {
            for (AdminRow row : rows) {
                this.putByKeyspaceAndTable(row, this.edgesBuilders);
            }
            return this;
        }

        private void put(ImmutableList.Builder<AdminRow> builder, AdminRow row) {
            String keyspace = row.getString("keyspace_name");
            if (keyspace == null) {
                LOG.warn("[{}] Skipping system row with missing keyspace name", (Object)this.logPrefix);
            } else if (this.keyspaceFilter.includes(keyspace)) {
                builder.add((Object)row);
            }
        }

        private void putByKeyspace(AdminRow row, ImmutableMultimap.Builder<CqlIdentifier, AdminRow> builder) {
            String keyspace = row.getString("keyspace_name");
            if (keyspace == null) {
                LOG.warn("[{}] Skipping system row with missing keyspace name", (Object)this.logPrefix);
            } else if (this.keyspaceFilter.includes(keyspace)) {
                builder.put((Object)CqlIdentifier.fromInternal(keyspace), (Object)row);
            }
        }

        private void putByKeyspaceAndTable(AdminRow row, Map<CqlIdentifier, ImmutableMultimap.Builder<CqlIdentifier, AdminRow>> builders) {
            String keyspace = row.getString("keyspace_name");
            String table = row.getString(this.tableNameColumn);
            if (keyspace == null) {
                LOG.warn("[{}] Skipping system row with missing keyspace name", (Object)this.logPrefix);
            } else if (table == null) {
                LOG.warn("[{}] Skipping system row with missing table name", (Object)this.logPrefix);
            } else if (this.keyspaceFilter.includes(keyspace)) {
                ImmutableMultimap.Builder builder = builders.computeIfAbsent(CqlIdentifier.fromInternal(keyspace), s -> ImmutableListMultimap.builder());
                builder.put((Object)CqlIdentifier.fromInternal(table), (Object)row);
            }
        }

        public CassandraSchemaRows build() {
            return new CassandraSchemaRows(this.node, this.dataTypeParser, (List)this.keyspacesBuilder.build(), (List)this.virtualKeyspacesBuilder.build(), (Multimap)this.tablesBuilder.build(), (Multimap)this.virtualTablesBuilder.build(), (Multimap)this.viewsBuilder.build(), Builder.build(this.columnsBuilders), Builder.build(this.virtualColumnsBuilders), Builder.build(this.indexesBuilders), (Multimap)this.typesBuilder.build(), (Multimap)this.functionsBuilder.build(), (Multimap)this.aggregatesBuilder.build(), Builder.build(this.verticesBuilders), Builder.build(this.edgesBuilders));
        }

        private static <K1, K2, V> Map<K1, Multimap<K2, V>> build(Map<K1, ImmutableMultimap.Builder<K2, V>> builders) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builders.entrySet().forEach(entry -> builder.put(entry.getKey(), (Object)((ImmutableMultimap.Builder)entry.getValue()).build()));
            return builder.build();
        }
    }
}

