/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.crosspartition;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.PartitionKeyExtractor;
import org.apache.paimon.types.RowType;

public class KeyPartPartitionKeyExtractor
implements PartitionKeyExtractor<InternalRow> {
    private final Projection partitionProjection;
    private final Projection keyProjection;

    public KeyPartPartitionKeyExtractor(TableSchema schema) {
        List partitionKeys = schema.partitionKeys();
        RowType keyPartType = schema.projectedLogicalRowType(Stream.concat(schema.trimmedPrimaryKeys().stream(), partitionKeys.stream()).collect(Collectors.toList()));
        this.partitionProjection = CodeGenUtils.newProjection(keyPartType, partitionKeys);
        this.keyProjection = CodeGenUtils.newProjection(keyPartType, schema.primaryKeys());
    }

    @Override
    public BinaryRow partition(InternalRow record) {
        return this.partitionProjection.apply(record);
    }

    @Override
    public BinaryRow trimmedPrimaryKey(InternalRow record) {
        return this.keyProjection.apply(record);
    }
}

