/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.memory;

import java.io.IOException;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputSerializer;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.lookup.State;

public abstract class InMemoryState<K, V>
implements State<K, V> {
    protected final Serializer<K> keySerializer;
    protected final Serializer<V> valueSerializer;
    protected final DataOutputSerializer keyOutView;
    protected final DataInputDeserializer valueInputView;
    protected final DataOutputSerializer valueOutputView;

    public InMemoryState(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyOutView = new DataOutputSerializer(32);
        this.valueInputView = new DataInputDeserializer();
        this.valueOutputView = new DataOutputSerializer(32);
    }

    @Override
    public byte[] serializeKey(K key) throws IOException {
        this.keyOutView.clear();
        this.keySerializer.serialize(key, (DataOutputView)this.keyOutView);
        return this.keyOutView.getCopyOfBuffer();
    }

    @Override
    public byte[] serializeValue(V value) throws IOException {
        this.valueOutputView.clear();
        this.valueSerializer.serialize(value, (DataOutputView)this.valueOutputView);
        return this.valueOutputView.getCopyOfBuffer();
    }

    @Override
    public V deserializeValue(byte[] valueBytes) throws IOException {
        this.valueInputView.setBuffer(valueBytes);
        return (V)this.valueSerializer.deserialize((DataInputView)this.valueInputView);
    }
}

