/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.runtime.FunctionArgument;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorPattern;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.googlecode.aviator.runtime.type.AviatorType;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class FunctionUtils {
    public static List<FunctionArgument> getFunctionArguments(Map<String, Object> env) {
        Map funcParams = (Map)env.get("__funcs_args__");
        if (funcParams == null) {
            return null;
        }
        Integer refId = (Integer)env.get("__fas__");
        if (refId == null) {
            return null;
        }
        return (List)funcParams.get(refId);
    }

    public static final boolean getBooleanValue(AviatorObject arg, Map<String, Object> env) {
        return (Boolean)arg.getValue(env);
    }

    public static final String getStringValue(AviatorObject arg, Map<String, Object> env) {
        String result = null;
        Object value = arg.getValue(env);
        result = value instanceof Character ? value.toString() : (String)value;
        return result;
    }

    public static Object getJavaObject(AviatorObject arg, Map<String, Object> env) {
        if (arg.getAviatorType() != AviatorType.JavaType) {
            throw new ClassCastException(arg.desc(env) + " is not a javaType");
        }
        return ((AviatorJavaType)arg).getValue(env);
    }

    public static AviatorFunction getFunction(AviatorObject arg, Map<String, Object> env, int arity) {
        if (arg.getAviatorType() != AviatorType.JavaType && arg.getAviatorType() != AviatorType.Lambda) {
            throw new ClassCastException(arg.desc(env) + " is not a function");
        }
        Object val = null;
        if (arg instanceof AviatorFunction) {
            return (AviatorFunction)((Object)arg);
        }
        if (arg instanceof AviatorRuntimeJavaType && (val = arg.getValue(env)) instanceof AviatorFunction) {
            return (AviatorFunction)val;
        }
        String name = ((AviatorJavaType)arg).getName();
        if (name.equals("-")) {
            name = arity == 2 ? "-sub" : "-neg";
        }
        AviatorFunction rt = null;
        if (env != null) {
            rt = (AviatorFunction)env.get(name);
        }
        if (rt == null) {
            AviatorEvaluatorInstance instance = RuntimeUtils.getInstance(env);
            rt = instance.getFunction(name);
        }
        return rt;
    }

    public static final Number getNumberValue(AviatorObject arg1, Map<String, Object> env) {
        return (Number)arg1.getValue(env);
    }

    public static AviatorObject wrapReturn(Object ret) {
        if (ret == null) {
            return AviatorNil.NIL;
        }
        if (ret instanceof Pattern) {
            return new AviatorPattern((Pattern)ret);
        }
        if (ret instanceof Number) {
            return AviatorNumber.valueOf(ret);
        }
        if (ret instanceof CharSequence || ret instanceof Character) {
            return new AviatorString(ret.toString());
        }
        if (ret instanceof Boolean) {
            return AviatorBoolean.valueOf((Boolean)ret);
        }
        if (ret instanceof AviatorObject) {
            return (AviatorObject)ret;
        }
        return AviatorRuntimeJavaType.valueOf(ret);
    }
}

