/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class FilesetVersionPO {
    private Long id;
    private Long metalakeId;
    private Long catalogId;
    private Long schemaId;
    private Long filesetId;
    private Long version;
    private String filesetComment;
    private String properties;
    private String locationName;
    private String storageLocation;
    private Long deletedAt;

    public Long getId() {
        return this.id;
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public Long getCatalogId() {
        return this.catalogId;
    }

    public Long getSchemaId() {
        return this.schemaId;
    }

    public Long getFilesetId() {
        return this.filesetId;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getFilesetComment() {
        return this.filesetComment;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilesetVersionPO)) {
            return false;
        }
        FilesetVersionPO that = (FilesetVersionPO)o;
        return Objects.equal((Object)this.getId(), (Object)that.getId()) && Objects.equal((Object)this.getMetalakeId(), (Object)that.getMetalakeId()) && Objects.equal((Object)this.getCatalogId(), (Object)that.getCatalogId()) && Objects.equal((Object)this.getSchemaId(), (Object)that.getSchemaId()) && Objects.equal((Object)this.getFilesetId(), (Object)that.getFilesetId()) && Objects.equal((Object)this.getVersion(), (Object)that.getVersion()) && Objects.equal((Object)this.getFilesetComment(), (Object)that.getFilesetComment()) && Objects.equal((Object)this.getProperties(), (Object)that.getProperties()) && Objects.equal((Object)this.getLocationName(), (Object)that.getLocationName()) && Objects.equal((Object)this.getStorageLocation(), (Object)that.getStorageLocation()) && Objects.equal((Object)this.getDeletedAt(), (Object)that.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getMetalakeId(), this.getCatalogId(), this.getSchemaId(), this.getFilesetId(), this.getVersion(), this.getFilesetComment(), this.getProperties(), this.getLocationName(), this.getStorageLocation(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final FilesetVersionPO filesetVersionPO = new FilesetVersionPO();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.filesetVersionPO.id = id;
            return this;
        }

        public Builder withMetalakeId(Long metalakeId) {
            this.filesetVersionPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withCatalogId(Long catalogId) {
            this.filesetVersionPO.catalogId = catalogId;
            return this;
        }

        public Builder withSchemaId(Long schemaId) {
            this.filesetVersionPO.schemaId = schemaId;
            return this;
        }

        public Builder withFilesetId(Long filesetId) {
            this.filesetVersionPO.filesetId = filesetId;
            return this;
        }

        public Builder withVersion(Long version) {
            this.filesetVersionPO.version = version;
            return this;
        }

        public Builder withFilesetComment(String filesetComment) {
            this.filesetVersionPO.filesetComment = filesetComment;
            return this;
        }

        public Builder withProperties(String properties) {
            this.filesetVersionPO.properties = properties;
            return this;
        }

        public Builder withStorageLocation(String storageLocation) {
            this.filesetVersionPO.storageLocation = storageLocation;
            return this;
        }

        public Builder withLocationName(String locationName) {
            this.filesetVersionPO.locationName = locationName;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.filesetVersionPO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.filesetVersionPO.metalakeId != null ? 1 : 0) != 0, (Object)"Metalake id is required");
            Preconditions.checkArgument((this.filesetVersionPO.catalogId != null ? 1 : 0) != 0, (Object)"Catalog id is required");
            Preconditions.checkArgument((this.filesetVersionPO.schemaId != null ? 1 : 0) != 0, (Object)"Schema id is required");
            Preconditions.checkArgument((this.filesetVersionPO.filesetId != null ? 1 : 0) != 0, (Object)"Fileset id is required");
            Preconditions.checkArgument((this.filesetVersionPO.version != null ? 1 : 0) != 0, (Object)"Fileset version is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.filesetVersionPO.locationName), (Object)"Location name is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.filesetVersionPO.storageLocation), (Object)"Storage location is required");
            Preconditions.checkArgument((this.filesetVersionPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public FilesetVersionPO build() {
            this.validate();
            return this.filesetVersionPO;
        }
    }
}

