/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.ListProperties;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.messaging.Topic;

public class ListTopicProperties
extends ListProperties {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String topic;

    public ListTopicProperties(CommandContext context, String metalake, String catalog, String schema, String topic) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.topic = topic;
    }

    @Override
    public void handle() {
        NameIdentifier name = NameIdentifier.of(this.schema, this.topic);
        Topic gTopic = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            gTopic = client.loadCatalog(this.catalog).asTopicCatalog().loadTopic(name);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTopicException err) {
            this.exitWithError("Unknown topic name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        Map<String, String> properties = gTopic.properties();
        this.printProperties(properties);
    }
}

