/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.authorization.User;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.AuditCommand;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchUserException;

public class UserAudit
extends AuditCommand {
    protected final String metalake;
    protected final String user;

    public UserAudit(CommandContext context, String metalake, String user) {
        super(context);
        this.metalake = metalake;
        this.user = user;
    }

    @Override
    public void handle() {
        User result = null;
        try (GravitinoClient client = this.buildClient(this.metalake);){
            result = client.getUser(this.user);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchUserException err) {
            this.exitWithError("Unknown user.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (result != null) {
            this.displayAuditInfo(result.auditInfo());
        }
    }
}

