/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.main;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.cache.Cache;
import org.casbin.jcasbin.persist.cache.CacheableParam;
import org.casbin.jcasbin.persist.cache.DefaultCache;

public class CachedEnforcer
extends Enforcer {
    private Duration expireTime;
    private Cache cache;
    private final AtomicBoolean enableCache = new AtomicBoolean(true);
    private static final ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();

    public CachedEnforcer() {
        this.cache = new DefaultCache();
    }

    public CachedEnforcer(String modelPath, String policyFile) {
        super(modelPath, policyFile);
        this.cache = new DefaultCache();
    }

    public CachedEnforcer(String modelPath, Adapter adapter) {
        super(modelPath, adapter);
        this.cache = new DefaultCache();
    }

    public CachedEnforcer(Model m, Adapter adapter) {
        super(m, adapter);
        this.cache = new DefaultCache();
    }

    public CachedEnforcer(Model m) {
        super(m);
        this.cache = new DefaultCache();
    }

    public CachedEnforcer(String modelPath) {
        super(modelPath);
        this.cache = new DefaultCache();
    }

    public CachedEnforcer(String modelPath, String policyFile, boolean enableLog) {
        super(modelPath, policyFile, enableLog);
        this.cache = new DefaultCache();
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public boolean enforce(Object ... rvals) {
        if (!this.enableCache.get()) {
            return super.enforce(rvals);
        }
        String key = this.getKey(rvals);
        if (key == null) {
            return super.enforce(rvals);
        }
        boolean cachedResult = this.getCachedResult(key);
        if (cachedResult) {
            return cachedResult;
        }
        boolean result = super.enforce(rvals);
        this.setCachedResult(key, result, this.expireTime);
        return result;
    }

    @Override
    public void loadPolicy() {
        if (this.enableCache == null || !this.enableCache.get()) {
            super.loadPolicy();
        } else {
            if (this.enableCache.get()) {
                this.cache.clear();
            }
            super.loadPolicy();
        }
    }

    @Override
    public boolean removePolicy(String ... params) {
        String key;
        if (this.enableCache.get() && (key = this.getKey(params)) != null) {
            this.cache.delete(key);
        }
        return super.removePolicy(params);
    }

    @Override
    public boolean removePolicies(List<List<String>> rules) {
        if (!rules.isEmpty() && this.enableCache.get()) {
            for (List<String> rule : rules) {
                String key = this.getKey(rule.toArray());
                this.cache.delete(key);
            }
        }
        return super.removePolicies(rules);
    }

    @Override
    public boolean removePolicies(String[][] rules) {
        if (rules != null && this.enableCache.get()) {
            for (String[] rule : rules) {
                String key = this.getKey(rule);
                this.cache.delete(key);
            }
        }
        return super.removePolicies(rules);
    }

    private boolean getCachedResult(String key) {
        READ_WRITE_LOCK.readLock().lock();
        try {
            boolean bl = this.cache.get(key);
            return bl;
        }
        finally {
            READ_WRITE_LOCK.readLock().unlock();
        }
    }

    public void setExpireTime(Duration expireTime) {
        this.expireTime = expireTime;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCachedResult(String key, boolean result, Duration expireTime) {
        READ_WRITE_LOCK.writeLock().lock();
        try {
            this.cache.set(key, result, expireTime);
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    private String getKey(Object ... params) {
        StringBuilder keyBuilder = new StringBuilder();
        for (Object param : params) {
            if (param instanceof String) {
                keyBuilder.append(param);
            } else if (param instanceof CacheableParam) {
                keyBuilder.append(((CacheableParam)param).getCacheKey());
            } else {
                return null;
            }
            keyBuilder.append("$$");
        }
        return keyBuilder.toString();
    }

    public String getCacheKey(Object ... params) {
        StringBuilder key = new StringBuilder();
        for (Object param : params) {
            if (param instanceof String) {
                key.append((String)param);
            } else if (param instanceof CacheableParam) {
                key.append(((CacheableParam)param).getCacheKey());
            } else {
                return "";
            }
            key.append("$$");
        }
        return key.toString();
    }

    public void invalidateCache() {
        READ_WRITE_LOCK.writeLock().lock();
        try {
            this.cache.clear();
        }
        finally {
            READ_WRITE_LOCK.writeLock().unlock();
        }
    }

    @Override
    public void clearPolicy() {
        if (this.enableCache.get()) {
            try {
                this.cache.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.clearPolicy();
    }
}

