/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Configuration;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbDataSourceFactory;
import dm.jdbc.util.StringUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class DmdbDataSource
implements Serializable,
Referenceable,
DataSource {
    private static final long serialVersionUID = 1L;
    private PrintWriter logWriter;
    private int loginTimeout;
    protected String user;
    protected String password;
    private String hostName;
    private int port;
    private String url;

    @Override
    public Connection getConnection() {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String string, String string2) {
        Properties properties = new Properties();
        if (StringUtil.isNotEmpty(this.hostName)) {
            properties.setProperty(Configuration.host.getName(), this.hostName);
        }
        if (this.port > 0) {
            properties.setProperty(Configuration.port.getName(), String.valueOf(this.port));
        }
        if (StringUtil.isNotEmpty(string)) {
            properties.setProperty(Configuration.user.getName(), string);
        }
        if (StringUtil.isNotEmpty(string2)) {
            properties.setProperty(Configuration.password.getName(), string2);
        }
        return DmDriver.driver.connect(this.getURL(), properties);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public void setLoginTimeout(int n2) {
        this.loginTimeout = n2;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public String getURL() {
        return StringUtil.isNotEmpty(this.url) ? this.url : "jdbc:dm://" + this.hostName + ":" + this.port;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getServer() {
        return this.hostName;
    }

    public void setServer(String string) {
        this.hostName = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public Reference getReference() {
        String string = DmdbDataSourceFactory.class.getName();
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr(Configuration.host.getName(), this.getServer()));
        reference.add(new StringRefAddr(Configuration.port.getName(), String.valueOf(this.getPort())));
        if (this.url != null) {
            reference.add(new StringRefAddr(Configuration.url.getName(), this.url));
        }
        reference.add(new StringRefAddr(Configuration.user.getName(), this.getUser()));
        reference.add(new StringRefAddr(Configuration.password.getName(), this.password));
        return reference;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }
}

