/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaNodeManagementPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.partition.PartitionCache;
import org.apache.iotdb.mpp.rpc.thrift.TRegionRouteReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterPartitionFetcher
implements IPartitionFetcher {
    private static final Logger logger = LoggerFactory.getLogger(ClusterPartitionFetcher.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final SeriesPartitionExecutor partitionExecutor;
    private final PartitionCache partitionCache;
    private final IClientManager<ConfigRegionId, ConfigNodeClient> configNodeClientManager = ConfigNodeClientManager.getInstance();

    public static ClusterPartitionFetcher getInstance() {
        return ClusterPartitionFetcherHolder.INSTANCE;
    }

    private ClusterPartitionFetcher() {
        this.partitionExecutor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)config.getSeriesPartitionExecutorClass(), (int)config.getSeriesPartitionSlotNum());
        this.partitionCache = new PartitionCache();
    }

    @Override
    public SchemaPartition getSchemaPartition(PathPatternTree patternTree) {
        ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            patternTree.constructTree();
            List devicePaths = patternTree.getAllDevicePatterns();
            Map<String, List<String>> storageGroupToDeviceMap = this.partitionCache.getStorageGroupToDevice(devicePaths, true, false, null);
            SchemaPartition schemaPartition = this.partitionCache.getSchemaPartition(storageGroupToDeviceMap);
            if (null == schemaPartition) {
                TSchemaPartitionTableResp schemaPartitionTableResp = client.getSchemaPartitionTable(this.constructSchemaPartitionReq(patternTree));
                if (schemaPartitionTableResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    schemaPartition = this.parseSchemaPartitionTableResp(schemaPartitionTableResp);
                    this.partitionCache.updateSchemaPartitionCache(schemaPartitionTableResp.getSchemaPartitionTable());
                } else {
                    throw new RuntimeException(new IoTDBException(schemaPartitionTableResp.getStatus().getMessage(), schemaPartitionTableResp.getStatus().getCode()));
                }
            }
            SchemaPartition schemaPartition2 = schemaPartition;
            if (client != null) {
                client.close();
            }
            return schemaPartition2;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClientManagerException | TException e) {
                throw new StatementAnalyzeException("An error occurred when executing getSchemaPartition():" + e.getMessage());
            }
        }
    }

    @Override
    public SchemaPartition getOrCreateSchemaPartition(PathPatternTree patternTree, String userName) {
        ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            patternTree.constructTree();
            List devicePaths = patternTree.getAllDevicePatterns();
            Map<String, List<String>> storageGroupToDeviceMap = this.partitionCache.getStorageGroupToDevice(devicePaths, true, true, userName);
            SchemaPartition schemaPartition = this.partitionCache.getSchemaPartition(storageGroupToDeviceMap);
            if (null == schemaPartition) {
                TSchemaPartitionTableResp schemaPartitionTableResp = client.getOrCreateSchemaPartitionTable(this.constructSchemaPartitionReq(patternTree));
                if (schemaPartitionTableResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    schemaPartition = this.parseSchemaPartitionTableResp(schemaPartitionTableResp);
                    this.partitionCache.updateSchemaPartitionCache(schemaPartitionTableResp.getSchemaPartitionTable());
                } else {
                    throw new RuntimeException(new IoTDBException(schemaPartitionTableResp.getStatus().getMessage(), schemaPartitionTableResp.getStatus().getCode()));
                }
            }
            SchemaPartition schemaPartition2 = schemaPartition;
            if (client != null) {
                client.close();
            }
            return schemaPartition2;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClientManagerException | TException e) {
                throw new StatementAnalyzeException("An error occurred when executing getOrCreateSchemaPartition():" + e.getMessage());
            }
        }
    }

    @Override
    public SchemaNodeManagementPartition getSchemaNodeManagementPartitionWithLevel(PathPatternTree patternTree, PathPatternTree scope, Integer level) {
        ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            patternTree.constructTree();
            TSchemaNodeManagementResp schemaNodeManagementResp = client.getSchemaNodeManagementPartition(this.constructSchemaNodeManagementPartitionReq(patternTree, scope, level));
            SchemaNodeManagementPartition schemaNodeManagementPartition = this.parseSchemaNodeManagementPartitionResp(schemaNodeManagementResp);
            if (client != null) {
                client.close();
            }
            return schemaNodeManagementPartition;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClientManagerException | TException e) {
                throw new StatementAnalyzeException("An error occurred when executing getSchemaNodeManagementPartition():" + e.getMessage());
            }
        }
    }

    @Override
    public DataPartition getDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        DataPartition dataPartition;
        block10: {
            dataPartition = this.partitionCache.getDataPartition(sgNameToQueryParamsMap);
            if (null == dataPartition) {
                try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                    TDataPartitionTableResp dataPartitionTableResp = client.getDataPartitionTable(this.constructDataPartitionReqForQuery(sgNameToQueryParamsMap));
                    if (dataPartitionTableResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        dataPartition = this.parseDataPartitionResp(dataPartitionTableResp);
                        this.partitionCache.updateDataPartitionCache(dataPartitionTableResp.getDataPartitionTable());
                        break block10;
                    }
                    throw new StatementAnalyzeException("An error occurred when executing getDataPartition():" + dataPartitionTableResp.getStatus().getMessage());
                }
                catch (ClientManagerException | TException e) {
                    throw new StatementAnalyzeException("An error occurred when executing getDataPartition():" + e.getMessage());
                }
            }
        }
        return dataPartition;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataPartition getDataPartitionWithUnclosedTimeRange(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TDataPartitionTableResp dataPartitionTableResp = client.getDataPartitionTable(this.constructDataPartitionReqForQuery(sgNameToQueryParamsMap));
            if (dataPartitionTableResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) throw new StatementAnalyzeException("An error occurred when executing getDataPartition():" + dataPartitionTableResp.getStatus().getMessage());
            DataPartition dataPartition = this.parseDataPartitionResp(dataPartitionTableResp);
            return dataPartition;
        }
        catch (ClientManagerException | TException e) {
            throw new StatementAnalyzeException("An error occurred when executing getDataPartition():" + e.getMessage());
        }
    }

    @Override
    public DataPartition getOrCreateDataPartition(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        DataPartition dataPartition;
        block10: {
            dataPartition = this.partitionCache.getDataPartition(sgNameToQueryParamsMap);
            if (null == dataPartition) {
                try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                    TDataPartitionTableResp dataPartitionTableResp = client.getOrCreateDataPartitionTable(this.constructDataPartitionReq(sgNameToQueryParamsMap));
                    if (dataPartitionTableResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        dataPartition = this.parseDataPartitionResp(dataPartitionTableResp);
                        this.partitionCache.updateDataPartitionCache(dataPartitionTableResp.getDataPartitionTable());
                        break block10;
                    }
                    throw new StatementAnalyzeException("An error occurred when executing getOrCreateDataPartition():" + dataPartitionTableResp.getStatus().getMessage());
                }
                catch (ClientManagerException | TException e) {
                    throw new StatementAnalyzeException("An error occurred when executing getOrCreateDataPartition():" + e.getMessage());
                }
            }
        }
        return dataPartition;
    }

    @Override
    public DataPartition getOrCreateDataPartition(List<DataPartitionQueryParam> dataPartitionQueryParams, String userName) {
        DataPartition dataPartition;
        block10: {
            Map<String, List<DataPartitionQueryParam>> splitDataPartitionQueryParams = this.splitDataPartitionQueryParam(dataPartitionQueryParams, config.isAutoCreateSchemaEnabled(), userName);
            dataPartition = this.partitionCache.getDataPartition(splitDataPartitionQueryParams);
            if (null == dataPartition) {
                try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                    TDataPartitionReq req = this.constructDataPartitionReq(splitDataPartitionQueryParams);
                    TDataPartitionTableResp dataPartitionTableResp = client.getOrCreateDataPartitionTable(req);
                    if (dataPartitionTableResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        dataPartition = this.parseDataPartitionResp(dataPartitionTableResp);
                        this.partitionCache.updateDataPartitionCache(dataPartitionTableResp.getDataPartitionTable());
                        break block10;
                    }
                    throw new RuntimeException(new IoTDBException(dataPartitionTableResp.getStatus().getMessage(), dataPartitionTableResp.getStatus().getCode()));
                }
                catch (ClientManagerException | TException e) {
                    throw new StatementAnalyzeException("An error occurred when executing getOrCreateDataPartition():" + e.getMessage());
                }
            }
        }
        return dataPartition;
    }

    @Override
    public boolean updateRegionCache(TRegionRouteReq req) {
        return this.partitionCache.updateGroupIdToReplicaSetMap(req.getTimestamp(), req.getRegionRouteMap());
    }

    @Override
    public void invalidAllCache() {
        this.partitionCache.invalidAllCache();
    }

    private Map<String, List<DataPartitionQueryParam>> splitDataPartitionQueryParam(List<DataPartitionQueryParam> dataPartitionQueryParams, boolean isAutoCreate, String userName) {
        ArrayList<String> devicePaths = new ArrayList<String>();
        for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
            devicePaths.add(dataPartitionQueryParam.getDevicePath());
        }
        Map<String, String> deviceToStorageGroupMap = this.partitionCache.getDeviceToStorageGroup(devicePaths, true, isAutoCreate, userName);
        HashMap<String, List<DataPartitionQueryParam>> result = new HashMap<String, List<DataPartitionQueryParam>>();
        for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
            String devicePath = dataPartitionQueryParam.getDevicePath();
            if (!deviceToStorageGroupMap.containsKey(devicePath)) continue;
            String storageGroup = deviceToStorageGroupMap.get(devicePath);
            result.computeIfAbsent(storageGroup, key -> new ArrayList()).add(dataPartitionQueryParam);
        }
        return result;
    }

    private TSchemaPartitionReq constructSchemaPartitionReq(PathPatternTree patternTree) {
        try {
            return new TSchemaPartitionReq(patternTree.serialize());
        }
        catch (IOException e) {
            throw new StatementAnalyzeException("An error occurred when serializing pattern tree");
        }
    }

    private TSchemaNodeManagementReq constructSchemaNodeManagementPartitionReq(PathPatternTree patternTree, PathPatternTree scope, Integer level) {
        try {
            TSchemaNodeManagementReq schemaNodeManagementReq = new TSchemaNodeManagementReq(patternTree.serialize());
            schemaNodeManagementReq.setScopePatternTree(scope.serialize());
            if (null == level) {
                schemaNodeManagementReq.setLevel(-1);
            } else {
                schemaNodeManagementReq.setLevel(level.intValue());
            }
            return schemaNodeManagementReq;
        }
        catch (IOException e) {
            throw new StatementAnalyzeException("An error occurred when serializing pattern tree");
        }
    }

    private TDataPartitionReq constructDataPartitionReq(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        HashMap partitionSlotsMap = new HashMap();
        for (Map.Entry<String, List<DataPartitionQueryParam>> entry : sgNameToQueryParamsMap.entrySet()) {
            HashMap deviceToTimePartitionMap = new HashMap();
            HashMap<TSeriesPartitionSlot, ComplexTimeSlotList> seriesSlotTimePartitionMap = new HashMap<TSeriesPartitionSlot, ComplexTimeSlotList>();
            for (DataPartitionQueryParam queryParam : entry.getValue()) {
                seriesSlotTimePartitionMap.computeIfAbsent(this.partitionExecutor.getSeriesPartitionSlot(queryParam.getDevicePath()), k -> new ComplexTimeSlotList(queryParam.isNeedLeftAll(), queryParam.isNeedRightAll())).putTimeSlot(queryParam.getTimePartitionSlotList());
            }
            seriesSlotTimePartitionMap.forEach((k, v) -> deviceToTimePartitionMap.put(k, new TTimeSlotList(new ArrayList<TTimePartitionSlot>(v.timeSlotList), v.needLeftAll, v.needRightAll)));
            partitionSlotsMap.put(entry.getKey(), deviceToTimePartitionMap);
        }
        return new TDataPartitionReq(partitionSlotsMap);
    }

    private TDataPartitionReq constructDataPartitionReqForQuery(Map<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap) {
        HashMap partitionSlotsMap = new HashMap();
        TTimeSlotList sharedTTimeSlotList = null;
        for (Map.Entry<String, List<DataPartitionQueryParam>> entry : sgNameToQueryParamsMap.entrySet()) {
            HashMap<TSeriesPartitionSlot, TTimeSlotList> deviceToTimePartitionMap = new HashMap<TSeriesPartitionSlot, TTimeSlotList>();
            for (DataPartitionQueryParam queryParam : entry.getValue()) {
                if (sharedTTimeSlotList == null) {
                    sharedTTimeSlotList = new TTimeSlotList(queryParam.getTimePartitionSlotList(), queryParam.isNeedLeftAll(), queryParam.isNeedRightAll());
                }
                deviceToTimePartitionMap.putIfAbsent(this.partitionExecutor.getSeriesPartitionSlot(queryParam.getDevicePath()), sharedTTimeSlotList);
            }
            partitionSlotsMap.put(entry.getKey(), deviceToTimePartitionMap);
        }
        return new TDataPartitionReq(partitionSlotsMap);
    }

    private SchemaPartition parseSchemaPartitionTableResp(TSchemaPartitionTableResp schemaPartitionTableResp) {
        HashMap<String, Map> regionReplicaMap = new HashMap<String, Map>();
        for (Map.Entry entry1 : schemaPartitionTableResp.getSchemaPartitionTable().entrySet()) {
            String database = (String)entry1.getKey();
            Map result1 = regionReplicaMap.computeIfAbsent(database, k -> new HashMap());
            LinkedHashMap orderedMap = new LinkedHashMap((Map)entry1.getValue());
            ArrayList<TConsensusGroupId> orderedGroupIds = new ArrayList<TConsensusGroupId>(orderedMap.values());
            List<TRegionReplicaSet> regionReplicaSets = this.partitionCache.getRegionReplicaSet(orderedGroupIds);
            int index = 0;
            for (Map.Entry entry2 : orderedMap.entrySet()) {
                result1.put((TSeriesPartitionSlot)entry2.getKey(), regionReplicaSets.get(index++));
            }
        }
        return new SchemaPartition(regionReplicaMap, IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum());
    }

    private SchemaNodeManagementPartition parseSchemaNodeManagementPartitionResp(TSchemaNodeManagementResp schemaNodeManagementResp) {
        return new SchemaNodeManagementPartition(schemaNodeManagementResp.getSchemaRegionMap(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionExecutorClass(), IoTDBDescriptor.getInstance().getConfig().getSeriesPartitionSlotNum(), schemaNodeManagementResp.getMatchedNode());
    }

    private DataPartition parseDataPartitionResp(TDataPartitionTableResp dataPartitionTableResp) {
        HashSet uniqueConsensusGroupIds = new HashSet();
        for (Map partitionTable : Collections.singleton(dataPartitionTableResp.getDataPartitionTable())) {
            for (Map seriesPartitionMap : partitionTable.values()) {
                for (Map map : seriesPartitionMap.values()) {
                    for (List consensusGroupIds : map.values()) {
                        uniqueConsensusGroupIds.addAll(consensusGroupIds);
                    }
                }
            }
        }
        List<TRegionReplicaSet> allRegionReplicaSets = this.partitionCache.getRegionReplicaSet(new ArrayList<TConsensusGroupId>(uniqueConsensusGroupIds));
        ArrayList consensusGroupIds = new ArrayList(uniqueConsensusGroupIds);
        HashMap<TConsensusGroupId, TRegionReplicaSet> regionReplicaSetMap = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        for (int i = 0; i < allRegionReplicaSets.size(); ++i) {
            regionReplicaSetMap.put((TConsensusGroupId)consensusGroupIds.get(i), allRegionReplicaSets.get(i));
        }
        HashMap<String, Map> regionReplicaSet = new HashMap<String, Map>();
        for (Map.Entry entry : dataPartitionTableResp.getDataPartitionTable().entrySet()) {
            Map result1 = regionReplicaSet.computeIfAbsent((String)entry.getKey(), k -> new HashMap());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                Map result2 = result1.computeIfAbsent((TSeriesPartitionSlot)entry2.getKey(), k -> new HashMap());
                for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                    ArrayList<TRegionReplicaSet> regionReplicaSets = new ArrayList<TRegionReplicaSet>();
                    for (TConsensusGroupId groupId : (List)entry3.getValue()) {
                        regionReplicaSets.add((TRegionReplicaSet)regionReplicaSetMap.get(groupId));
                    }
                    result2.put((TTimePartitionSlot)entry3.getKey(), regionReplicaSets);
                }
            }
        }
        return new DataPartition(regionReplicaSet, config.getSeriesPartitionExecutorClass(), config.getSeriesPartitionSlotNum());
    }

    private static final class ClusterPartitionFetcherHolder {
        private static final ClusterPartitionFetcher INSTANCE = new ClusterPartitionFetcher();

        private ClusterPartitionFetcherHolder() {
        }
    }

    private static class ComplexTimeSlotList {
        Set<TTimePartitionSlot> timeSlotList = new HashSet<TTimePartitionSlot>();
        boolean needLeftAll;
        boolean needRightAll;

        private ComplexTimeSlotList(boolean needLeftAll, boolean needRightAll) {
            this.needLeftAll = needLeftAll;
            this.needRightAll = needRightAll;
        }

        private void putTimeSlot(List<TTimePartitionSlot> slotList) {
            this.timeSlotList.addAll(slotList);
        }
    }
}

