/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.datanode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class RegisterDataNodePlan
extends ConfigPhysicalPlan {
    private TDataNodeConfiguration dataNodeConfiguration;

    public RegisterDataNodePlan() {
        super(ConfigPhysicalPlanType.RegisterDataNode);
    }

    public RegisterDataNodePlan(TDataNodeConfiguration dataNodeConfiguration) {
        this();
        this.dataNodeConfiguration = dataNodeConfiguration;
    }

    public TDataNodeConfiguration getDataNodeConfiguration() {
        return this.dataNodeConfiguration;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ThriftCommonsSerDeUtils.serializeTDataNodeInfo((TDataNodeConfiguration)this.dataNodeConfiguration, (DataOutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) {
        this.dataNodeConfiguration = ThriftCommonsSerDeUtils.deserializeTDataNodeInfo((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterDataNodePlan that = (RegisterDataNodePlan)o;
        return this.dataNodeConfiguration.equals(that.dataNodeConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dataNodeConfiguration);
    }
}

