/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.rescon;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.rescon.ISchemaEngineStatistics;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemSchemaEngineStatistics
implements ISchemaEngineStatistics {
    private static final Logger logger = LoggerFactory.getLogger(MemSchemaEngineStatistics.class);
    private final long memoryCapacity = IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForSchemaRegion();
    private final ClusterTemplateManager clusterTemplateManager = ClusterTemplateManager.getInstance();
    protected final AtomicLong memoryUsage = new AtomicLong(0L);
    private final AtomicLong totalMeasurementNumber = new AtomicLong(0L);
    private final AtomicLong totalViewNumber = new AtomicLong(0L);
    private final AtomicLong totalDeviceNumber = new AtomicLong(0L);
    private final Map<Integer, Integer> templateUsage = new ConcurrentHashMap<Integer, Integer>();
    private volatile boolean allowToCreateNewSeries = true;
    private final Object allowToCreateNewSeriesLock = new Object();
    protected volatile boolean needLog = true;

    @Override
    public boolean isAllowToCreateNewSeries() {
        return this.allowToCreateNewSeries;
    }

    @Override
    public boolean isExceedCapacity() {
        return this.memoryUsage.get() > this.memoryCapacity;
    }

    @Override
    public long getMemoryCapacity() {
        return this.memoryCapacity;
    }

    @Override
    public long getMemoryUsage() {
        return this.memoryUsage.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestMemory(long size) {
        this.memoryUsage.addAndGet(size);
        if (this.memoryUsage.get() >= this.memoryCapacity) {
            Object object = this.allowToCreateNewSeriesLock;
            synchronized (object) {
                if (this.allowToCreateNewSeries && this.memoryUsage.get() >= this.memoryCapacity) {
                    if (this.needLog) {
                        logger.warn("Current series memory {} is too large...", (Object)this.memoryUsage);
                    } else {
                        logger.debug("Current series memory {} is too large...", (Object)this.memoryUsage);
                    }
                    this.allowToCreateNewSeries = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMemory(long size) {
        this.memoryUsage.addAndGet(-size);
        if (this.memoryUsage.get() < this.memoryCapacity) {
            Object object = this.allowToCreateNewSeriesLock;
            synchronized (object) {
                if (!this.allowToCreateNewSeries && this.memoryUsage.get() < this.memoryCapacity) {
                    if (this.needLog) {
                        logger.info("Current series memory {} come back to normal level, total series number is {}.", (Object)this.memoryUsage, (Object)(this.totalMeasurementNumber.get() + this.totalViewNumber.get()));
                    } else {
                        logger.debug("Current series memory {} come back to normal level, total series number is {}.", (Object)this.memoryUsage, (Object)(this.totalMeasurementNumber.get() + this.totalViewNumber.get()));
                    }
                    this.allowToCreateNewSeries = true;
                }
            }
        }
    }

    @Override
    public long getTotalSeriesNumber() {
        return this.totalMeasurementNumber.get() + this.totalViewNumber.get() + this.getTemplateSeriesNumber();
    }

    @Override
    public long getTotalDevicesNumber() {
        return this.totalDeviceNumber.get();
    }

    @Override
    public int getSchemaRegionNumber() {
        return SchemaEngine.getInstance().getSchemaRegionNumber();
    }

    @Override
    public long getTemplateSeriesNumber() {
        return this.templateUsage.entrySet().stream().mapToLong(i -> (long)this.clusterTemplateManager.getTemplate((Integer)i.getKey()).getMeasurementNumber() * (long)((Integer)i.getValue()).intValue()).sum();
    }

    @Override
    public int getTemplateUsingNumber(String templateName) {
        Integer templateId = this.clusterTemplateManager.getTemplateId(templateName);
        if (templateId == null) {
            return 0;
        }
        return this.templateUsage.getOrDefault(templateId, 0);
    }

    public void activateTemplate(int templateId) {
        this.templateUsage.compute(templateId, (k, v) -> v == null ? 1 : v + 1);
    }

    public void deactivateTemplate(int templateId, int cnt) {
        this.templateUsage.compute(templateId, (k, v) -> v == null || v <= cnt ? null : Integer.valueOf(v - cnt));
    }

    public void addMeasurement(long addedNum) {
        this.totalMeasurementNumber.addAndGet(addedNum);
    }

    public void deleteMeasurement(long deletedNum) {
        this.totalMeasurementNumber.addAndGet(-deletedNum);
    }

    public void addView(long addedNum) {
        this.totalViewNumber.addAndGet(addedNum);
    }

    public void deleteView(long deletedNum) {
        this.totalViewNumber.addAndGet(-deletedNum);
    }

    public void addDevice() {
        this.totalDeviceNumber.incrementAndGet();
    }

    public void deleteDevice(long cnt) {
        this.totalDeviceNumber.addAndGet(-cnt);
    }

    @Override
    public MemSchemaEngineStatistics getAsMemSchemaEngineStatistics() {
        return this;
    }

    @Override
    public CachedSchemaEngineStatistics getAsCachedSchemaEngineStatistics() {
        throw new UnsupportedOperationException("Wrong SchemaEngineStatistics Type");
    }
}

