/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.utils;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class PredicateUtils {
    public static <T> void consumeIf(Predicate<T> predicate, Consumer<T> consumer, T value) {
        if (PredicateUtils.test(predicate, value)) {
            consumer.accept(value);
        }
    }

    public static <T> Function<T, T> peek() {
        return v -> {
            System.err.println(v);
            return v;
        };
    }

    public static <T> Function<T, T> peek(String message, Function<T, ?> formatter) {
        return v -> {
            System.err.println(message.replace("{0}", String.valueOf(formatter.apply(v))));
            return v;
        };
    }

    public static <T> boolean test(Predicate<T> predicate, T value) {
        return predicate == null || predicate.test(value);
    }

    private PredicateUtils() {
    }
}

