/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.http.HttpRequest;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.rest.mock.MockHttpSession;
import org.apache.juneau.rest.mock.MockRestRequest;
import org.apache.juneau.rest.util.BoundedServletInputStream;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public class MockServletRequest
implements HttpServletRequest {
    private String method = "GET";
    private Map<String, String[]> queryDataMap = CollectionUtils.map();
    private Map<String, String[]> formDataMap;
    private Map<String, String[]> headerMap = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Object> attributeMap = CollectionUtils.map();
    private String characterEncoding = "UTF-8";
    private byte[] content = new byte[0];
    private String protocol = "HTTP/1.1";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 8080;
    private String remoteAddr = "";
    private String remoteHost = "";
    private Locale locale = Locale.ENGLISH;
    private int remotePort;
    private String localName;
    private String localAddr;
    private int localPort;
    private Map<String, RequestDispatcher> requestDispatcher = CollectionUtils.map();
    private ServletContext servletContext;
    private DispatcherType dispatcherType;
    private String authType;
    private Cookie[] cookies;
    private String pathInfo;
    private String pathTranslated;
    private String contextPath = "";
    private String queryString;
    private String remoteUser;
    private Principal userPrincipal;
    private String requestedSessionId;
    private String requestURI;
    private String servletPath = "";
    private HttpSession httpSession = MockHttpSession.create();
    private String uri = "";
    private Set<String> roles = CollectionUtils.set(new String[0]);

    public static MockServletRequest create() {
        MockServletRequest r = new MockServletRequest();
        return r;
    }

    public static MockServletRequest create(String method, String uri, Object ... pathArgs) {
        return MockServletRequest.create().method(method).uri(Utils.f(uri, pathArgs));
    }

    public MockServletRequest applyOverrides(HttpRequest req) {
        if (req instanceof MockRestRequest) {
            MockRestRequest mreq = (MockRestRequest)req;
            mreq.getAttributeMap().forEach(this::attribute);
            mreq.getRequestDispatcherMap().forEach(this::requestDispatcher);
            if (Utils.nn(mreq.getCharacterEncoding())) {
                this.characterEncoding(mreq.getCharacterEncoding());
            }
            if (Utils.nn(mreq.getProtocol())) {
                this.protocol(mreq.getProtocol());
            }
            if (Utils.nn(mreq.getScheme())) {
                this.scheme(mreq.getScheme());
            }
            if (Utils.nn(mreq.getServerName())) {
                this.serverName(mreq.getServerName());
            }
            if (Utils.nn(mreq.getRemoteAddr())) {
                this.remoteAddr(mreq.getRemoteAddr());
            }
            if (Utils.nn(mreq.getRemoteHost())) {
                this.remoteHost(mreq.getRemoteHost());
            }
            if (Utils.nn(mreq.getLocalName())) {
                this.localName(mreq.getLocalName());
            }
            if (Utils.nn(mreq.getLocalAddr())) {
                this.localAddr(mreq.getLocalAddr());
            }
            if (Utils.nn(mreq.getPathInfo())) {
                this.pathInfo(mreq.getPathInfo());
            }
            if (Utils.nn(mreq.getPathTranslated())) {
                this.pathTranslated(mreq.getPathTranslated());
            }
            if (Utils.nn(mreq.getContextPath())) {
                this.contextPath(mreq.getContextPath());
            }
            if (Utils.nn(mreq.getQueryString())) {
                this.queryString(mreq.getQueryString());
            }
            if (Utils.nn(mreq.getRemoteUser())) {
                this.remoteUser(mreq.getRemoteUser());
            }
            if (Utils.nn(mreq.getRequestedSessionId())) {
                this.requestedSessionId(mreq.getRequestedSessionId());
            }
            if (Utils.nn(mreq.getRequestURI())) {
                this.requestURI(mreq.getRequestURI());
            }
            if (Utils.nn(mreq.getServletPath())) {
                this.servletPath(mreq.getServletPath());
            }
            if (Utils.nn(mreq.getAuthType())) {
                this.authType(mreq.getAuthType());
            }
            if (Utils.nn(mreq.getServerPort())) {
                this.serverPort(mreq.getServerPort());
            }
            if (Utils.nn(mreq.getRemotePort())) {
                this.remotePort(mreq.getRemotePort());
            }
            if (Utils.nn(mreq.getLocalPort())) {
                this.localPort(mreq.getLocalPort());
            }
            if (Utils.nn(mreq.getLocale())) {
                this.locale(mreq.getLocale());
            }
            if (Utils.nn(mreq.getServletContext())) {
                this.servletContext(mreq.getServletContext());
            }
            if (Utils.nn(mreq.getDispatcherType())) {
                this.dispatcherType(mreq.getDispatcherType());
            }
            if (Utils.nn(mreq.getCookies())) {
                this.cookies(mreq.getCookies());
            }
            if (Utils.nn(mreq.getUserPrincipal())) {
                this.userPrincipal(mreq.getUserPrincipal());
            }
            if (Utils.nn(mreq.getHttpSession())) {
                this.httpSession(mreq.getHttpSession());
            }
            if (Utils.nn(mreq.getRoles())) {
                this.roles(mreq.getRoles());
            }
        }
        return this;
    }

    public MockServletRequest attribute(String name, Object value) {
        this.attributeMap.put(name, value);
        return this;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public MockServletRequest authType(String value) {
        this.authType = value;
        return this;
    }

    public String changeSessionId() {
        return null;
    }

    public MockServletRequest characterEncoding(String value) {
        this.characterEncoding = value;
        return this;
    }

    public MockServletRequest content(Object value) {
        try {
            if (value instanceof byte[]) {
                this.content = (byte[])value;
            } else if (value instanceof Reader) {
                this.content = IoUtils.readBytes((Reader)value);
            } else if (value instanceof InputStream) {
                this.content = IoUtils.readBytes((InputStream)value);
            } else if (value instanceof CharSequence) {
                this.content = ((CharSequence)value).toString().getBytes();
            } else if (Utils.nn(value)) {
                this.content = value.toString().getBytes();
            }
        }
        catch (IOException e) {
            throw ThrowableUtils.toRex(e);
        }
        return this;
    }

    public MockServletRequest contextPath(String value) {
        this.contextPath = value;
        return this;
    }

    public MockServletRequest cookies(Cookie[] value) {
        this.cookies = value;
        return this;
    }

    public MockServletRequest dispatcherType(DispatcherType value) {
        this.dispatcherType = value;
        return this;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributeMap.keySet());
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.content == null ? 0 : this.content.length;
    }

    public long getContentLengthLong() {
        return this.content == null ? 0L : (long)this.content.length;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        String s = this.getHeader(name);
        return s == null ? 0L : HttpHeaders.date(s).asZonedDateTime().get().toInstant().toEpochMilli();
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public String getHeader(String name) {
        String[] s = this.headerMap.get(name);
        return s == null || s.length == 0 ? null : s[0];
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headerMap.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        String[] s = this.headerMap.get(name);
        return Collections.enumeration(CollectionUtils.l(s == null ? new String[]{} : s));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (Utils.nn(this.formDataMap)) {
            this.content = UrlEncodingSerializer.DEFAULT.toString(this.formDataMap).getBytes();
        }
        return new BoundedServletInputStream(new ByteArrayInputStream(this.content), Integer.MAX_VALUE);
    }

    public int getIntHeader(String name) {
        String s = this.getHeader(name);
        return s == null || s.isEmpty() ? 0 : Integer.parseInt(s);
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(CollectionUtils.l(this.locale));
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String name) {
        String[] s = this.getParameterMap().get(name);
        return s == null || s.length == 0 ? null : s[0];
    }

    public Map<String, String[]> getParameterMap() {
        if ("POST".equalsIgnoreCase(this.method)) {
            if (this.formDataMap == null) {
                this.formDataMap = RestUtils.parseQuery(IoUtils.read(this.content));
            }
            return this.formDataMap;
        }
        return this.queryDataMap;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(CollectionUtils.toList(this.getParameterMap().keySet()));
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public String getPathInfo() {
        if (this.pathInfo == null) {
            this.pathInfo = this.getRequestURI();
            if (Utils.ne(this.contextPath)) {
                this.pathInfo = this.pathInfo.substring(this.contextPath.length());
            }
            if (Utils.ne(this.servletPath)) {
                this.pathInfo = this.pathInfo.substring(this.servletPath.length());
            }
        }
        return Utils.nullIfEmpty(StringUtils.urlDecode(this.pathInfo));
    }

    public String getPathTranslated() {
        if (this.pathTranslated == null) {
            this.pathTranslated = "/mock-path" + this.getPathInfo();
        }
        return this.pathTranslated;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProtocolRequestId() {
        return null;
    }

    public String getQueryString() {
        if (this.queryString == null) {
            if (this.queryDataMap.isEmpty()) {
                this.queryString = "";
            } else {
                StringBuilder sb = new StringBuilder();
                this.queryDataMap.forEach((k, v) -> {
                    if (v == null) {
                        sb.append(sb.length() == 0 ? "" : "&").append(StringUtils.urlEncode(k));
                    } else {
                        for (String v2 : v) {
                            sb.append(sb.length() == 0 ? "" : "&").append(StringUtils.urlEncode(k)).append('=').append(StringUtils.urlEncode(v2));
                        }
                    }
                });
                this.queryString = sb.toString();
            }
        }
        return StringUtils.isEmpty(this.queryString) ? null : this.queryString;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.characterEncoding));
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.requestDispatcher.get(path);
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestId() {
        return null;
    }

    public String getRequestURI() {
        if (this.requestURI == null) {
            this.requestURI = this.uri;
            this.requestURI = this.requestURI.replaceAll("^\\w+\\:\\/\\/[^\\/]+", "").replaceAll("\\?.*$", "");
        }
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.uri.replaceAll("\\?.*$", ""));
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public ServletConnection getServletConnection() {
        return null;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public HttpSession getSession(boolean create) {
        return this.httpSession;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public MockServletRequest header(String name, Object value) {
        if (Utils.nn(value)) {
            String[] v1 = value instanceof String[] ? (String[])value : CollectionUtils.a(value.toString());
            String[] v2 = this.headerMap.get(name);
            String[] v3 = CollectionUtils.combine(v2, v1);
            this.headerMap.put(name, v3);
        }
        return this;
    }

    public MockServletRequest httpSession(HttpSession value) {
        this.httpSession = value;
        return this;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    public MockServletRequest localAddr(String value) {
        this.localAddr = value;
        return this;
    }

    public MockServletRequest locale(Locale value) {
        this.locale = value;
        return this;
    }

    public MockServletRequest localName(String value) {
        this.localName = value;
        return this;
    }

    public MockServletRequest localPort(int value) {
        this.localPort = value;
        return this;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public MockServletRequest method(String value) {
        this.method = value;
        return this;
    }

    public MockServletRequest noTrace(boolean value) {
        if (value) {
            this.header("No-Trace", "true");
        }
        return this;
    }

    public MockServletRequest pathInfo(String value) {
        this.pathInfo = value;
        return this;
    }

    public MockServletRequest pathTranslated(String value) {
        this.pathTranslated = value;
        return this;
    }

    public MockServletRequest pathVars(Map<String, String> pathVars) {
        if (Utils.nn(pathVars)) {
            this.attributeMap.put("juneau.pathVars", new TreeMap<String, String>(pathVars));
        }
        return this;
    }

    public MockServletRequest pathVars(String ... pairs) {
        return this.pathVars(CollectionUtils.mapb(String.class, String.class).addPairs(pairs).build());
    }

    public MockServletRequest protocol(String value) {
        this.protocol = value;
        return this;
    }

    public MockServletRequest queryString(String value) {
        this.queryString = value;
        return this;
    }

    public MockServletRequest remoteAddr(String value) {
        this.remoteAddr = value;
        return this;
    }

    public MockServletRequest remoteHost(String value) {
        this.remoteHost = value;
        return this;
    }

    public MockServletRequest remotePort(int value) {
        this.remotePort = value;
        return this;
    }

    public MockServletRequest remoteUser(String value) {
        this.remoteUser = value;
        return this;
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public MockServletRequest requestDispatcher(String name, RequestDispatcher value) {
        this.requestDispatcher.put(name, value);
        return this;
    }

    public MockServletRequest requestedSessionId(String value) {
        this.requestedSessionId = value;
        return this;
    }

    public MockServletRequest requestURI(String value) {
        this.requestURI = value;
        return this;
    }

    public MockServletRequest role(String role) {
        this.roles = CollectionUtils.set(role);
        return this;
    }

    public MockServletRequest roles(String ... roles) {
        this.roles = CollectionUtils.set(roles);
        return this;
    }

    public MockServletRequest scheme(String value) {
        this.scheme = value;
        return this;
    }

    public MockServletRequest serverName(String value) {
        this.serverName = value;
        return this;
    }

    public MockServletRequest serverPort(int value) {
        this.serverPort = value;
        return this;
    }

    public MockServletRequest servletContext(ServletContext value) {
        this.servletContext = value;
        return this;
    }

    public MockServletRequest servletPath(String value) {
        this.servletPath = value;
        return this;
    }

    public void setAttribute(String name, Object o) {
        this.attributeMap.put(name, o);
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return null;
    }

    public MockServletRequest uri(String uri) {
        this.uri = uri = StringUtils.emptyIfNull(uri);
        if (uri.indexOf(63) != -1) {
            String qs = uri.substring(uri.indexOf(63) + 1);
            if (qs.indexOf(35) != -1) {
                qs = qs.substring(0, qs.indexOf(35));
            }
            this.queryString = qs;
            this.queryDataMap.putAll(RestUtils.parseQuery(qs));
        }
        return this;
    }

    public MockServletRequest userPrincipal(Principal value) {
        this.userPrincipal = value;
        return this;
    }

    protected MockServletRequest debug(boolean value) {
        if (value) {
            this.header("Debug", "true");
        }
        return this;
    }
}

