/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class MultiList<E>
extends AbstractList<E> {
    final List<E>[] l;

    @SafeVarargs
    public MultiList(List<E> ... c) {
        AssertionUtils.assertArgNotNull("c", c);
        for (List<E> cc : c) {
            AssertionUtils.assertArgNotNull("c", cc);
        }
        this.l = c;
    }

    public Enumeration<E> enumerator() {
        return Collections.enumeration(this);
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        int offset = 0;
        for (List<E> list : this.l) {
            int size = list.size();
            if (index < offset + size) {
                return list.get(index - offset);
            }
            offset += size;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int i = 0;
            Iterator<E> i2;
            {
                this.i2 = MultiList.this.l.length > 0 ? MultiList.this.l[this.i++].iterator() : null;
            }

            @Override
            public boolean hasNext() {
                if (this.i2 == null) {
                    return false;
                }
                if (this.i2.hasNext()) {
                    return true;
                }
                for (int j = this.i; j < MultiList.this.l.length; ++j) {
                    if (MultiList.this.l[j].size() <= 0) continue;
                    return true;
                }
                return false;
            }

            @Override
            public E next() {
                if (this.i2 == null) {
                    throw new NoSuchElementException();
                }
                while (!this.i2.hasNext()) {
                    if (this.i >= MultiList.this.l.length) {
                        throw new NoSuchElementException();
                    }
                    this.i2 = MultiList.this.l[this.i++].iterator();
                }
                return this.i2.next();
            }

            @Override
            public void remove() {
                if (this.i2 == null) {
                    throw new IllegalStateException();
                }
                this.i2.remove();
            }
        };
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        return new ListIterator<E>(){
            int currentIndex;
            int listIndex;
            int offset;
            ListIterator<E> currentIterator;
            {
                this.currentIndex = index;
                this.listIndex = 0;
                this.offset = 0;
                this.currentIterator = null;
                for (int i = 0; i < MultiList.this.l.length; ++i) {
                    int size = MultiList.this.l[i].size();
                    if (index < this.offset + size) {
                        this.listIndex = i;
                        this.currentIterator = MultiList.this.l[i].listIterator(index - this.offset);
                        break;
                    }
                    this.offset += size;
                }
                if (this.currentIterator == null && MultiList.this.l.length > 0) {
                    this.listIndex = MultiList.this.l.length - 1;
                    this.currentIterator = MultiList.this.l[this.listIndex].listIterator(MultiList.this.l[this.listIndex].size());
                }
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator == null) {
                    return false;
                }
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                for (int j = this.listIndex + 1; j < MultiList.this.l.length; ++j) {
                    if (MultiList.this.l[j].size() <= 0) continue;
                    return true;
                }
                return false;
            }

            @Override
            public E next() {
                if (this.currentIterator == null) {
                    throw new NoSuchElementException();
                }
                while (!this.currentIterator.hasNext()) {
                    if (this.listIndex + 1 >= MultiList.this.l.length) {
                        throw new NoSuchElementException();
                    }
                    ++this.listIndex;
                    this.currentIterator = MultiList.this.l[this.listIndex].listIterator();
                }
                ++this.currentIndex;
                return this.currentIterator.next();
            }

            @Override
            public boolean hasPrevious() {
                if (this.currentIterator == null) {
                    return false;
                }
                if (this.currentIterator.hasPrevious()) {
                    return true;
                }
                for (int j = this.listIndex - 1; j >= 0; --j) {
                    if (MultiList.this.l[j].size() <= 0) continue;
                    return true;
                }
                return false;
            }

            @Override
            public E previous() {
                if (this.currentIterator == null) {
                    throw new NoSuchElementException();
                }
                while (!this.currentIterator.hasPrevious()) {
                    if (this.listIndex == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.listIndex;
                    this.currentIterator = MultiList.this.l[this.listIndex].listIterator(MultiList.this.l[this.listIndex].size());
                }
                --this.currentIndex;
                return this.currentIterator.previous();
            }

            @Override
            public int nextIndex() {
                return this.currentIndex;
            }

            @Override
            public int previousIndex() {
                return this.currentIndex - 1;
            }

            @Override
            public void remove() {
                if (this.currentIterator == null) {
                    throw new IllegalStateException();
                }
                this.currentIterator.remove();
                --this.currentIndex;
            }

            @Override
            public void set(E e) {
                if (this.currentIterator == null) {
                    throw new IllegalStateException();
                }
                this.currentIterator.set(e);
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException("MultiList does not support add operations");
            }
        };
    }

    @Override
    public int size() {
        int i = 0;
        for (List<E> list : this.l) {
            i += list.size();
        }
        return i;
    }

    @Override
    public String toString() {
        return Arrays.stream(this.l).map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof List)) {
            return false;
        }
        return Utils.eq(this, (List)o, (x, y) -> {
            ListIterator e1 = x.listIterator();
            ListIterator e2 = y.listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Object o2;
                Object o1 = e1.next();
                if (Utils.eq(o1, o2 = e2.next())) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        });
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }
}

