/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.Finishable;

public class GzipEncoder
extends Encoder {
    @Override
    public String[] getCodings() {
        return (String[])CollectionUtils.a((Object[])new String[]{"gzip"});
    }

    @Override
    public InputStream getInputStream(InputStream is) throws IOException {
        return new GZIPInputStream(is);
    }

    @Override
    public OutputStream getOutputStream(OutputStream os) throws IOException {
        return new FinishableGZIPOutputStream(os);
    }

    private static class FinishableGZIPOutputStream
    extends GZIPOutputStream
    implements Finishable {
        FinishableGZIPOutputStream(OutputStream out) throws IOException {
            super(out);
        }
    }
}

