/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.rrpc;

import jakarta.servlet.ServletException;
import java.lang.reflect.Type;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.http.remote.RrpcInterfaceMeta;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.rrpc.RrpcRestOpSession;

public class RrpcRestOpContext
extends RestOpContext {
    private final RrpcInterfaceMeta meta;

    protected RrpcRestOpContext(RestOpContext.Builder builder) throws ServletException {
        super(builder);
        ClassMeta interfaceClass = this.getBeanContext().getClassMeta(this.getJavaMethod().getGenericReturnType(), new Type[0]);
        this.meta = new RrpcInterfaceMeta(interfaceClass.inner(), null);
        if (this.meta.getMethodsByPath().isEmpty()) {
            throw new InternalServerError("Method {0} returns an interface {1} that doesn't define any remote methods.", new Object[]{this.getJavaMethod().getName(), interfaceClass.getNameFull()});
        }
    }

    @Override
    public RrpcRestOpSession.Builder createSession(RestSession session) {
        return RrpcRestOpSession.create(this, session);
    }

    protected RrpcInterfaceMeta getMeta() {
        return this.meta;
    }
}

