/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.UnsolvableVersionConflictException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

public class ConfigurableVersionSelector
extends ConflictResolver.VersionSelector {
    public static final String CONFIG_PROP_SELECTION_STRATEGY = "aether.conflictResolver.versionSelector.selectionStrategy";
    public static final String NEAREST_SELECTION_STRATEGY = "nearest";
    public static final String HIGHEST_SELECTION_STRATEGY = "highest";
    public static final String DEFAULT_SELECTION_STRATEGY = "nearest";
    protected final SelectionStrategy selectionStrategy;

    public ConfigurableVersionSelector() {
        this.selectionStrategy = null;
    }

    public ConfigurableVersionSelector(SelectionStrategy selectionStrategy) {
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
    }

    @Override
    public ConflictResolver.VersionSelector getInstance(DependencyNode root, DependencyGraphTransformationContext context) throws RepositoryException {
        if (this.selectionStrategy == null) {
            SelectionStrategy strategy;
            String ss = ConfigUtils.getString(context.getSession(), "nearest", CONFIG_PROP_SELECTION_STRATEGY);
            if ("nearest".equals(ss)) {
                strategy = new Nearest();
            } else if (HIGHEST_SELECTION_STRATEGY.equals(ss)) {
                strategy = new Highest();
            } else {
                throw new IllegalArgumentException("Unknown selection strategy: " + ss + "; known are " + Arrays.asList("nearest", HIGHEST_SELECTION_STRATEGY));
            }
            return new ConfigurableVersionSelector(strategy);
        }
        return this;
    }

    @Override
    public void selectVersion(ConflictResolver.ConflictContext context) throws RepositoryException {
        ConflictGroup group = new ConflictGroup();
        for (ConflictResolver.ConflictItem candidate : context.getItems()) {
            boolean hardConstraint;
            DependencyNode node = candidate.getNode();
            VersionConstraint constraint = node.getVersionConstraint();
            boolean backtrack = false;
            boolean bl = hardConstraint = constraint.getRange() != null;
            if (hardConstraint && group.constraints.add(constraint) && group.winner != null && !constraint.containsVersion(group.winner.getNode().getVersion())) {
                backtrack = true;
            }
            if (this.isAcceptableByConstraints(group, node.getVersion())) {
                group.candidates.add(candidate);
                if (backtrack) {
                    this.backtrack(group, context);
                    continue;
                }
                if (group.winner != null && !this.selectionStrategy.isBetter(candidate, group.winner)) continue;
                group.winner = candidate;
                continue;
            }
            if (!backtrack) continue;
            this.backtrack(group, context);
        }
        context.setWinner(this.selectionStrategy.winnerSelected(group.winner, group.candidates, context));
    }

    protected void backtrack(ConflictGroup group, ConflictResolver.ConflictContext context) throws UnsolvableVersionConflictException {
        group.winner = null;
        Iterator<ConflictResolver.ConflictItem> it = group.candidates.iterator();
        while (it.hasNext()) {
            ConflictResolver.ConflictItem candidate = it.next();
            if (!this.isAcceptableByConstraints(group, candidate.getNode().getVersion())) {
                it.remove();
                continue;
            }
            if (group.winner != null && !this.selectionStrategy.isBetter(candidate, group.winner)) continue;
            group.winner = candidate;
        }
        if (group.winner == null) {
            throw ConfigurableVersionSelector.newFailure("Unsolvable hard constraint combination", context);
        }
    }

    protected boolean isAcceptableByConstraints(ConflictGroup group, Version version) {
        for (VersionConstraint constraint : group.constraints) {
            if (constraint.containsVersion(version)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (this.selectionStrategy != null ? this.selectionStrategy.getClass().getSimpleName() : "not inited") + ")";
    }

    public static UnsolvableVersionConflictException newFailure(String message, ConflictResolver.ConflictContext context) {
        DependencyFilter filter = (node, parents) -> {
            Objects.requireNonNull(node, "node cannot be null");
            Objects.requireNonNull(parents, "parents cannot be null");
            return context.isIncluded(node);
        };
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor(filter);
        context.getRoot().accept((DependencyVisitor)new TreeDependencyVisitor(visitor));
        return new UnsolvableVersionConflictException(message, visitor.getPaths());
    }

    public static interface SelectionStrategy {
        public boolean isBetter(ConflictResolver.ConflictItem var1, ConflictResolver.ConflictItem var2);

        default public ConflictResolver.ConflictItem winnerSelected(ConflictResolver.ConflictItem winner, Collection<ConflictResolver.ConflictItem> candidates, ConflictResolver.ConflictContext context) throws UnsolvableVersionConflictException {
            return winner;
        }
    }

    public static class Nearest
    implements SelectionStrategy {
        @Override
        public boolean isBetter(ConflictResolver.ConflictItem candidate, ConflictResolver.ConflictItem winner) {
            if (candidate.isSibling(winner)) {
                return candidate.getNode().getVersion().compareTo((Object)winner.getNode().getVersion()) > 0;
            }
            return candidate.getDepth() < winner.getDepth();
        }
    }

    public static class Highest
    implements SelectionStrategy {
        @Override
        public boolean isBetter(ConflictResolver.ConflictItem candidate, ConflictResolver.ConflictItem winner) {
            if (winner.getDepth() <= 1) {
                return false;
            }
            if (candidate.getDepth() <= 1) {
                return true;
            }
            if (candidate.getNode().getVersion().equals((Object)winner.getNode().getVersion())) {
                return candidate.getDepth() < winner.getDepth();
            }
            return candidate.getNode().getVersion().compareTo((Object)winner.getNode().getVersion()) > 0;
        }
    }

    protected static class ConflictGroup {
        final Collection<VersionConstraint> constraints = new HashSet<VersionConstraint>();
        final Collection<ConflictResolver.ConflictItem> candidates = new ArrayList<ConflictResolver.ConflictItem>(64);
        ConflictResolver.ConflictItem winner;

        ConflictGroup() {
        }

        public String toString() {
            return String.valueOf(this.winner);
        }
    }

    public static class MajorVersionConvergence
    implements SelectionStrategy {
        private final SelectionStrategy delegate;

        public MajorVersionConvergence(SelectionStrategy delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public boolean isBetter(ConflictResolver.ConflictItem candidate, ConflictResolver.ConflictItem winner) {
            return this.delegate.isBetter(candidate, winner);
        }

        @Override
        public ConflictResolver.ConflictItem winnerSelected(ConflictResolver.ConflictItem winner, Collection<ConflictResolver.ConflictItem> candidates, ConflictResolver.ConflictContext context) throws UnsolvableVersionConflictException {
            Set incompatibleVersions;
            if (winner != null && !candidates.isEmpty() && !(incompatibleVersions = candidates.stream().filter(c -> !this.sameMajor((ConflictResolver.ConflictItem)c, winner)).map(c -> c.getDependency().getArtifact().getVersion()).collect(Collectors.toSet())).isEmpty()) {
                Set allVersions = candidates.stream().map(c -> c.getDependency().getArtifact().getVersion()).collect(Collectors.toSet());
                throw ConfigurableVersionSelector.newFailure("Incompatible versions for " + winner.getDependency().getArtifact().getGroupId() + ":" + winner.getDependency().getArtifact().getArtifactId() + ", incompatible versions: " + incompatibleVersions + ", all versions " + allVersions, context);
            }
            return winner;
        }

        private boolean sameMajor(ConflictResolver.ConflictItem candidate, ConflictResolver.ConflictItem winner) {
            String candidateVersion = candidate.getDependency().getArtifact().getVersion();
            String winnerVersion = winner.getDependency().getArtifact().getVersion();
            if (candidateVersion.contains(".") && winnerVersion.contains(".")) {
                String candidateMajor = candidateVersion.substring(0, candidateVersion.indexOf(46));
                String winnerMajor = winnerVersion.substring(0, winnerVersion.indexOf(46));
                return Objects.equals(candidateMajor, winnerMajor);
            }
            return true;
        }
    }

    public static class VersionConvergence
    implements SelectionStrategy {
        private final SelectionStrategy delegate;

        public VersionConvergence(SelectionStrategy delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public boolean isBetter(ConflictResolver.ConflictItem candidate, ConflictResolver.ConflictItem winner) {
            return this.delegate.isBetter(candidate, winner);
        }

        @Override
        public ConflictResolver.ConflictItem winnerSelected(ConflictResolver.ConflictItem winner, Collection<ConflictResolver.ConflictItem> candidates, ConflictResolver.ConflictContext context) throws UnsolvableVersionConflictException {
            Set versions;
            if (winner != null && winner.getNode().getVersionConstraint().getRange() == null && (versions = candidates.stream().map(c -> c.getDependency().getArtifact().getVersion()).collect(Collectors.toSet())).size() > 1) {
                throw ConfigurableVersionSelector.newFailure("Convergence violated for " + winner.getDependency().getArtifact().getGroupId() + ":" + winner.getDependency().getArtifact().getArtifactId() + ", versions present: " + versions, context);
            }
            return winner;
        }
    }
}

