/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.util.MemoryTracker;

public class CollectorMemoryTracker
implements MemoryTracker {
    private String name;
    private AtomicLong memoryUsage;
    private final long memoryLimit;

    public CollectorMemoryTracker(String name, long memoryLimit) {
        this.name = name;
        this.memoryUsage = new AtomicLong();
        this.memoryLimit = memoryLimit;
    }

    @Override
    public void updateBytes(long bytes) {
        long currentMemoryUsage = this.memoryUsage.addAndGet(bytes);
        if (currentMemoryUsage > this.memoryLimit) {
            throw new IllegalStateException("Memory limit exceeded for " + this.name);
        }
        if (currentMemoryUsage < 0L) {
            throw new IllegalStateException("Illegal Memory State for " + this.name);
        }
    }

    @Override
    public long getBytes() {
        return this.memoryUsage.get();
    }
}

