/*
 * Decompiled with CFR 0.152.
 */
package com.martinkl.warc;

import com.martinkl.warc.WARCFileWriter;
import com.martinkl.warc.WARCRecord;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WARCFileReader {
    private static final Logger logger = LoggerFactory.getLogger(WARCFileReader.class);
    private final long fileSize;
    private CountingInputStream byteStream = null;
    private DataInputStream dataStream = null;
    private long bytesRead = 0L;
    private long recordsRead = 0L;

    public WARCFileReader(Configuration conf, Path filePath) throws IOException {
        FileSystem fs = filePath.getFileSystem(conf);
        this.fileSize = fs.getFileStatus(filePath).getLen();
        logger.info("Reading from " + filePath);
        CompressionCodec codec = filePath.getName().endsWith(".gz") ? WARCFileWriter.getGzipCodec(conf) : null;
        this.byteStream = new CountingInputStream(new BufferedInputStream((InputStream)fs.open(filePath)));
        this.dataStream = new DataInputStream(codec == null ? this.byteStream : codec.createInputStream((InputStream)this.byteStream));
    }

    public WARCRecord read() throws IOException {
        WARCRecord record = new WARCRecord(this.dataStream);
        ++this.recordsRead;
        return record;
    }

    public void close() throws IOException {
        if (this.dataStream != null) {
            this.dataStream.close();
        }
        this.byteStream = null;
        this.dataStream = null;
    }

    public long getRecordsRead() {
        return this.recordsRead;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public float getProgress() {
        if (this.fileSize == 0L) {
            return 1.0f;
        }
        return (float)this.bytesRead / (float)this.fileSize;
    }

    private class CountingInputStream
    extends FilterInputStream {
        public CountingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            if (result != -1) {
                WARCFileReader.this.bytesRead++;
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            if (result != -1) {
                WARCFileReader.this.bytesRead += result;
            }
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long result = this.in.skip(n);
            WARCFileReader.this.bytesRead += result;
            return result;
        }
    }
}

