/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.Utils;

public class Pair<T1, T2>
implements Serializable,
MapWriter {
    private final T1 first;
    private final T2 second;

    public T1 first() {
        return this.first;
    }

    public T2 second() {
        return this.second;
    }

    public Pair(T1 key, T2 value) {
        this.first = key;
        this.second = value;
    }

    public boolean equals(Object that) {
        return that instanceof Pair && Objects.equals(this.first, ((Pair)that).first) && Objects.equals(this.second, ((Pair)that).second);
    }

    public String toString() {
        return Utils.toJSONString(Utils.makeMap("first", this.first, "second", this.second));
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"first", this.first);
        ew.put((CharSequence)"second", this.second);
    }

    public static Pair parse(Map m) {
        return new Pair(m.get("first"), m.get("second"));
    }
}

