/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ClipboardHandler;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.impl.SelectionDelegate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

class DoTypeProcessor
implements Serializable {
    private static final Map<Integer, Character> SPECIAL_KEYS_MAP_ = new HashMap<Integer, Character>();
    private final DomNode domNode_;

    DoTypeProcessor(DomNode domNode) {
        this.domNode_ = domNode;
    }

    void doType(String currentValue, SelectionDelegate selectionDelegate, char c, HtmlElement element, boolean lastType) {
        int selectionStart = selectionDelegate.getSelectionStart();
        selectionStart = Math.max(0, Math.min(selectionStart, currentValue.length()));
        int selectionEnd = selectionDelegate.getSelectionEnd();
        selectionEnd = Math.max(selectionStart, Math.min(selectionEnd, currentValue.length()));
        StringBuilder newValue = new StringBuilder(currentValue);
        if (c == '\b') {
            if (selectionStart > 0) {
                newValue.deleteCharAt(selectionStart - 1);
                --selectionStart;
                --selectionEnd;
            }
        } else if (this.acceptChar(c)) {
            boolean ctrlKey = element.isCtrlPressed();
            if (ctrlKey && (c == 'C' || c == 'c')) {
                ClipboardHandler clipboardHandler = element.getPage().getWebClient().getClipboardHandler();
                if (clipboardHandler != null) {
                    String content = newValue.substring(selectionStart, selectionEnd);
                    clipboardHandler.setClipboardContent(content);
                }
            } else if (ctrlKey && (c == 'V' || c == 'v')) {
                ClipboardHandler clipboardHandler = element.getPage().getWebClient().getClipboardHandler();
                if (clipboardHandler != null) {
                    String content = clipboardHandler.getClipboardContent();
                    DoTypeProcessor.add(newValue, content, selectionStart, selectionEnd);
                    selectionEnd = selectionStart += content.length();
                }
            } else if (ctrlKey && (c == 'X' || c == 'x')) {
                ClipboardHandler clipboardHandler = element.getPage().getWebClient().getClipboardHandler();
                if (clipboardHandler != null) {
                    String content = newValue.substring(selectionStart, selectionEnd);
                    clipboardHandler.setClipboardContent(content);
                    newValue.delete(selectionStart, selectionEnd);
                    selectionEnd = selectionStart;
                }
            } else if (ctrlKey && (c == 'A' || c == 'a')) {
                selectionStart = 0;
                selectionEnd = newValue.length();
            } else {
                DoTypeProcessor.add(newValue, c, selectionStart, selectionEnd);
                selectionEnd = ++selectionStart;
            }
        }
        this.typeDone(newValue.toString(), lastType);
        selectionDelegate.setSelectionStart(selectionStart);
        selectionDelegate.setSelectionEnd(selectionEnd);
    }

    private static void add(StringBuilder newValue, char c, int selectionStart, int selectionEnd) {
        if (selectionStart == newValue.length()) {
            newValue.append(c);
        } else {
            newValue.replace(selectionStart, selectionEnd, Character.toString(c));
        }
    }

    private static void add(StringBuilder newValue, String string, int selectionStart, int selectionEnd) {
        if (selectionStart == newValue.length()) {
            newValue.append(string);
        } else {
            newValue.replace(selectionStart, selectionEnd, string);
        }
    }

    private void typeDone(String newValue, boolean notifyAttributeChangeListeners) {
        if (this.domNode_ instanceof DomText) {
            ((DomText)this.domNode_).setData(newValue);
        } else {
            ((HtmlElement)this.domNode_).typeDone(newValue, notifyAttributeChangeListeners);
        }
    }

    private boolean acceptChar(char ch) {
        if (this.domNode_ instanceof DomText) {
            return ((DomText)this.domNode_).acceptChar(ch);
        }
        return ((HtmlElement)this.domNode_).acceptChar(ch);
    }

    void doType(String currentValue, SelectionDelegate selectionDelegate, int keyCode, HtmlElement element, boolean lastType) {
        int selectionStart = selectionDelegate.getSelectionStart();
        int selectionEnd = selectionDelegate.getSelectionEnd();
        selectionEnd = Math.max(selectionStart, Math.min(selectionEnd, currentValue.length()));
        Character ch = SPECIAL_KEYS_MAP_.get(keyCode);
        if (ch != null) {
            this.doType(currentValue, selectionDelegate, ch.charValue(), element, lastType);
            return;
        }
        StringBuilder newValue = new StringBuilder(currentValue);
        switch (keyCode) {
            case 8: {
                if (selectionStart <= 0) break;
                newValue.deleteCharAt(selectionStart - 1);
                --selectionStart;
                break;
            }
            case 37: {
                if (element.isCtrlPressed()) {
                    for (selectionStart = Math.max(0, Math.min(selectionStart, currentValue.length())); selectionStart > 0 && newValue.charAt(selectionStart - 1) != ' '; --selectionStart) {
                    }
                    break;
                }
                if (selectionStart <= 0) break;
                --selectionStart;
                break;
            }
            case 39: {
                if (element.isCtrlPressed()) {
                    if (selectionStart < newValue.length()) {
                        ++selectionStart;
                    }
                    while (selectionStart < newValue.length() && newValue.charAt(selectionStart - 1) != ' ') {
                        ++selectionStart;
                    }
                    break;
                }
                if (element.isShiftPressed()) {
                    ++selectionEnd;
                    break;
                }
                if (selectionStart <= 0) break;
                ++selectionStart;
                break;
            }
            case 36: {
                selectionStart = 0;
                break;
            }
            case 35: {
                if (element.isShiftPressed()) {
                    selectionEnd = newValue.length();
                    break;
                }
                selectionStart = newValue.length();
                break;
            }
            case 46: {
                if (selectionEnd == selectionStart) {
                    ++selectionEnd;
                }
                newValue.delete(selectionStart, selectionEnd);
                selectionEnd = selectionStart;
                break;
            }
            default: {
                return;
            }
        }
        if (!element.isShiftPressed()) {
            selectionEnd = selectionStart;
        }
        this.typeDone(newValue.toString(), lastType);
        selectionDelegate.setSelectionStart(selectionStart);
        selectionDelegate.setSelectionEnd(selectionEnd);
    }

    static {
        SPECIAL_KEYS_MAP_.put(107, Character.valueOf('+'));
        SPECIAL_KEYS_MAP_.put(110, Character.valueOf('.'));
        SPECIAL_KEYS_MAP_.put(111, Character.valueOf('/'));
        SPECIAL_KEYS_MAP_.put(61, Character.valueOf('='));
        SPECIAL_KEYS_MAP_.put(106, Character.valueOf('*'));
        SPECIAL_KEYS_MAP_.put(59, Character.valueOf(';'));
        SPECIAL_KEYS_MAP_.put(108, Character.valueOf(','));
        SPECIAL_KEYS_MAP_.put(32, Character.valueOf(' '));
        SPECIAL_KEYS_MAP_.put(109, Character.valueOf('-'));
        for (int i = 96; i <= 105; ++i) {
            SPECIAL_KEYS_MAP_.put(i, Character.valueOf((char)(48 + (i - 96))));
        }
    }
}

