/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.metadata;

import java.net.URI;

public class LogMetadata {
    public static final int LAYOUT_VERSION = -1;
    public static final String LOGSEGMENTS_PATH = "/ledgers";
    public static final String VERSION_PATH = "/version";
    public static final String MAX_TXID_PATH = "/maxtxid";
    public static final String LOCK_PATH = "/lock";
    public static final String ALLOCATION_PATH = "/allocation";
    public static final String READ_LOCK_PATH = "/readLock";
    protected final URI uri;
    protected final String logName;
    protected final String logIdentifier;
    protected final String logRootPath;
    protected final String logSegmentsPath;
    protected final String lockPath;
    protected final String maxTxIdPath;
    protected final String allocationPath;

    protected static String getLogComponentPath(URI uri, String logName, String logIdentifier, String component) {
        return String.format("%s/%s/%s%s", uri.getPath(), logName, logIdentifier, component);
    }

    public static String getLogStreamPath(URI uri, String logName) {
        return String.format("%s/%s", uri.getPath(), logName);
    }

    public static String getLogRootPath(URI uri, String logName, String logIdentifier) {
        return LogMetadata.getLogComponentPath(uri, logName, logIdentifier, "");
    }

    public static String getLogSegmentsPath(URI uri, String logName, String logIdentifier) {
        return LogMetadata.getLogComponentPath(uri, logName, logIdentifier, LOGSEGMENTS_PATH);
    }

    protected LogMetadata(URI uri, String logName, String logIdentifier) {
        this.uri = uri;
        this.logName = logName;
        this.logIdentifier = logIdentifier;
        this.logRootPath = LogMetadata.getLogRootPath(uri, logName, logIdentifier);
        this.logSegmentsPath = this.logRootPath + LOGSEGMENTS_PATH;
        this.lockPath = this.logRootPath + LOCK_PATH;
        this.maxTxIdPath = this.logRootPath + MAX_TXID_PATH;
        this.allocationPath = this.logRootPath + ALLOCATION_PATH;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getLogName() {
        return this.logName;
    }

    public String getLogRootPath() {
        return this.logRootPath;
    }

    public String getLogSegmentsPath() {
        return this.logSegmentsPath;
    }

    public String getLogSegmentPath(String segmentName) {
        return this.logSegmentsPath + "/" + segmentName;
    }

    public String getLockPath() {
        return this.lockPath;
    }

    public String getMaxTxIdPath() {
        return this.maxTxIdPath;
    }

    public String getAllocationPath() {
        return this.allocationPath;
    }

    public String getFullyQualifiedName() {
        return String.format("%s:%s", this.logName, this.logIdentifier);
    }
}

