/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.sharding;

import org.apache.shardingsphere.elasticjob.kernel.internal.storage.JobNodePath;

public final class ShardingNode {
    public static final String ROOT = "sharding";
    private static final String INSTANCE_APPENDIX = "instance";
    private static final String INSTANCE = "sharding/%s/instance";
    private static final String RUNNING_APPENDIX = "running";
    private static final String RUNNING = "sharding/%s/running";
    private static final String MISFIRE = "sharding/%s/misfire";
    private static final String DISABLED = "sharding/%s/disabled";
    private static final String LEADER_ROOT = "leader/sharding";
    static final String NECESSARY = "leader/sharding/necessary";
    static final String PROCESSING = "leader/sharding/processing";
    private final JobNodePath jobNodePath;

    public ShardingNode(String jobName) {
        this.jobNodePath = new JobNodePath(jobName);
    }

    public static String getInstanceNode(int item) {
        return String.format(INSTANCE, item);
    }

    public static String getRunningNode(int item) {
        return String.format(RUNNING, item);
    }

    static String getMisfireNode(int item) {
        return String.format(MISFIRE, item);
    }

    static String getDisabledNode(int item) {
        return String.format(DISABLED, item);
    }

    public Integer getItemByRunningItemPath(String path) {
        if (!this.isRunningItemPath(path)) {
            return null;
        }
        return Integer.parseInt(path.substring(this.jobNodePath.getFullPath(ROOT).length() + 1, path.lastIndexOf(RUNNING_APPENDIX) - 1));
    }

    private boolean isRunningItemPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(ROOT)) && path.endsWith(RUNNING_APPENDIX);
    }
}

