/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.snapshot;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.shardingsphere.elasticjob.kernel.infra.util.SensitiveInfoUtils;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapshotService.class);
    public static final String DUMP_COMMAND = "dump@";
    private final int port;
    private final CoordinatorRegistryCenter regCenter;
    private ServerSocket serverSocket;
    private volatile boolean closed;

    public SnapshotService(CoordinatorRegistryCenter regCenter, int port) {
        Preconditions.checkArgument((port >= 0 && port <= 65535 ? 1 : 0) != 0, (Object)("Port value out of range: " + port));
        this.regCenter = regCenter;
        this.port = port;
    }

    public void listen() {
        try {
            log.info("ElasticJob: Snapshot service is running on port '{}'", (Object)this.openSocket(this.port));
        }
        catch (IOException ex) {
            log.error("ElasticJob: Snapshot service listen failure, error is: ", (Throwable)ex);
        }
    }

    private int openSocket(int port) throws IOException {
        this.closed = false;
        this.serverSocket = new ServerSocket(port);
        int localPort = this.serverSocket.getLocalPort();
        String threadName = String.format("elasticjob-snapshot-service-%d", localPort);
        new Thread(() -> {
            while (!this.closed) {
                try {
                    this.process(this.serverSocket.accept());
                }
                catch (IOException ex) {
                    if (this.isIgnoredException()) {
                        return;
                    }
                    log.error("ElasticJob: Snapshot service open socket failure, error is: ", (Throwable)ex);
                }
            }
        }, threadName).start();
        return localPort;
    }

    private boolean isIgnoredException() {
        return this.serverSocket.isClosed();
    }

    private void process(Socket socket) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
             Socket ignored = socket;){
            String cmdLine = reader.readLine();
            if (null != cmdLine && cmdLine.startsWith(DUMP_COMMAND) && cmdLine.split("@").length == 2) {
                String jobName = cmdLine.split("@")[1];
                String result = this.dumpJobDirectly(jobName);
                this.outputMessage(writer, result);
            }
        }
    }

    private void dumpDirectly(String path, String jobName, List<String> result) {
        for (String each : this.regCenter.getChildrenKeys(path)) {
            CuratorCache cache;
            String zkPath = path + "/" + each;
            String zkValue = Optional.ofNullable(this.regCenter.get(zkPath)).orElse("");
            String cachePath = zkPath;
            String cacheValue = zkValue;
            if (this.regCenter instanceof ZookeeperRegistryCenter && null != (cache = (CuratorCache)this.regCenter.getRawCache("/" + jobName))) {
                Optional cacheData = cache.get(zkPath);
                cachePath = cacheData.map(ChildData::getPath).orElse("");
                cacheValue = cacheData.map(ChildData::getData).map(String::new).orElse("");
            }
            if (zkValue.equals(cacheValue) && zkPath.equals(cachePath)) {
                result.add(String.join((CharSequence)" | ", zkPath, zkValue));
            } else {
                result.add(String.join((CharSequence)" | ", zkPath, zkValue, cachePath, cacheValue));
            }
            this.dumpDirectly(zkPath, jobName, result);
        }
    }

    public String dumpJobDirectly(String jobName) {
        String path = "/" + jobName;
        ArrayList<String> result = new ArrayList<String>();
        this.dumpDirectly(path, jobName, result);
        return String.join((CharSequence)"\n", SensitiveInfoUtils.filterSensitiveIps(result)) + "\n";
    }

    /*
     * Exception decompiling
     */
    public static String dumpJob(String instanceIp, int dumpPort, String jobName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void outputMessage(BufferedWriter outputWriter, String msg) throws IOException {
        outputWriter.append(msg);
        outputWriter.flush();
    }

    public void close() {
        this.closed = true;
        if (null != this.serverSocket && !this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                log.error("ElasticJob: Snapshot service close failure, error is: ", (Throwable)ex);
            }
        }
    }
}

