/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.resources.saml2sp4ui;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.resources.saml2sp4ui.AbstractSAML2SP4UIResource;
import org.apache.syncope.common.lib.saml2.SAML2Request;
import org.apache.syncope.common.lib.saml2.SAML2Response;
import org.apache.syncope.common.rest.api.service.SAML2SP4UIService;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;

public abstract class LogoutResource
extends AbstractSAML2SP4UIResource {
    private static final long serialVersionUID = 4865223550672539533L;

    protected abstract Class<? extends WebPage> getLogoutPageClass();

    protected AbstractResource.ResourceResponse doLogout(SAML2Response saml2Response) {
        SAML2SP4UIService service = (SAML2SP4UIService)((BaseSession)BaseSession.class.cast(Session.get())).getAnonymousService(SAML2SP4UIService.class);
        service.validateLogoutResponse(saml2Response);
        throw new RestartResponseException(this.getLogoutPageClass(), new PageParameters());
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
        HttpServletResponse response = (HttpServletResponse)attributes.getResponse().getContainerResponse();
        switch (request.getMethod()) {
            case "GET": {
                String samlResponse = request.getParameter("SAMLResponse");
                String relayState = request.getParameter("RelayState");
                if (samlResponse == null) {
                    Cookie idpEntityID = new Cookie("saml2sp4ui.idpEntityID", request.getParameter("saml2sp4ui.idpEntityID"));
                    idpEntityID.setMaxAge(-1);
                    response.addCookie(idpEntityID);
                    SAML2SP4UIService service = (SAML2SP4UIService)((BaseSession)BaseSession.class.cast(Session.get())).getService(SAML2SP4UIService.class);
                    SAML2Request logoutRequest = service.createLogoutRequest(this.spEntityID(attributes), "saml2sp4ui");
                    Session.get().invalidate();
                    return this.send(logoutRequest);
                }
                return this.doLogout(this.buildResponse(attributes, samlResponse, relayState));
            }
            case "POST": {
                return this.doLogout(this.extract(attributes));
            }
        }
        throw new UnsupportedOperationException("Only GET and POST are supported");
    }
}

