/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class ScopeSearchingELResolver
extends ELResolver {
    private RequestContext requestContext;

    public ScopeSearchingELResolver() {
    }

    public ScopeSearchingELResolver(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object base) {
        if (base == null) {
            return Object.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object base) {
        return null;
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return null;
        }
        String attributeName = property.toString();
        if (requestContext.getRequestScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getRequestScope().get(attributeName).getClass();
        }
        if (requestContext.getFlashScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getFlashScope().get(attributeName).getClass();
        }
        if (requestContext.inViewState() && requestContext.getViewScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getViewScope().get(attributeName).getClass();
        }
        if (requestContext.getFlowScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getFlowScope().get(attributeName).getClass();
        }
        if (requestContext.getConversationScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getConversationScope().get(attributeName).getClass();
        }
        return null;
    }

    public Object getValue(ELContext elContext, Object base, Object property) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return null;
        }
        String attributeName = property.toString();
        if (requestContext.getRequestScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getRequestScope().get(attributeName);
        }
        if (requestContext.getFlashScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getFlashScope().get(attributeName);
        }
        if (requestContext.inViewState() && requestContext.getViewScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getViewScope().get(attributeName);
        }
        if (requestContext.getFlowScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getFlowScope().get(attributeName);
        }
        if (requestContext.getConversationScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getConversationScope().get(attributeName);
        }
        return null;
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return false;
        }
        String attributeName = property.toString();
        if (requestContext.getRequestScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return false;
        }
        if (requestContext.getFlashScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return false;
        }
        if (requestContext.inViewState() && requestContext.getViewScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return false;
        }
        if (requestContext.getFlowScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return false;
        }
        if (requestContext.getConversationScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return false;
        }
        return false;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return;
        }
        String attributeName = property.toString();
        if (requestContext.getRequestScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            requestContext.getRequestScope().put(attributeName, value);
        } else if (requestContext.getFlashScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            requestContext.getFlashScope().put(attributeName, value);
        } else if (requestContext.inViewState() && requestContext.getViewScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            requestContext.getViewScope().put(attributeName, value);
        } else if (requestContext.getFlowScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            requestContext.getFlowScope().put(attributeName, value);
        } else if (requestContext.getConversationScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            requestContext.getConversationScope().put(attributeName, value);
        }
    }

    protected RequestContext getRequestContext() {
        return this.requestContext != null ? this.requestContext : RequestContextHolder.getRequestContext();
    }
}

