/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.core.persistence.api.entity.keymaster.NetworkServiceEntity;
import org.apache.syncope.core.persistence.jpa.dao.repo.NetworkServiceRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.keymaster.JPANetworkService;
import org.springframework.transaction.annotation.Transactional;

public class NetworkServiceRepoExtImpl
implements NetworkServiceRepoExt {
    protected final EntityManager entityManager;

    public NetworkServiceRepoExtImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    @Transactional(readOnly=true)
    public List<NetworkServiceEntity> findAll(NetworkService.Type serviceType) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPANetworkService.class.getSimpleName() + " e WHERE e.type=:serviceType", NetworkServiceEntity.class);
        query.setParameter("serviceType", (Object)serviceType);
        return query.getResultList();
    }

    @Override
    public void deleteAll(NetworkService service) {
        Query query = this.entityManager.createQuery("DELETE FROM " + JPANetworkService.class.getSimpleName() + " e WHERE e.type=:serviceType AND e.address=:address");
        query.setParameter("serviceType", (Object)service.getType());
        query.setParameter("address", (Object)service.getAddress());
        query.executeUpdate();
    }
}

