/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter.actuate;

import java.util.Map;
import org.apache.syncope.core.persistence.api.dao.EntityCacheDAO;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;

@Endpoint(id="entityCache")
public class EntityCacheEndpoint {
    protected final EntityCacheDAO entityCacheDAO;

    public EntityCacheEndpoint(EntityCacheDAO entityCacheDAO) {
        this.entityCacheDAO = entityCacheDAO;
    }

    @ReadOperation
    public Map<String, Object> statistics() {
        return this.entityCacheDAO.getStatistics();
    }

    @WriteOperation
    public void statistics(@Selector String operation) {
        switch (operation) {
            case "enable": 
            case "ENABLE": {
                this.entityCacheDAO.enableStatistics();
                break;
            }
            case "disable": 
            case "DISABLE": {
                this.entityCacheDAO.disableStatistics();
                break;
            }
            case "reset": 
            case "RESET": {
                this.entityCacheDAO.resetStatistics();
                break;
            }
            default: {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Unsupported Operation: " + operation);
            }
        }
    }

    @DeleteOperation
    public void clearCache() {
        this.entityCacheDAO.clearCache();
    }
}

