/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.mfa.webauthn;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.jooq.lambda.Unchecked;

@RequiresModule(name="cas-server-support-webauthn")
public class WebAuthnMultifactorAttestationTrustSourceFidoProperties
implements Serializable {
    public static final String DEFAULT_LEGAL_HEADER = "Retrieval and use of this BLOB indicates acceptance of the appropriate agreement located at https://fidoalliance.org/metadata/metadata-legal-terms/";
    private static final long serialVersionUID = -6224841263678287815L;
    @RequiredProperty
    private String legalHeader;
    @RequiredProperty
    private String metadataBlobUrl = "https://mds.fidoalliance.org/";
    @RequiredProperty
    private String trustRootUrl = "https://secure.globalsign.com/cacert/root-r3.crt";
    @RequiredProperty
    private String trustRootHash = "cbb522d7b7f127ad6a0113865bdf1cd4102e7d0759af635a7cf4720dc963c53b";
    private File trustRootCacheFile = (File)Unchecked.supplier(() -> Files.createTempFile("webauthn.fido.trust.root", ".cache", new FileAttribute[0]).toFile()).get();
    private File blobCacheFile = (File)Unchecked.supplier(() -> Files.createTempFile("webauthn.fido.blob", ".cache", new FileAttribute[0]).toFile()).get();

    @Generated
    public String getLegalHeader() {
        return this.legalHeader;
    }

    @Generated
    public String getMetadataBlobUrl() {
        return this.metadataBlobUrl;
    }

    @Generated
    public String getTrustRootUrl() {
        return this.trustRootUrl;
    }

    @Generated
    public String getTrustRootHash() {
        return this.trustRootHash;
    }

    @Generated
    public File getTrustRootCacheFile() {
        return this.trustRootCacheFile;
    }

    @Generated
    public File getBlobCacheFile() {
        return this.blobCacheFile;
    }

    @Generated
    public WebAuthnMultifactorAttestationTrustSourceFidoProperties setLegalHeader(String legalHeader) {
        this.legalHeader = legalHeader;
        return this;
    }

    @Generated
    public WebAuthnMultifactorAttestationTrustSourceFidoProperties setMetadataBlobUrl(String metadataBlobUrl) {
        this.metadataBlobUrl = metadataBlobUrl;
        return this;
    }

    @Generated
    public WebAuthnMultifactorAttestationTrustSourceFidoProperties setTrustRootUrl(String trustRootUrl) {
        this.trustRootUrl = trustRootUrl;
        return this;
    }

    @Generated
    public WebAuthnMultifactorAttestationTrustSourceFidoProperties setTrustRootHash(String trustRootHash) {
        this.trustRootHash = trustRootHash;
        return this;
    }

    @Generated
    public WebAuthnMultifactorAttestationTrustSourceFidoProperties setTrustRootCacheFile(File trustRootCacheFile) {
        this.trustRootCacheFile = trustRootCacheFile;
        return this;
    }

    @Generated
    public WebAuthnMultifactorAttestationTrustSourceFidoProperties setBlobCacheFile(File blobCacheFile) {
        this.blobCacheFile = blobCacheFile;
        return this;
    }
}

