/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.widget.dialog;

import java.io.Serializable;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.jquery.ui.widget.dialog.ButtonAjaxBehavior;

public class DialogButton
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static short sequence = 0;
    private final int id = DialogButton.nextSequence();
    private String name;
    private String icon;
    private boolean enabled;
    private final IModel<String> model;

    private static synchronized int nextSequence() {
        short s = sequence;
        sequence = (short)(s + 1);
        return s % Short.MAX_VALUE;
    }

    public DialogButton(String name, String text) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)text)), "", true);
    }

    public DialogButton(String name, String text, String icon) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)text)), icon, true);
    }

    public DialogButton(String name, String text, boolean enabled) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)text)), "", enabled);
    }

    public DialogButton(String name, String text, String icon, boolean enabled) {
        this(name, (IModel<String>)Model.of((Serializable)((Object)text)), icon, enabled);
    }

    public DialogButton(String name, IModel<String> model) {
        this(name, model, "", true);
    }

    public DialogButton(String name, IModel<String> model, String icon) {
        this(name, model, icon, true);
    }

    public DialogButton(String name, IModel<String> model, boolean enabled) {
        this(name, model, "", enabled);
    }

    public DialogButton(String name, IModel<String> model, String icon, boolean enabled) {
        this.name = name;
        this.model = model;
        this.icon = icon;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    IModel<String> getModel() {
        return this.model;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(boolean enabled, IPartialPageRequestHandler handler) {
        this.setEnabled(enabled);
        if (enabled) {
            this.enable(handler);
        } else {
            this.disable(handler);
        }
    }

    public void setVisible(boolean visible, IPartialPageRequestHandler handler) {
        if (visible) {
            this.show(handler);
        } else {
            this.hide(handler);
        }
    }

    public boolean isIndicating() {
        return false;
    }

    public String getMarkupId() {
        return String.format("btn%02x", this.id).toLowerCase();
    }

    protected CharSequence getCallbackScript(ButtonAjaxBehavior behavior) {
        return behavior.getCallbackScript();
    }

    private void enable(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("jQuery('#%s').button('enable');", this.getMarkupId()));
    }

    private void disable(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("jQuery('#%s').button('disable');", this.getMarkupId()));
    }

    private void show(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("jQuery('#%s').show();", this.getMarkupId()));
    }

    private void hide(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("jQuery('#%s').hide();", this.getMarkupId()));
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (object instanceof DialogButton) {
            return this.match(((DialogButton)object).getName());
        }
        return super.equals(object);
    }

    public boolean match(String name) {
        return Strings.isEqual((String)name, (String)this.name);
    }

    public String toString() {
        return (String)this.model.getObject();
    }
}

