/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.common.rest.api.beans.UserRequestQuery;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class UserRequestRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -4785231164900813921L;

    public long countRequests(String keyword) {
        try {
            return ((UserRequestService)this.getService(UserRequestService.class)).listRequests((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().user(keyword).page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public List<UserRequest> listRequests(String keyword, int page, int size, SortParam<String> sort) {
        try {
            return ((UserRequestService)this.getService(UserRequestService.class)).listRequests((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().user(keyword).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(UserRequestRestClient.toOrderBy(sort))).build()).getResult();
        }
        catch (SyncopeClientException e) {
            return List.of();
        }
    }

    public void cancelRequest(String executionId, String reason) {
        ((UserRequestService)this.getService(UserRequestService.class)).cancelRequest(executionId, reason);
    }

    public long countForms(String keyword) {
        try {
            return ((UserRequestService)this.getService(UserRequestService.class)).listForms((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().user(keyword).page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
        }
        catch (SyncopeClientException e) {
            return 0L;
        }
    }

    public List<UserRequestForm> listForms(String keyword, int page, int size, SortParam<String> sort) {
        try {
            return ((UserRequestService)this.getService(UserRequestService.class)).listForms((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().user(keyword).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(UserRequestRestClient.toOrderBy(sort))).build()).getResult();
        }
        catch (SyncopeClientException e) {
            return List.of();
        }
    }

    public Optional<UserRequestForm> getForm(String userKey) {
        PagedResult forms = ((UserRequestService)this.getService(UserRequestService.class)).listForms((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().user(userKey).page(Integer.valueOf(1))).size(Integer.valueOf(1))).build());
        UserRequestForm form = forms.getResult().isEmpty() ? null : (UserRequestForm)forms.getResult().getFirst();
        return Optional.ofNullable(form);
    }

    public UserRequestForm claimForm(String taskKey) {
        return ((UserRequestService)this.getService(UserRequestService.class)).claimForm(taskKey);
    }

    public UserRequestForm unclaimForm(String taskKey) {
        return ((UserRequestService)this.getService(UserRequestService.class)).unclaimForm(taskKey);
    }

    public void submitForm(UserRequestForm form) {
        ((UserRequestService)this.getService(UserRequestService.class)).submitForm(form);
    }

    public Map<String, String> batch(BatchRequest batchRequest) {
        ArrayList batchRequestItems = new ArrayList(batchRequest.getItems());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            List batchResponseItems = batchRequest.commit().getItems();
            for (int i = 0; i < batchResponseItems.size(); ++i) {
                String status = this.getStatus(((BatchResponseItem)batchResponseItems.get(i)).getStatus());
                result.put(StringUtils.substringAfterLast((String)((BatchRequestItem)batchRequestItems.get(i)).getRequestURI(), (String)"/"), status);
            }
        }
        catch (IOException e) {
            LOG.error("While processing Batch response", (Throwable)e);
        }
        return result;
    }
}

