/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.logging;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.identityconnectors.common.StringPrintWriter;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.logging.LogSpi;

class StdOutLogger
implements LogSpi {
    private static final String PATTERN = "Thread Id: {0}\tTime: {1}\tClass: {2}\tMethod: {3}\tLevel: {4}\tMessage: {5}";
    private static final ThreadLocal<MessageFormat> MSG_FORMAT_HANDLER = new ThreadLocal<MessageFormat>(){

        @Override
        protected MessageFormat initialValue() {
            return new MessageFormat(StdOutLogger.PATTERN);
        }
    };
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final ThreadLocal<DateFormat> DATE_FORMAT_HANDLER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(StdOutLogger.DATE_PATTERN);
        }
    };

    StdOutLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Class<?> clazz, String methodName, Log.Level level, String message, Throwable ex) {
        String msg;
        String now;
        try {
            now = DATE_FORMAT_HANDLER.get().format(new Date());
        }
        finally {
            DATE_FORMAT_HANDLER.remove();
        }
        Object[] args = new Object[]{Thread.currentThread().getId(), now, clazz.getName(), methodName, level, message};
        try {
            msg = MSG_FORMAT_HANDLER.get().format(args);
        }
        finally {
            MSG_FORMAT_HANDLER.remove();
        }
        PrintStream out = Log.Level.ERROR == level ? System.err : System.out;
        out.println(msg);
        if (ex != null) {
            StringPrintWriter wrt = new StringPrintWriter();
            ex.printStackTrace(wrt);
            out.print(wrt.getString());
        }
    }

    @Override
    public void log(Class<?> clazz, StackTraceElement caller, Log.Level level, String message, Throwable ex) {
        Object methodName = null;
        methodName = null != caller ? caller.getMethodName() + (String)(caller.isNativeMethod() ? "(Native Method)" : (caller.getFileName() != null && caller.getLineNumber() >= 0 ? "(" + caller.getFileName() + ":" + caller.getLineNumber() + ")" : (caller.getFileName() != null ? "(" + caller.getFileName() + ")" : "(Unknown Source)"))) : "unknown";
        this.log(clazz, (String)methodName, level, message, ex);
    }

    @Override
    public boolean isLoggable(Class<?> clazz, Log.Level level) {
        return true;
    }

    @Override
    public boolean needToInferCaller(Class<?> clazz, Log.Level level) {
        return true;
    }
}

