/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Optional;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.JWTAuthentication;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetailsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class JWTAuthenticationFilter
extends BasicAuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JWTAuthenticationFilter.class);
    private final AuthenticationEntryPoint authenticationEntryPoint;
    private final SyncopeAuthenticationDetailsSource authenticationDetailsSource;
    private final AuthDataAccessor dataAccessor;
    private final DefaultCredentialChecker credentialChecker;

    public JWTAuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint, SyncopeAuthenticationDetailsSource authenticationDetailsSource, AuthDataAccessor dataAccessor, DefaultCredentialChecker credentialChecker) {
        super(authenticationManager);
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.authenticationDetailsSource = authenticationDetailsSource;
        this.dataAccessor = dataAccessor;
        this.credentialChecker = credentialChecker;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String auth = request.getHeader("Authorization");
        String[] parts = Optional.ofNullable(auth).map(s -> s.split(" ")).orElse(null);
        if (parts == null || parts.length != 2 || !"Bearer".equals(parts[0])) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String stringToken = parts[1];
        LOG.debug("JWT received: {}", (Object)stringToken);
        try {
            this.credentialChecker.checkIsDefaultJWSKeyInUse();
            SignedJWT jwt = SignedJWT.parse((String)stringToken);
            JWTSSOProvider jwtSSOProvider = this.dataAccessor.getJWTSSOProvider(jwt.getJWTClaimsSet().getIssuer());
            if (!jwt.verify((JWSVerifier)jwtSSOProvider)) {
                throw new BadCredentialsException("Invalid signature found in JWT");
            }
            JWTClaimsSet claims = jwt.getJWTClaimsSet();
            long referenceTime = System.currentTimeMillis();
            Date expirationTime = claims.getExpirationTime();
            if (expirationTime != null && expirationTime.getTime() < referenceTime) {
                this.dataAccessor.removeExpired(claims.getJWTID());
                throw new CredentialsExpiredException("JWT is expired");
            }
            Date notBefore = claims.getNotBeforeTime();
            if (notBefore != null && notBefore.getTime() > referenceTime) {
                throw new CredentialsExpiredException("JWT not valid yet");
            }
            JWTAuthentication jwtAuthentication = new JWTAuthentication(claims, this.authenticationDetailsSource.buildDetails(request));
            jwtAuthentication.setAuthenticated(true);
            AuthContextUtils.runAsAdmin(jwtAuthentication.getDetails().getDomain(), () -> {
                AuthDataAccessor.JWTAuthResult authResult = this.dataAccessor.authenticate(jwtAuthentication);
                jwtAuthentication.setUsername(authResult.username());
                jwtAuthentication.getAuthorities().addAll(authResult.authorities());
            });
            SecurityContextHolder.getContext().setAuthentication((Authentication)jwtAuthentication);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (JOSEException | ParseException e) {
            SecurityContextHolder.clearContext();
            this.authenticationEntryPoint.commence(request, response, (AuthenticationException)new BadCredentialsException("Invalid JWT: " + stringToken, e));
        }
        catch (AuthenticationException e) {
            SecurityContextHolder.clearContext();
            this.authenticationEntryPoint.commence(request, response, e);
        }
    }
}

