/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrEncodingStream;

public class XdrBufferEncodingStream
extends XdrEncodingStream {
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrBufferEncodingStream(int bufferSize) {
        if (bufferSize < 0 || (bufferSize & 3) != 0) {
            throw new IllegalArgumentException("size of buffer must be a multiple of four and must not be negative");
        }
        this.buffer = new byte[bufferSize];
        this.bufferIndex = 0;
        this.bufferHighmark = this.buffer.length - 4;
    }

    public XdrBufferEncodingStream(byte[] buffer) {
        if ((buffer.length & 3) != 0) {
            throw new IllegalArgumentException("size of buffer must be a multiple of four");
        }
        this.buffer = buffer;
        this.bufferIndex = 0;
        this.bufferHighmark = buffer.length - 4;
    }

    public int getXdrLength() {
        return this.bufferIndex;
    }

    public byte[] getXdrData() {
        return this.buffer;
    }

    public void beginEncoding(InetAddress receiverAddress, int receiverPort) throws OncRpcException, IOException {
        this.bufferIndex = 0;
    }

    public void endEncoding() throws OncRpcException, IOException {
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
    }

    public void xdrEncodeInt(int value) throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            throw new OncRpcException(42);
        }
        this.buffer[this.bufferIndex++] = (byte)(value >>> 24);
        this.buffer[this.bufferIndex++] = (byte)(value >>> 16);
        this.buffer[this.bufferIndex++] = (byte)(value >>> 8);
        this.buffer[this.bufferIndex++] = (byte)value;
    }

    public void xdrEncodeOpaque(byte[] value, int offset, int length) throws OncRpcException, IOException {
        int padding = 4 - (length & 3) & 3;
        if (this.bufferIndex <= this.bufferHighmark - (length + padding)) {
            System.arraycopy(value, offset, this.buffer, this.bufferIndex, length);
            this.bufferIndex += length;
            if (padding != 0) {
                System.arraycopy(paddingZeros, 0, this.buffer, this.bufferIndex, padding);
                this.bufferIndex += padding;
            }
        } else {
            throw new OncRpcException(42);
        }
    }
}

