package Aion::Format::Html;

use common::sense;

use Exporter qw/import/;
our @EXPORT = our @EXPORT_OK = grep {
	*{$Aion::Format::Html::{$_}}{CODE} && !/^(_|(NaN|import)\z)/n
} keys %Aion::Format::Html::;

# Экранирует символы html
my %HTML_SIM = (qw/< &lt; > &gt; & &amp; \' &apos; " &quot;/, "\n" => '<br>', "\t" => '&emsp;');
sub to_html (;$) {
	my ($s) = @_? @_: $_;
	$s =~ s/[<>&\'\"]/$HTML_SIM{$&}/ge;
	$s
}

our %ENTITIES = (
#
# Управляющие символы C0 и основная латиница
# U+0000—U+007F
# Данный диапазон Юникода полностью соответствует стандарту ASCII за исключением соглашения о наложении литер через возврат на шаг.[3]
# Символ	Назначение	Мнемоника	HTML	Код
#
# U+0000—U+001F — управляющие символы C0
# табуляция — HT (ANSI), ГТ (ГОСТ)	&Tab;	5.0	U+0009 &#9;
Tab => 9,
# перевод строки — LF (ANSI), ПС (ГОСТ)	&NewLine;	5.0	U+000A &#10;
NewLine => 10,
#
# U+0032—U+007E — основная латиница
#
# пробел			U+0020 &#32;
# !	восклицательный знак	&excl;	5.0	U+0021 &#33;
excl => 33,
# "	двойная кавычка[4]	&QUOT;	5.0	U+0022 &#34; &quot;	2.0
quot => 34,
QUOT => 34,
# #	знак номера («решётка» или «диез»)	&num;	5.0	U+0023 &#35;
num => 35,
# $	знак доллара	&dollar;	5.0	U+0024 &#36;
dollar => 36,
# %	знак процента	&percnt;	5.0	U+0025 &#37;
percnt => 37,
# &	амперсанд	&AMP;	5.0	U+0026 &#38;  &amp;	1.0/2.0
amp => 38,
AMP => 38,
# '	одинарная кавычка (занимающий позицию апостроф)[5]	&apos;	5.0	U+0027 &#39;
apos => 39,
# (	левая круглая скобка	&lpar;	5.0	U+0028 &#40;
lpar => 40,
# )	правая круглая скобка	&rpar;	5.0	U+0029 &#41;
rpar => 41,
# *	звёздочка (может быть как высоко, так и среднерасположенной)[6][7]	&ast;	5.0	U+002A &#42; &midast;
ast => 42,
midast => 42,
# +	знак плюс	&plus;	5.0	U+002B &#43;
plus => 43,
# ,	запятая[8]	&comma;	5.0	U+002C &#44;
comma => 44,
# -	чёрточка-минус (не рекомендован к использованию)[9][10]			U+002D &#45;
# .	точка[11]	&period;	5.0	U+002E &#46;
period => 46,
# /	косая черта (солидус)[12][13]	&sol;	5.0	U+002F &#47;
sol => 47,
#
#
# U+0030—U+0039 — цифры 0—9[14]
#
# :	двоеточие	&colon;	5.0	U+003A &#58;
colon => 58,
# ;	точка с запятой	&semi;	5.0	U+003B &#59;
semi => 59,
# <	знак меньше	&LT;	5.0	U+003C &#60; &lt;	1.0/2.0
LT => 60,
lt => 60,
# =	знак равенства	&equals;	5.0	U+003D &#61;
equals => 61,
# >	знак больше	&GT;	5.0	U+003E &#62; &gt;	1.0/2.0
GT => 62,
gt => 62,
# ?	знак вопроса	&quest;	5.0	U+003F &#63;
quest => 63,
# @	коммерческий «эт»	&commat;	5.0	U+0040 &#64;
commat => 64,
#
#
# U+0041—U+005A — заглавные латинские буквы A—Z[15]
#
# [	левая квадратная скобка	&lsqb;	5.0	U+005B &#91; &lbrack;
lbrack => 91,
lsqb => 91,
# \	обратная косая черта[16]	&bsol;	5.0	U+005C &#92;
bsol => 92,
# ]	правая квадратная скобка	&rsqb;	5.0	U+005D &#93; &rbrack;
rsqb => 93,
rbrack => 93,
# ^	карет — (может быть как высоко, так и среднерасположенным)[17][18]	&Hat;	5.0	U+005E &#94;
Hat => 94,
# _	занимающее позицию подчёркивание (должно стыковаться по горизонтали)[19]	&lowbar;	5.0	U+005F &#95; &UnderBar;
lowbar => 95,
UnderBar => 95,
# `	занимающий позицию обратный апостроф (грейв)[20]	&grave;	5.0	U+0060 &#96; &DiacriticalGrave;
grave => 96,
DiacriticalGrave => 96,
#
# U+0061—U+007A — строчные латинские буквы a—z[21]
# {	левая фигурная скобка	&lcub;	5.0	U+007B &#123; &lbrace;
lcub => 123,
lbrace => 123,
# |	вертикальная черта[22]	&verbar;	5.0	U+007C &#124; &vert; &VerticalLine;
verbar => 124,
vert => 124,
VerticalLine => 124,
# }	правая фигурная скобка	&rcub;	5.0	U+007D &#125; &rbrace;
rcub => 125,
rbrace => 125,
# ~	занимающая позицию тильда (может быть как высоко, так и среднерасположенной, не рекомендуется к использованию)[23][24]			U+007E &#126;
#
# U+007F — управляющие символы C0
# Управляющие символы C1 и дополнение из Latin-1
# U+0080—U+00FF
# Исторически в диапазон U+00A0—U+00FF («Дополнение из Latin‑1») переносились литеры из соответствующих позиций Latin‑1 (ISO 8859‑1), пока не стало объявлено, что стандарт Latin‑1 включён в Юникод полностью — как ASCII (U+0000—U+007F), так и данный диапазон (U+0080—U+00FF), за исключением соглашения о наложении литер через возврат на шаг.
# Символ	Назначение	Мнемоника	HTML	Код
# U+0080—U+009F — управляющие символы C1
# U+00A0—U+00FF — дополнение из Latin‑1
#
#  	неразрывный пробел	&NonBreakingSpace;	5.0	U+00A0 &#160; &nbsp;	3.2
NonBreakingSpace => 160,
nbsp => 160,
# ¡	перевёрнутый восклицательный знак	&iexcl;	3.2	U+00A1 &#161;
iexcl => 161,
# ¢	символ цента	&cent;	3.2	U+00A2 &#162;
cent => 162,
# £	символ фунта	&pound;	3.2	U+00A3 &#163;
pound => 163,
# ¤	знак валюты	&curren;	3.2	U+00A4 &#164;
curren => 164,
# ¥	символ иены и юаня	&yen;	3.2	U+00A5 &#165;
yen => 165,
# ¦	разорванная вертикальная черта	&brkbar;	нестандарт	U+00A6 &#166;
brkbar => 166,
# &brvbar;	3.2
brvbar => 166,
# §	знак параграфа	&sect;	3.2	U+00A7 &#167;
sect => 167,
# ¨	диерезис, трема умлаут (все занимают позицию)	&die;	5.0	U+00A8 &#168; &Dot;	5.0 &DoubleDot;	5.0 &uml;	3.2
die => 168,
Dot => 168,
DoubleDot => 168,
uml => 168,
# ©	знак охраны авторского права	&COPY;	5.0	U+00A9 &#169; &copy;	3.2
COPY => 169,
copy => 169,
# ª	порядковый индикатор (женский род)	&ordf;	3.2	U+00AA &#170;
ordf => 170,
# «	направленная влево двойная угловая кавычка	&laquo;	3.2	U+00AB &#171;
laquo => 171,
# ¬	знак «отрицание»	&not;	3.2	U+00AC &#172;
not => 172,
# ­	мягкий перенос (обозначает место возможного переноса: при отсутствии переноса невидим, при наличии — виден как дефис перед разрывом строки). В примере, по отсутствию переноса, невидим.	&shy;	3.2	U+00AD &#173;
shy => 173,
# ®	знак правовой охраны товарного знака	&REG;	5.0	U+00AE &#174; &circledR;	5.0 &reg;	3.2
REG => 174,
circledR => 174,
reg => 174,
# ¯	занимающий позицию макрон	&hibar;	нестандарт	U+00AF &#175; &macron;	нестандарт &strns;	5.0 &macr;	3.2
hibar => 175,
macron => 175,
strns => 175,
macr => 175,
# °	занимающий позицию знак градуса	&degree;	нестандарт	U+00B0 &#176; &deg;	3.2
degree => 176,
deg => 176,
# ±	плюс-минус	&pm;	5.0	U+00B1 &#177; &PlusMinus;	5.0 &plusmn;	3.2
pm => 177,
PlusMinus => 177,
plusmn => 177,
# ²	верхний индекс «2»	&sup2;	3.2	U+00B2 &#178;
sup2 => 178,
# ³	верхний индекс «3»	&sup3;	3.2	U+00B3 &#179;
sup3 => 179,
# ´	занимающий позицию акут	&DiacriticalAcute;	5.0	U+00B4 &#180; &acute;	3.2
DiacriticalAcute => 180,
acute => 180,
# µ	дольный префикс микро микрон — устаревшее обозначение микрометра	&micro;	3.2	U+00B5 &#181;
micro => 181,
# ¶	знак абзаца	&para;	3.2	U+00B6 &#182;
para => 182,
# ·	интерпункт	&centerdot;	5.0	U+00B7 &#183; &CenterDot;	5.0 &middot;	3.2
middot => 183,
CenterDot => 183,
centerdot => 183,
# ¸	занимающая позицию седиль	&Cedilla;	5.0	U+00B8 &#184; &cedil;	3.2
Cedilla => 184,
cedil => 184,
# ¹	верхний индекс «1»	&sup1;	3.2	U+00B9 &#185;
sup1 => 185,
# º	порядковый индикатор (мужской род)	&ordm;	3.2	U+00BA &#186;
ordm => 186,
# »	направленная вправо двойная угловая кавычка	&raquo;	3.2	U+00BB &#187;
raquo => 187,
# ¼	простая дробь «одна четвёртая»	&frac14;	3.2	U+00BC &#188;
frac14 => 188,
# ½	простая дробь «одна вторая»	&half;	5.0	U+00BD &#189; &frac12;	3.2
half => 189,
frac12 => 189,
# ¾	простая дробь «три четверти»	&frac34;	3.2	U+00BE &#190;
frac34 => 190,
# ¿	перевёрнутый знак вопроса	&iquest;	3.2	U+00BF &#191;
iquest => 191,
# À	латинская заглавная A с грависом («тупым ударением»)	&Agrave;	2.0	U+00C0 &#192;
Agrave => 192,
# Á	латинская заглавная A с акутом («острым ударением»)	&Aacute;	2.0	U+00C1 &#193;
Aacute => 193,
# Â	латинская заглавная A с циркумфлексом	&Acirc;	2.0	U+00C2 &#194;
Acirc => 194,
# Ã	латинская заглавная A с тильдой	&Atilde;	2.0	U+00C3 &#195;
Atilde => 195,
# Ä	латинская заглавная A с тремой	&Auml;	2.0	U+00C4 &#196;
Auml => 196,
# Å	латинская заглавная A с кружком сверху	&Aring;	2.0	U+00C5 &#197;
Aring => 197,
# Æ	латинская заглавная лигатура AE	&AElig;	2.0	U+00C6 &#198;
AElig => 198,
# Ç	латинская заглавная C с седилью	&Ccedil;	2.0	U+00C7 &#199;
Ccedil => 199,
# È	латинская заглавная E с грависом	&Egrave;	2.0	U+00C8 &#200;
Egrave => 200,
# É	латинская заглавная E с акутом	&Eacute;	2.0	U+00C9 &#201;
Eacute => 201,
# Ê	латинская заглавная E с циркумфлексом	&Ecirc;	2.0	U+00CA &#202;
Ecirc => 202,
# Ë	латинская заглавная E с тремой	&Euml;	2.0	U+00CB &#203;
Euml => 203,
# Ì	латинская заглавная I с грависом	&Igrave;	2.0	U+00CC &#204;
Igrave => 204,
# Í	латинская заглавная I с акутом	&Iacute;	2.0	U+00CD &#205;
Iacute => 205,
# Î	латинская заглавная I с циркумфлексом	&Icirc;	2.0	U+00CE &#206;
Icirc => 206,
# Ï	латинская заглавная I с тремой	&Iuml;	2.0	U+00CF &#207;
Iuml => 207,
# Ð	латинская заглавная буква «eth»	&ETH;	2.0	U+00D0 &#208;
ETH => 208,
# Ñ	латинская заглавная N с тильдой	&Ntilde;	2.0	U+00D1 &#209;
Ntilde => 209,
# Ò	латинская заглавная O с грависом	&Ograve;	2.0	U+00D2 &#210;
Ograve => 210,
# Ó	латинская заглавная O с акутом	&Oacute;	2.0	U+00D3 &#211;
Oacute => 211,
# Ô	латинская заглавная O с циркумфлексом	&Ocirc;	2.0	U+00D4 &#212;
Ocirc => 212,
# Õ	латинская заглавная O с тильдой	&Otilde;	2.0	U+00D5 &#213;
Otilde => 213,
# Ö	латинская заглавная O с тремой	&Ouml;	2.0	U+00D6 &#214;
Ouml => 214,
# ×	знак умножения	&times;	3.2	U+00D7 &#215;
times => 215,
# Ø	латинская заглавная O диагонально перечёркнутая	&Oslash;	2.0	U+00D8 &#216;
Oslash => 216,
# Ù	латинская заглавная U с грависом	&Ugrave;	2.0	U+00D9 &#217;
Ugrave => 217,
# Ú	латинская заглавная U с акутом	&Uacute;	2.0	U+00DA &#218;
Uacute => 218,
# Û	латинская заглавная U с циркумфлексом	&Ucirc;	2.0	U+00DB &#219;
Ucirc => 219,
# Ü	латинская заглавная U с тремой	&Uuml;	2.0	U+00DC &#220;
Uuml => 220,
# Ý	латинская заглавная Y с акутом	&Yacute;	2.0	U+00DD &#221;
Yacute => 221,
# Þ	латинская заглавная буква Торн (THORN)	&THORN;	2.0	U+00DE &#222;
THORN => 222,
# ß	латинская строчная эсцет	&szlig;	2.0	U+00DF &#223;
szlig => 223,
# à	латинская строчная «a» с грависом	&agrave;	2.0	U+00E0 &#224;
agrave => 224,
# á	латинская строчная «a» с акутом	&aacute;	2.0	U+00E1 &#225;
aacute => 225,
# â	латинская строчная «a» с циркумфлексом	&acirc;	2.0	U+00E2 &#226;
acirc => 226,
# ã	латинская строчная «a» с тильдой	&atilde;	2.0	U+00E3 &#227;
atilde => 227,
# ä	латинская строчная «a» с тремой	&auml;	2.0	U+00E4 &#228;
auml => 228,
# å	латинская строчная «a» с кружком сверху	&aring;	2.0	U+00E5 &#229;
aring => 229,
# æ	латинская строчная лигатура «ae»	&aelig;	2.0	U+00E6 &#230;
aelig => 230,
# ç	латинская строчная «c» с седилью	&ccedil;	2.0	U+00E7 &#231;
ccedil => 231,
# è	латинская строчная «e» с грависом	&egrave;	2.0	U+00E8 &#232;
egrave => 232,
# é	латинская строчная «e» с акутом	&eacute;	2.0	U+00E9 &#233;
eacute => 233,
# ê	латинская строчная «e» с циркумфлексом	&ecirc;	2.0	U+00EA &#234;
ecirc => 234,
# ë	латинская строчная «e» с тремой	&euml;	2.0	U+00EB &#235;
euml => 235,
# ì	латинская строчная «i» с грависом	&igrave;	2.0	U+00EC &#236;
igrave => 236,
# í	латинская строчная «i» с акутом	&iacute;	2.0	U+00ED &#237;
iacute => 237,
# î	латинская строчная «i» с циркумфлексом	&icirc;	2.0	U+00EE &#238;
icirc => 238,
# ï	латинская строчная «i» с тремой	&iuml;	2.0	U+00EF &#239;
iuml => 239,
# ð	латинская строчная «eth»	&eth;	2.0	U+00F0 &#240;
eth => 240,
# ñ	латинская строчная «n» с тильдой	&ntilde;	2.0	U+00F1 &#241;
ntilde => 241,
# ò	латинская строчная «o» с грависом	&ograve;	2.0	U+00F2 &#242;
ograve => 242,
# ó	латинская строчная «o» с акутом	&oacute;	2.0	U+00F3 &#243;
oacute => 243,
# ô	латинская строчная «o» с циркумфлексом	&ocirc;	2.0	U+00F4 &#244;
ocirc => 244,
# õ	латинская строчная «o» с тильдой	&otilde;	2.0	U+00F5 &#245;
otilde => 245,
# ö	латинская строчная «o» с тремой	&ouml;	2.0	U+00F6 &#246;
ouml => 246,
# ÷	знак деления	&div;	5.0 (?)	U+00F7 &#247; &divide;	3.2
div => 247,
divide => 247,
# ø	латинская строчная «o» диагонально перечёркнутая	&oslash;	2.0	U+00F8 &#248;
oslash => 248,
# ù	латинская строчная «u» с грависом	&ugrave;	2.0	U+00F9 &#249;
ugrave => 249,
# ú	латинская строчная «u» с акутом	&uacute;	2.0	U+00FA &#250;
uacute => 250,
# û	латинская строчная «u» с циркумфлексом	&ucirc;	2.0	U+00FB &#251;
ucirc => 251,
# ü	латинская строчная «u» с тремой	&uuml;	2.0	U+00FC &#252;
uuml => 252,
# ý	латинская строчная «y» с акутом	&yacute;	2.0	U+00FD &#253;
yacute => 253,
# þ	латинская строчная «торн» (thorn)	&thorn;	2.0	U+00FE &#254;
thorn => 254,
# ÿ	латинская строчная «y» с тремой	&yuml;	2.0	U+00FF &#255;
yuml => 255,
#
#
# Расширение латиницы — A
# U+0100—U+017F
# Символ	Назначение	Мнемоника	HTML	Код
#
# Ā	латинская заглавная «A» с макроном	&Amacr;	5.0	U+0100 &#256;
Amacr => 256,
# ā	латинская строчная «a» с макроном	&amacr;	5.0	U+0101 &#257;
amacr => 257,
# Ă	латинская заглавная «A» с бреве	&Abreve;	5.0	U+0102 &#258;
Abreve => 258,
# ă	латинская строчная «a» с бреве	&abreve;	5.0	U+0103 &#259;
abreve => 259,
# Ą	латинская заглавная «A» с огонэком	&Aogon;	5.0	U+0104 &#260;
Aogon => 260,
# ą	латинская строчная «a» с огонэком	&aogon;	5.0	U+0105 &#261;
aogon => 261,
# Ć	латинская заглавная «C» с акутом	&Cacute;	5.0	U+0106 &#262;
Cacute => 262,
# ć	латинская строчная «c» с акутом	&cacute;	5.0	U+0107 &#263;
cacute => 263,
# Ĉ	латинская заглавная «C» с циркумфлексом	&Ccirc;	5.0	U+0108 &#264;
Ccirc => 264,
# ĉ	латинская строчная «c» с циркумфлексом	&ccirc;	5.0	U+0109 &#265;
ccirc => 265,
# Ċ	латинская заглавная «C» с точкой сверху	&Cdot;	5.0	U+010A &#266;
Cdot => 266,
# ċ	латинская строчная «c» с точкой сверху	&cdot;	5.0	U+010B &#267;
cdot => 267,
# Č	латинская заглавная «C» с птичкой	&Ccaron;	5.0	U+010C &#268;
Ccaron => 268,
# č	латинская строчная «c» с птичкой	&ccaron;	5.0	U+010D &#269;
ccaron => 269,
# Ď	латинская заглавная «D» с птичкой	&Dcaron;	5.0	U+010E &#270;
Dcaron => 270,
# ď	латинская строчная «d» с птичкой (в шрифтах предпочтителен вариант с апострофом)	&dcaron;	5.0	U+010F &#271;
dcaron => 271,
# Đ	латинская заглавная «D» с горизонтальным штрихом. На вид может не отличаться от Eth (Ð, U+00D0, &ETH;)	&Dstrok;	5.0	U+0110 &#272;
Dstrok => 272,
ETH => 272,
# đ	латинская строчная «d» с горизонтальным штрихом. На вид может не отличаться от eth (ð, U+00F0, &eth;)	&dstrok;	5.0	U+0111 &#273;
dstrok => 273,
eth => 273,
# Ē	латинская заглавная «E» с макроном	&Emacr;	5.0	U+0112 &#274;
Emacr => 274,
# ē	латинская строчная «e» с макроном	&emacr;	5.0	U+0113 &#275;
emacr => 275,
# Ĕ	латинская заглавная «E» с бреве			U+0114 &#276;
# ĕ	латинская строчная «e» с бреве			U+0115 &#277;
# Ė	латинская заглавная «E» с точкой сверху	&Edot;	5.0	U+0116 &#278;
Edot => 278,
# ė	латинская строчная «e» с точкой сверху	&edot;	5.0	U+0117 &#279;
edot => 279,
# Ę	латинская заглавная «E» с огонэком	&Eogon;	5.0	U+0118 &#280;
Eogon => 280,
# ę	латинская строчная «e» с огонэком	&eogon;	5.0	U+0119 &#281;
eogon => 281,
# Ě	латинская заглавная «E» с птичкой	&Ecaron;	5.0	U+011A &#282;
Ecaron => 282,
# ě	латинская строчная «e» с птичкой	&ecaron;	5.0	U+011B &#283;
ecaron => 283,
# Ĝ	латинская заглавная «G» с циркумфлексом	&Gcirc;	5.0	U+011C &#284;
Gcirc => 284,
# ĝ	латинская строчная «g» с циркумфлексом	&gcirc;	5.0	U+011D &#285;
gcirc => 285,
# Ğ	латинская заглавная «G» с бреве	&Gbreve;	5.0	U+011E &#286;
Gbreve => 286,
# ğ	латинская строчная «g» с бреве	&gbreve;	5.0	U+011F &#287;
gbreve => 287,
# Ġ	латинская заглавная «G» с точкой сверху	&Gdot;	5.0	U+0120 &#288;
Gdot => 288,
# ġ	латинская строчная «g» с точкой сверху	&gdot;	5.0	U+0121 &#289;
gdot => 289,
# Ģ	латинская заглавная «G» с цедилью	&Gcedil;	5.0	U+0122 &#290;
Gcedil => 290,
# ģ	латинская строчная «g» с цедилью			U+0123 &#291;
# Ĥ	латинская заглавная «H» с циркумфлексом	&Hcirc;	5.0	U+0124 &#292;
Hcirc => 292,
# ĥ	латинская строчная «h» с циркумфлексом	&hcirc;	5.0	U+0125 &#293;
hcirc => 293,
# Ħ	латинская заглавная «H» с горизонтальным штрихом	&Hstrok;	5.0	U+0126 &#294;
Hstrok => 294,
# ħ	латинская строчная «h» с горизонтальным штрихом	&hstrok;	5.0	U+0127 &#295;
hstrok => 295,
# Ĩ	латинская заглавная «I» с тильдой	&Itilde;	5.0	U+0128 &#296;
Itilde => 296,
# ĩ	латинская строчная «i» с тильдой	&itilde;	5.0	U+0129 &#297;
itilde => 297,
# Ī	латинская заглавная «I» с макроном	&Imacr;	5.0	U+012A &#298;
Imacr => 298,
# ī	латинская строчная «i» с макроном	&imacr;	5.0	U+012B &#299;
imacr => 299,
# Ĭ	латинская заглавная «I» с бреве			U+012C &#300;
# ĭ	латинская строчная «i» с бреве			U+012D &#301;
# Į	латинская заглавная «I» с огонэком	&Iogon;	5.0	U+012E &#302;
Iogon => 302,
# į	латинская строчная «i» с огонэком	&iogon;	5.0	U+012F &#303;
iogon => 303,
# İ	латинская заглавная «I» с точкой сверху	&Idot;	5.0	U+0130 &#304;
Idot => 304,
# ı	латинская строчная «i» без точки сверху	&imath;	5.0	U+0131 &#305; &inodot;
imath => 305,
inodot => 305,
# Ĳ	латинская заглавная лигатура «IJ»	&IJlig;	5.0	U+0132 &#306;
IJlig => 306,
# ĳ	латинская строчная лигатура «ij»	&ijlig;	5.0	U+0133 &#307;
ijlig => 307,
# Ĵ	латинская заглавная «J» с циркумфлексом	&Jcirc;	5.0	U+0134 &#308;
Jcirc => 308,
# ĵ	латинская строчная «j» с циркумфлексом	&jcirc;	5.0	U+0135 &#309;
jcirc => 309,
# Ķ	латинская заглавная «K» с цедилью	&Kcedil;	5.0	U+0136 &#310;
Kcedil => 310,
# ķ	латинская строчная «k» с цедилью	&kcedil;	5.0	U+0137 &#311;
kcedil => 311,
# ĸ	латинская строчная «kra» (гренландское «к»)	&kgreen;	5.0	U+0138 &#312;
kgreen => 312,
# Ĺ	латинская заглавная «L» с акутом	&Lacute;	5.0	U+0139 &#313;
Lacute => 313,
# ĺ	латинская строчная «l» с акутом	&lacute;	5.0	U+013A &#314;
lacute => 314,
# Ļ	латинская заглавная «L» с цедилью	&Lcedil;	5.0	U+013B &#315;
Lcedil => 315,
# ļ	латинская строчная «l» с цедилью	&lcedil;	5.0	U+013C &#316;
lcedil => 316,
# Ľ	латинская заглавная «L» с птичкой (в шрифтах предпочтителен вариант с апострофом)	&Lcaron;	5.0	U+013D &#317;
Lcaron => 317,
# ľ	латинская строчная «l» с птичкой (в шрифтах предпочтителен вариант с апострофом)	&lcaron;	5.0	U+013E &#318;
lcaron => 318,
# Ŀ	латинская заглавная «L» с точкой посередине	&Lmidot;	5.0	U+013F &#319;
Lmidot => 319,
# ŀ	латинская строчная «l» с точкой посередине	&lmidot;	5.0	U+0140 &#320;
lmidot => 320,
# Ł	латинская заглавная «L» с горизонтальным штрихом	&Lstrok;	5.0	U+0141 &#321;
Lstrok => 321,
# ł	латинская строчная «l» с горизонтальным штрихом	&lstrok;	5.0	U+0142 &#322;
lstrok => 322,
# Ń	латинская заглавная «N» с акутом	&Nacute;	5.0	U+0143 &#323;
Nacute => 323,
# ń	латинская строчная «n» с акутом	&nacute;	5.0	U+0144 &#324;
nacute => 324,
# Ņ	латинская заглавная «N» с цедилью	&Ncedil;	5.0	U+0145 &#325;
Ncedil => 325,
# ņ	латинская строчная «n» с цедилью	&ncedil;	5.0	U+0146 &#326;
ncedil => 326,
# Ň	латинская заглавная «N» с птичкой	&Ncaron;	5.0	U+0147 &#327;
Ncaron => 327,
# ň	латинская строчная «n» с птичкой	&ncaron;	5.0	U+0148 &#328;
ncaron => 328,
# ŉ	латинская строчная «n» предшествуемая апострофом	&napos;	5.0	U+0149 &#329;
napos => 329,
# Ŋ	латинская заглавная «ENG»	&ENG;	5.0	U+014A &#330;
ENG => 330,
# ŋ	латинская строчная «eng»	&eng;	5.0	U+014B &#331;
eng => 331,
# Ō	латинская заглавная «O» с макроном	&Omacr;	5.0	U+014C &#332;
Omacr => 332,
# ō	латинская строчная «o» с макроном	&omacr;	5.0	U+014D &#333;
omacr => 333,
# Ŏ	латинская заглавная «O» с бреве			U+014E &#334;
# ŏ	латинская строчная «o» с бреве			U+014F &#335;
# Ő	латинская заглавная «O» с двойным акутом	&Odblac;	5.0	U+0150 &#336;
Odblac => 336,
# ő	латинская строчная «o» с двойным акутом	&odblac;	5.0	U+0151 &#337;
odblac => 337,
# Œ	латинская заглавная лигатура «OE»	&OElig;	4.0	U+0152 &#338;
OElig => 338,
# œ	латинская строчная лигатура «oe»	&oelig;	4.0	U+0153 &#339;
oelig => 339,
# Ŕ	латинская заглавная «R» с акутом	&Racute;	5.0	U+0154 &#340;
Racute => 340,
# ŕ	латинская строчная «r» с акутом	&racute;	5.0	U+0155 &#341;
racute => 341,
# Ŗ	латинская заглавная «R» с цедилью	&Rcedil;	5.0	U+0156 &#342;
Rcedil => 342,
# ŗ	латинская строчная «r» с цедилью	&rcedil;	5.0	U+0157 &#343;
rcedil => 343,
# Ř	латинская заглавная «R» с птичкой	&Rcaron;	5.0	U+0158 &#344;
Rcaron => 344,
# ř	латинская строчная «r» с птичкой	&rcaron;	5.0	U+0159 &#345;
rcaron => 345,
# Ś	латинская заглавная «S» с акутом	&Sacute;	5.0	U+015A &#346;
Sacute => 346,
# ś	латинская строчная «s» с акутом	&sacute;	5.0	U+015B &#347;
sacute => 347,
# Ŝ	латинская заглавная «S» с циркумфлексом	&Scirc;	5.0	U+015C &#348;
Scirc => 348,
# ŝ	латинская строчная «s» с циркумфлексом	&scirc;	5.0	U+015D &#349;
scirc => 349,
# Ş	латинская заглавная «S» с цедилью	&Scedil;	5.0	U+015E &#350;
Scedil => 350,
# ş	латинская строчная «s» с цедилью	&scedil;	5.0	U+015F &#351;
scedil => 351,
# Š	латинская заглавная «S» с птичкой	&Scaron;	4.0	U+0160 &#352;
Scaron => 352,
# š	латинская строчная «s» с птичкой	&scaron;	4.0	U+0161 &#353;
scaron => 353,
# Ţ	латинская заглавная «T» с цедилью	&Tcedil;	5.0	U+0162 &#354;
Tcedil => 354,
# ţ	латинская строчная «t» с цедилью	&tcedil;	5.0	U+0163 &#355;
tcedil => 355,
# Ť	латинская заглавная «T» с птичкой	&Tcaron;	5.0	U+0164 &#356;
Tcaron => 356,
# ť	латинская строчная «t» с птичкой (в шрифтах предпочтителен вариант с апострофом)	&tcaron;	5.0	U+0165 &#357;
tcaron => 357,
# Ŧ	латинская заглавная «T» с горизонтальным штрихом	&Tstrok;	5.0	U+0166 &#358;
Tstrok => 358,
# ŧ	латинская строчная «t» с горизонтальным штрихом	&tstrok;	5.0	U+0167 &#359;
tstrok => 359,
# Ũ	латинская заглавная «U» с тильдой	&Utilde;	5.0	U+0168 &#360;
Utilde => 360,
# ũ	латинская строчная «u» с тильдой	&utilde;	5.0	U+0169 &#361;
utilde => 361,
# Ū	латинская заглавная «U» с макроном	&Umacr;	5.0	U+016A &#362;
Umacr => 362,
# ū	латинская строчная «u» с макроном	&umacr;	5.0	U+016B &#363;
umacr => 363,
# Ŭ	латинская заглавная «U» с бреве	&Ubreve;	5.0	U+016C &#364;
Ubreve => 364,
# ŭ	латинская строчная «u» с бреве	&ubreve;	5.0	U+016D &#365;
ubreve => 365,
# Ů	латинская заглавная «U» с кольцом сверху	&Uring;	5.0	U+016E &#366;
Uring => 366,
# ů	латинская строчная «u» с кольцом сверху	&uring;	5.0	U+016F &#367;
uring => 367,
# Ű	латинская заглавная «U» с двойным акутом	&Udblac;	5.0	U+0170 &#368;
Udblac => 368,
# ű	латинская строчная «u» с двойным акутом	&udblac;	5.0	U+0171 &#369;
udblac => 369,
# Ų	латинская заглавная «U» с огонэком	&Uogon;	5.0	U+0172 &#370;
Uogon => 370,
# ų	латинская строчная «u» с огонэком	&uogon;	5.0	U+0173 &#371;
uogon => 371,
# Ŵ	латинская заглавная «W» с циркумфлексом	&Wcirc;	5.0	U+0174 &#372;
Wcirc => 372,
# ŵ	латинская строчная «w» с циркумфлексом	&wcirc;	5.0	U+0175 &#373;
wcirc => 373,
# Ŷ	латинская заглавная «Y» с циркумфлексом	&Ycirc;	5.0	U+0176 &#374;
Ycirc => 374,
# ŷ	латинская строчная «y» с циркумфлексом	&ycirc;	5.0	U+0177 &#375;
ycirc => 375,
# Ÿ	латинская заглавная «Y» с тремой	&Yuml;	4.0	U+0178 &#376;
Yuml => 376,
# Ź	латинская заглавная «Z» с акутом	&Zacute;	5.0	U+0179 &#377;
Zacute => 377,
# ź	латинская строчная «z» с акутом	&zacute;	5.0	U+017A &#378;
zacute => 378,
# Ż	латинская заглавная «Z» с точкой сверху	&Zdot;	5.0	U+017B &#379;
Zdot => 379,
# ż	латинская строчная «z» с точкой сверху	&zdot;	5.0	U+017C &#380;
zdot => 380,
# Ž	латинская заглавная «Z» с птичкой	&Zcaron;	5.0	U+017D &#381;
Zcaron => 381,
# ž	латинская строчная «z» с птичкой	&zcaron;	5.0	U+017E &#382;
zcaron => 382,
# ſ	латинская строчная «долгая s»			U+017F &#383;
#
#
# Расширение латиницы — B
# U+0180—U+024F
# Символ	Назначение	Мнемоника	HTML	Код
#
# ƒ	• латинская строчная f с хвостиком снизу (иногда называется рукописной f, на самом деле прямая или курсив)
# • знак флорина
# • символ функции
# • это не регулярная курсивная латинская f (𝑓, U+1D453), хотя, в зависимости от шрифта, может выглядеть очень похоже	&fnof;	4.0	U+0192 &#402;
fnof => 402,
# Ƶ	латинская заглавная «Z» с горизонтальным штрихом	&imped;	5.0	U+01B5 &#437;
imped => 437,
# ǵ	латинская строчная «g» с акутом	&gacute;	5.0	U+01F5 &#501;
gacute => 501,
# ȷ	латинская строчная «j» без точки сверху	&jmath;	5.0	U+0237 &#567;
jmath => 567,
#
#
# Занимающие позицию модификаторы букв
# U+02B0—U+02FF
# Символ	Назначение	Мнемоника	HTML	Код
#
# ˆ	занимающий позицию акцент перевёрнутая птичка/circumflex accent	&circ;	4.0	U+02C6 &#710;
circ => 710,
# ˇ	занимающий позицию акцент птичка (гачек)	&caron;	5.0	U+02C7 &#711; &Hacek;
caron => 711,
Hacek => 711,
# ˘	занимающий позицию бреве	&breve;	5.0	U+02D8 &#728; &Breve;
Breve => 728,
breve => 728,
# ˙	занимающая позицию точка сверху	&dot;	5.0	U+02D9 &#729; &DiacriticalDot;
dot => 729,
DiacriticalDot => 729,
# ˚	занимающий позицию кружок сверху	&ring;	5.0	U+02DA &#730;
ring => 730,
# ˛	занимающий позицию огонэк	&ogon;	5.0	U+02DB &#731;
ogon => 731,
# ˜	занимающая позицию малая тильда	&DiacriticalTilde;	5.0	U+02DC &#732; &tilde;	4.0
DiacriticalTilde => 732,
tilde => 732,
# ˝	занимающий позицию двойной акут	&dblac;	5.0	U+02DD &#733; &DiacriticalDoubleAcute;
DiacriticalDoubleAcute => 733,
dblac => 733,
#
#
# Комбинируемые диакритические знаки
# U+0300—U+036F
# Символ	Назначение	Мнемоника	HTML	Код
#
#  ́	комбинируемый знак ударения (аку́т — ставится непосредственно после буквы, над которой должен изображаться)			U+0301 &#769;
#  ̑	комбинируемый перевёрнутый бре́вис (ставится непосредственно после буквы, над которой должен изображаться)	&DownBreve;	5.0	U+0311 &#785;
DownBreve => 785,
#
#
# Греческие и коптские символы
# U+0370 — U+03FF
# Включает Греческий алфавит.
#
# Символ	Назначение	Мнемоника	HTML	Код
#
# Α	греческая заглавная альфа	&Alpha;	4.0	U+0391 &#913;
Alpha => 913,
# Β	греческая заглавная бета	&Beta;	4.0	U+0392 &#914;
Beta => 914,
# Γ	греческая заглавная гамма	&Gamma;	4.0	U+0393 &#915;
Gamma => 915,
# Δ	греческая заглавная дельта	&Delta;	4.0	U+0394 &#916;
Delta => 916,
# Ε	греческая заглавная эпсилон	&Epsilon;	4.0	U+0395 &#917;
Epsilon => 917,
# Ζ	греческая заглавная дзета	&Zeta;	4.0	U+0396 &#918;
Zeta => 918,
# Η	греческая заглавная эта	&Eta;	4.0	U+0397 &#919;
Eta => 919,
# Θ	греческая заглавная тета	&Theta;	4.0	U+0398 &#920;
Theta => 920,
# Ι	греческая заглавная йота	&Iota;	4.0	U+0399 &#921;
Iota => 921,
# Κ	греческая заглавная каппа	&Kappa;	4.0	U+039A &#922;
Kappa => 922,
# Λ	греческая заглавная лямбда	&Lambda;	4.0	U+039B &#923;
Lambda => 923,
# Μ	греческая заглавная мю	&Mu;	4.0	U+039C &#924;
Mu => 924,
# Ν	греческая заглавная ню	&Nu;	4.0	U+039D &#925;
Nu => 925,
# Ξ	греческая заглавная кси	&Xi;	4.0	U+039E &#926;
Xi => 926,
# Ο	греческая заглавная омикрон	&Omicron;	4.0	U+039F &#927;
Omicron => 927,
# Π	греческая заглавная пи	&Pi;	4.0	U+03A0 &#928;
Pi => 928,
# Ρ	греческая заглавная ро	&Rho;	4.0	U+03A1 &#929;
Rho => 929,
# Σ	греческая заглавная сигма	&Sigma;	4.0	U+03A3 &#931;
Sigma => 931,
# Τ	греческая заглавная тау	&Tau;	4.0	U+03A4 &#932;
Tau => 932,
# Υ	греческая заглавная ипсилон	&Upsilon;	4.0	U+03A5 &#933;
Upsilon => 933,
# Φ	греческая заглавная фи	&Phi;	4.0	U+03A6 &#934;
Phi => 934,
# Χ	греческая заглавная хи	&Chi;	4.0	U+03A7 &#935;
Chi => 935,
# Ψ	греческая заглавная пси	&Psi;	4.0	U+03A8 &#936;
Psi => 936,
# Ω	• греческая заглавная омега
# • Ом (единица электрического сопротивления) — рекомендуется вместо ранее введённого специального символа «Ом» U+2126 (Ω, &#8486;)	&ohm;	5.0	U+03A9 &#937; &Omega;	4.0
ohm => 937,
Omega => 937,
# α	греческая строчная альфа	&alpha;	4.0	U+03B1 &#945;
alpha => 945,
# β	греческая строчная бета	&beta;	4.0	U+03B2 &#946;
beta => 946,
# γ	греческая строчная гамма	&gamma;	4.0	U+03B3 &#947;
gamma => 947,
# δ	греческая строчная дельта	&delta;	4.0	U+03B4 &#948;
delta => 948,
# ε	греческая строчная эпсилон	&epsi;	5.0	U+03B5 &#949; &epsilon;	4.0
epsi => 949,
epsilon => 949,
# ζ	греческая строчная дзета	&zeta;	4.0	U+03B6 &#950;
zeta => 950,
# η	греческая строчная эта	&eta;	4.0	U+03B7 &#951;
eta => 951,
# θ	греческая строчная тета	&theta;	4.0	U+03B8 &#952;
theta => 952,
# ι	греческая строчная йота	&iota;	4.0	U+03B9 &#953;
iota => 953,
# κ	греческая строчная каппа	&kappa;	4.0	U+03BA &#954;
kappa => 954,
# λ	греческая строчная лямбда	&lambda;	4.0	U+03BB &#955;
lambda => 955,
# μ	греческая строчная мю	&mu;	4.0	U+03BC &#956;
mu => 956,
# ν	греческая строчная ню	&nu;	4.0	U+03BD &#957;
nu => 957,
# ξ	греческая строчная кси	&xi;	4.0	U+03BE &#958;
xi => 958,
# ο	греческая строчная омикрон	&omicron;	4.0	U+03BF &#959;
omicron => 959,
# π	греческая строчная пи	&pi;	4.0	U+03C0 &#960;
pi => 960,
# ρ	греческая строчная ро	&rho;	4.0	U+03C1 &#961;
rho => 961,
# ς	греческая строчная сигма конечная	&sigmav;	5.0	U+03C2 &#962; &varsigma;	5.0 &sigmaf;	4.0
sigmav => 962,
varsigma => 962,
sigmaf => 962,
# σ	греческая строчная сигма	&sigma;	4.0	U+03C3 &#963;
sigma => 963,
# τ	греческая строчная тау	&tau;	4.0	U+03C4 &#964;
tau => 964,
# υ	греческая строчная ипсилон	&upsi;	5.0	U+03C5 &#965; &upsilon;	4.0
upsi => 965,
upsilon => 965,
# φ	греческая строчная фи	&phi;	4.0	U+03C6 &#966;
phi => 966,
# χ	греческая строчная хи	&chi;	4.0	U+03C7 &#967;
chi => 967,
# ψ	греческая строчная пси	&psi;	4.0	U+03C8 &#968;
psi => 968,
# ω	греческая строчная омега	&omega;	4.0	U+03C9 &#969;
omega => 969,
# ϑ	греческая символьная тета	&thetav;	5.0	U+03D1 &#977; &vartheta;	5.0 &thetasym;	4.0
thetav => 977,
vartheta => 977,
thetasym => 977,
# ϒ	греческий ипсилон с хвостиком	&Upsi;	5.0	U+03D2 &#978; &upsih;	4.0
Upsi => 978,
upsih => 978,
# ϕ	греческая символьная фи	&straightphi;	5.0	U+03D5 &#981; &varphi;	5.0 &phiv;	5.0
straightphi => 981,
varphi => 981,
phiv => 981,
# ϖ	греческая символьная пи	&varpi;	5.0	U+03D6 &#982; &piv;	4.0
varpi => 982,
piv => 982,
# Ϝ	греческая заглавная дигамма	&Gammad;	5.0	U+03DC &#988;
Gammad => 988,
# ϝ	греческая строчная дигамма	&gammad;	5.0	U+03DD &#989; &digamma;	5.0
gammad => 989,
digamma => 989,
# ϰ	греческая символьная каппа	&varkappa;	5.0	U+03F0 &#1008; &kappav;	5.0
varkappa => 1008,
kappav => 1008,
# ϱ	греческая символьная ро	&varrho;	5.0	U+03F1 &#1009; &rhov;	5.0
varrho => 1009,
rhov => 1009,
# ϵ	греческая символьный эпсилон (прямой эпсилон, лунный эпсилон)	&straightepsilon;	5.0	U+03F5 &#1013; &varepsilon;	5.0 &epsiv;	5.0
straightepsilon => 1013,
varepsilon => 1013,
epsiv => 1013,
# ϶	греческая обратный эпсилон (обращённый лунный эпсилон)	&backepsilon;	5.0	U+03F6 &#1014; &bepsi;	5.0
backepsilon => 1014,
bepsi => 1014,
#
#
# Общая пунктуация
# Символ	Назначение	Мнемоника	Код
#
#  	пробел длины N (длинный пробел, примерно с короткое тире)	&ensp;	&#8194;
ensp => 8194,
#  	пробел длины M (очень длинный пробел, примерно с длинное тире)	&emsp;	&#8195;
emsp => 8195,
#  	узкий пробел	&thinsp;	&#8201;
thinsp => 8201,
# ‌‌	zero width non-joiner — запрет склейки (лигатуры) соседних символов	&zwnj;	&#8204;
zwnj => 8204,
# ‍‍	zero width joiner — запрос на склейку (лигатуру) соседних символов	&zwj;	&#8205;
zwj => 8205,
# ‎	left-to-right mark — признак начала текста, читаемого слева­‑направо	&lrm;	&#8206;
lrm => 8206,
# ‏	right-to-left mark — признак начала текста, читаемого справа­‑налево	&rlm;	&#8207;
rlm => 8207,
# ‑	неразрывный (неразделяемый) дефис / non-breaking hyphen	 	&#8209;
# –	короткое тире (тире длины N)	&ndash;	&#8211;
ndash => 8211,
# —	длинное тире (тире длины M)	&mdash;	&#8212;
mdash => 8212,
# ‘	одинарная кавычка типа «верхняя перевёрнутая девятка»	&lsquo;	&#8216;
lsquo => 8216,
# ’	одинарная кавычка типа «верхняя девятка»	&rsquo;	&#8217;
rsquo => 8217,
# ‚	одинарная кавычка типа «нижняя девятка»	&sbquo;	&#8218;
sbquo => 8218,
# ‛	одинарная кавычка типа «верхняя обращённая девятка»		&#8219;
# “	двойная кавычка типа «верхняя перевёрнутая девятка»	&ldquo;	&#8220;
ldquo => 8220,
# ”	двойная кавычка типа «верхняя девятка»	&rdquo;	&#8221;
rdquo => 8221,
# „	двойная кавычка типа «нижняя девятка»	&bdquo;	&#8222;
bdquo => 8222,
# ‟	двойная кавычка типа «верхняя обращённая девятка»		&#8223;
# †	типографский крестик	&dagger;	&#8224;
dagger => 8224,
# ‡	двойной типографский крестик	&Dagger;	&#8225;
Dagger => 8225,
# •	маркер списка (буллит)	&bull;	&#8226;
bull => 8226,
# …	горизонтальное многоточие	&hellip;	&#8230;
hellip => 8230,
# ‰	проми́лле	&permil;	&#8240;
permil => 8240,
# ′	штрих	&prime;	&#8242;
prime => 8242,
# ″	двойной штрих	&Prime;	&#8243;
Prime => 8243,
# ‹	направленная влево одинарная угловая кавычка (предложена, но ещё не стандартизирована ISO, практически всюду есть)	&lsaquo;	&#8249;
lsaquo => 8249,
# ›	направленная вправо одинарная угловая кавычка (предложена, но ещё не стандартизирована ISO, практически всюду есть)	&rsaquo;	&#8250;
rsaquo => 8250,
# ‾	занимающее позицию надчёркивание	&oline;	&#8254;
oline => 8254,
#  ⁄ 	комбинируемый символ «дробь-черта» (1&frasl;2 → ½, 3&frasl;4 → ¾, 12&frasl;23 → 12⁄23, при необходимости последовательность цифр ограничивается пробелом нулевой длины (&#8203;) или неразрывным пробелом нулевой длины (&#8288;): 12&#8203;34&frasl;56 → 12​34⁄56, 2&#8288;99&frasl;100 → 2⁠99⁄100)	&frasl;	&#8260;
frasl => 8260,
#
#
# Знаки валют
# Символ	Назначение	Мнемоника	Код
#
# €	евро	&euro;	&#8364;
euro => 8364,
# ₽	рубль		&#8381;
#
#
# Буквоподобные символы
# Символ	Назначение	Мнемоника	Код
#
# ℑ	готическая заглавная I (регулярная латинская готическая буква) = мнимая часть	&image;	&#8465;
image => 8465,
# №	Знак номера	&numero; (HTML 5.0)	&#8470;
numero => 8470,
# ℘	эллиптическая функция Вейерштрасса или множество всех подмножеств. Отдельный символ, >не рукописная заглавная P (𝒫, &#119979;)	&weierp;	&#8472;
weierp => 8472,
# ℜ	готическая заглавная R (регулярная латинская готическая буква) = вещественная часть	&real;	&#8476;
real => 8476,
# ™	товарный знак	&TRADE; — есть не всюду &trade;	&#8482;
TRADE => 8482,
trade => 8482,
# ℵ	математическая буква Алеф = бесконечный кардинал — в отличие от еврейской буквы Алеф (‎א‎, &#1488;) читается слева направо	&alefsym;	&#8501;
alefsym => 8501,
#
#
# Формы чисел
# Символ	Назначение	Мнемоника	Код
#
# ⅓	простая дробь «одна треть»	&frac13; (HTML 5.0)	&#8531;
frac13 => 8531,
#
#
# Стрелки
# Символ	Назначение	Мнемоника	Код
#
# ←	влево	&larr;	&#8592;
larr => 8592,
# ↑	вверх	&uarr;	&#8593;
uarr => 8593,
# →	вправо	&rarr;	&#8594;
rarr => 8594,
# ↓	вниз	&darr;	&#8595;
darr => 8595,
# ↔	влево-вправо	&harr;	&#8596;
harr => 8596,
# ↵	вниз с углом вправо = возврат каретки	&crarr;	&#8629;
crarr => 8629,
# ⇐	двойная стрелка влево	&lArr;	&#8656;
lArr => 8656,
# ⇑	двойная вверх	&uArr;	&#8657;
uArr => 8657,
# ⇒	двойная вправо	&rArr;	&#8658;
rArr => 8658,
# ⇓	двойная вниз	&dArr;	&#8659;
dArr => 8659,
# ⇔	двойная влево-вправо	&hArr;	&#8660;
hArr => 8660,
# ◄	влево		&#9668;
# ▲	вверх		&#9650;
# ►	вправо		&#9658;
# ▼	вниз		&#9660;
#
#
# Математические операции
# Символ	Назначение	Мнемоника	Код
#
# ∀	квантор всеобщности (для всех…)	&forall;	&#8704;
forall => 8704,
# ∂	частная производная	&part;	&#8706;
part => 8706,
# ∃	квантор существования (существует…)	&exist;	&#8707;
exist => 8707,
# ∅	пустое множество (диаметр)	&empty;	&#8709;
empty => 8709,
# ∇	набла	&nabla;	&#8711;
nabla => 8711,
# ∈	принадлежит	&isin;	&#8712;
isin => 8712,
# ∉	не принадлежит	&notin;	&#8713;
notin => 8713,
# ∋	содержит	&ni;	&#8715;
ni => 8715,
# ∏	произведение по множеству	&prod;	&#8719;
prod => 8719,
# ∑	сумма по множеству	&sum;	&#8721;
sum => 8721,
# −	минус — не чёрточка-минус из ASCII, имеет те же размеры и такое же расположение горизонтального штриха, что и «+»	&minus;	&#8722;
minus => 8722,
# ∕	деление (не косая черта из ASCII)		&#8725;
# ∖	разность множеств (не обратная косая черта из ASCII)	&setmn; (HTML 5.0)
setmn => 34598,
# &setminus; (HTML 5.0)
setminus => 34598,
# &Backslash; (HTML 5.0)
Backslash => 8726,
# &ssetmn; (HTML 5.0)
ssetmn => 8726,
# &smallsetminus; (HTML 5.0)	&#8726;
smallsetminus => 8726,
# ∗	звёздочка (гарантированно не приподнятая над строкой)	&lowast;	&#8727;
lowast => 8727,
# √	квадратный корень = знак радикала	&radic;	&#8730;
radic => 8730,
# ∝	пропорционально к	&prop;	&#8733;
prop => 8733,
# ∞	бесконечность	&infin;	&#8734;
infin => 8734,
# ∠	угол	&ang;	&#8736;
ang => 8736,
# ∧	конъюнкция (логическое И) = wedge	&and;	&#8743;
and => 8743,
# ∨	дизъюнкция (логическое ИЛИ) = vee	&or;	&#8744;
or => 8744,
# ∩	пересечение = cap	&cap;	&#8745;
cap => 8745,
# ∪	объединение = cup	&cup;	&#8746;
cup => 8746,
# ∫	интеграл	&int;	&#8747;
int => 8747,
# ∴	следовательно, тем самым = therefore	&there4;	&#8756;
there4 => 8756,
# ∼	эквивалентно (для бесконечно малых/больших) = similar to	&sim;	&#8764;
sim => 8764,
# ≅	конгруэнтно = is approximately equal (congruent) to	&cong;	&#8773;
cong => 8773,
# ≈	примерно равно = is almost equal (asymptotic) to	&asymp;	&#8776;
asymp => 8776,
# ≠	не равно = is not equal to	&ne;	&#8800;
ne => 8800,
# ≡	тождественно равно, логически эквивалентно = is equivalent to	&equiv;	&#8801;
equiv => 8801,
# ≤	меньше или равно = is less or equal to	&le;	&#8804;
le => 8804,
# ≥	больше или равно = is greater or equal to	&ge;	&#8805;
ge => 8805,
# ⊂	подмножество = is subset of	&sub;	&#8834;
sub => 8834,
# ⊃	включает в себя = is superset of	&sup;	&#8835;
sup => 8835,
# ⊄	не является подмножеством = is not subset of	&nsub;	&#8836;
nsub => 8836,
# ⊆	подмножество или эквивалентно = is subset of or equivalent to	&sube;	&#8838;
sube => 8838,
# ⊇	включает в себя или эквивалентно = is superset of or equivalent to	&supe;	&#8839;
supe => 8839,
# ⊕	плюс в круге = прямая сумма	&oplus;	&#8853;
oplus => 8853,
# ⊗	умножение [косым] крестом в круге = тензорное произведение	&otimes;	&#8855;
otimes => 8855,
# ⊥	up tack = ортогонально к = перпендикулярно	&perp;	&#8869;
perp => 8869,
# ⋅	умножение точкой = скалярное произведение	&sdot;	&#8901;
sdot => 8901,
#
#
# Технические символы
# Символ	Назначение	Мнемоника	Код
#
# ⌈	левая скобка округления вверх = apl upstile	&lceil;	&#8968;
lceil => 8968,
# ⌉	правая скобка округления вверх	&rceil;	&#8969;
rceil => 8969,
# ⌊	левая скобка округления вниз = apl downstile	&lfloor;	&#8970;
lfloor => 8970,
# ⌋	правая скобка округления вниз	&rfloor;	&#8971;
rfloor => 8971,
# ⟨	угловая скобка влево = бра	&lang;	&#9001;
lang => 9001,
# ⟩	угловая скобка вправо = кет	&rang;	&#9002;
rang => 9002,
#
#
# Геометрические фигуры
# Символ	Назначение	Мнемоника	Код
#
# ◊	ромб	&loz;	&#9674;
loz => 9674,
#
#
# Различные символы
# Символ	Назначение	Мнемоника	Код
#
# ♠	«пики» (карточная масть)	&spades;	&#9824;
spades => 9824,
# ♣	«трефы» (карточная масть)	&clubs;	&#9827;
clubs => 9827,
# ♥	«червы» (карточная масть)	&hearts;	&#9829;
hearts => 9829,
# ♦	«бубны» (карточная масть)	&diams;	&#9830;
diams => 9830,
);

sub _set(@) { +{ map { $_ => 1 } @_ } }

# Теги не имеющие закрывающего тега
our %SINGLE_TAG = %{ _set qw/area base br col embed hr img input link meta param source track wbr/ };

# <li> закрывается, если приходит </ol> или </ul>
our %TOP_CLOSE_TAG = (
	li 			=> _set(qw/ol ul/),
	caption 	=> _set(qw/table/),
	thead 		=> _set(qw/table/),
	tbody 		=> _set(qw/table/),
	tfoot 		=> _set(qw/table/),
	tr 			=> _set(qw/table thead tbody tfoot caption/),
	td 			=> _set(qw/table thead tbody tfoot caption/),
	th 			=> _set(qw/table thead tbody tfoot caption/),
	dt			=> _set(qw/dl/),
	dd			=> _set(qw/dl/),
	rt			=> _set(qw/ruby/),
	rp			=> _set(qw/ruby/),
	option 		=> _set(qw/optgroup select/),
	optgroup	=> _set(qw/select/),
);

# <tr> закрывает открытые <td> и <th> и <tr>
our %TOP_NEW_TAG = (
	head		=> _set(qw/body/),
	tr			=> _set(qw/tr thead tbody tfoot/),
	td			=> _set(qw/tr thead tbody tfoot td th/),
	th			=> _set(qw/tr thead tbody tfoot td th/),
	col			=> _set(qw/tr thead tbody tfoot td th colgroup/),
	colgroup	=> _set(qw/thead tbody tfoot caption colgroup/),
	caption		=> _set(qw/thead tbody tfoot caption/),
	thead		=> _set(qw/thead tbody tfoot caption/),
	tbody		=> _set(qw/thead tbody tfoot caption/),
	tfoot		=> _set(qw/thead tbody tfoot caption/),
	li			=> _set(qw/li/),
	dt			=> _set(qw/dt dd/),
	dd			=> _set(qw/dt dd/),
	rt			=> _set(qw/rt rp/),
	rp			=> _set(qw/rt rp/),
	option		=> _set(qw/option optgroup/),
	optgroup	=> _set(qw/optgroup/),
);

# Проверяет, что тег – одиночный
sub is_single_tag(;$) {
	exists $SINGLE_TAG{$_[0] // $_}
}

# Забрасывает тег в стек и возвращает закрытые
sub in_tag(\@$$) {
	my ($S, $tag, $atag) = @_;

	# Выбрасываем из стека предыдущий тег
	my @ret;
	push @ret, pop @$S while @$S and
		($TOP_NEW_TAG{ $S->[$#$S][0] })->{$tag};

	push @$S, [$tag, $atag] unless exists $SINGLE_TAG{$tag};

	@ret
}

# Выбрасывает тег из стека. Возвращает выдавленные им и выбрасывает исключение, если такого в стеке нет
sub out_tag(\@$) {
	my ($S, $tag) = @_;

	# Это одиночный тег - он не может быть закрывающим
	die "</$tag> is a single tag - it cannot be a closing tag" if exists $SINGLE_TAG{$tag};

	# закрываем предыдущий, если нужно
	my @ret;
	push @ret, pop @$S while @$S and
		($TOP_CLOSE_TAG{$S->[$#$S][0]})->{$tag};

	die "</$tag>, but stack is empty!" unless @$S;

	# тег равен закрывающему
	die "<$S->[$#$S][0]> in stack ne </$tag>!" if $S->[$#$S][0] ne $tag;

	push @ret, pop @$S;

	@ret
}


# Разбивает текст на страницы с учётом html-тегов
#
# 1. html-тег должен быть так же разнесён на страницы.
#
sub split_on_pages(@) {
	my ($html, $symbols_on_page, $by) = @_;

	# На какое расстояние страница может быть больше
	$by //= $symbols_on_page / 3 < 1000 ? int($symbols_on_page / 3): 1000;
	my $max = $symbols_on_page + $by;

	my @pages;		# массив страниц
	my @page;		# массив элементов текста и тегов текущей страницы
	my $c = 0;		# количество символов в текущей странице
	my $i_page = 0;	# индекс элемента @page который привысил размер страницы
	my $c_page = 0;	# количество символов @page по $i_page
	my $is_proposal = 0;			# В конце текущей страницы обнаружен конец предложения
	my $re_proposal = qr/[.?!…]/;
	my @S;			# массив открывающих тегов [tag, '<tag ...>']

	# Функция фиксирует страницу и сбрасывает счётчики
	my $make_page = sub {
		push @pages, join "", @page, map { "</$_->[0]>" } reverse @S;
		$i_page = $c = $is_proposal = 0;
		@page = map $_->[1], @S;
	};
	
	for(grep length, split m{(
		<[a-z] [^<>]* >
		| </ \s* [a-z]\w* \s* >
		| &(?: [a-z]\w* | \# \d+ | \#x[0-9a-f]+ ) ;?
		| \n 		# Абзац
		| $re_proposal+	# Предложение
		| \b		# Слово
	)}xiu, $html) {

		if(/^&/) {$c++} 	# html-символ
		elsif(/^<\/\s*([a-z]\w*)/) { # закрывающий тег
			my $tag = lc $1;
			eval { out_tag @S, $tag };
			next if $@;
			# </p> превращаем в <p></p>
			$_ = "<p></p>" if $tag eq "p";
		}
		elsif(/^<([a-z]\w*)/) { in_tag @S, lc $1, $_ }	# тег
		else {$c += length}	# текст

		push @page, $_; # накапливаем символы в массиве @page

		next if $c < $symbols_on_page;	# страницу не набрали - тогда на next

		$c_page = $c, $i_page = @page if !$i_page;

		# Просматриваем вперёд пока не найдём границу или не достигнем ограничения
		if(/^\n/) { $make_page->() } 	# Абзац
		elsif(!$is_proposal && /^$re_proposal/) { $i_page = @page; $c_page = $c; $is_proposal = 1 }
		elsif($c >= $max) {
			# Если следующий за предложением или словом элемент - пробелы, то добавляем их к странице
			$c_page -= length $page[$i_page++] if $page[$i_page] =~ /^\s/;
			my @x = splice @page, $i_page;
			$make_page->();
			push @page, @x;
			$c -= $c_page;
		}
	}

	$make_page->() if @page;

	# Если размер последней страницы меньше чем 2/3, то добавляем её к предпоследней
	$pages[$#pages - 1] .= pop @pages if @pages > 1 and length($pages[$#pages]) < $symbols_on_page * 2 / 3;

	#my $len = 0; $len += length for @pages;
	#die "Суммарный размер страниц не изменился: " . length($html) . " == $len pages=" . @pages . " ->\n\n$html" if $len == length $html;

	my ($end1) = $html =~ m!([^<>\s]{1,13})\s*(</?\w[^<>]*>\s*)*$!a;
	my ($end2) = $pages[$#pages] =~ m!([^<>\s]{1,13})\s*(</?\w[^<>]*>\s*)*$!a;
	die "Концы текста и последней страницы не сходятся! `$end1` <> `$end2`" if $end1 ne $end2;

	return @pages;
}

our %TAG2SPACE = (
	"br" => "\n",
	"dd" => "\n  ",
	"table" => "\n",
	"tr" => "\n| ",
	"td" => "\t| ",
	"th" => "\t| ",
	"ol" => "\n",
	"ul" => "\n",
	"li" => "\n* ",
	"img" => " ",
	"p" => "\n",
	"div" => "\n",
);

our %CLOSE_TAG2SPACE = (
	"div" => "\n",
	"p" => "\n",
	"table" => "\n",
	"ol" => "\n",
	"ul" => "\n",
);

our %WITH_CLOSE_TAG2SPACE = (
	"p" => "\n",
	"br" => "\n",
	"img" => " ",
);


# переводит html в text
sub from_html (;$) {
	local ($_) = @_? @_: $_;

	# 1. Убираем энтитиес:
	my $ent = sub {
		exists $+{word}? (exists $ENTITIES{$+{word}}? chr $ENTITIES{$+{word}}: $&):
		exists $+{num}? chr $+{num}:
		exists $+{hex}? chr hex $+{hex}: ""
	};
	s{&(
		(?<word>\w+)
		|\#(?<num>\d+)
		|\#x(?<hex>[a-f\d]+)
	);?
	}{$ent->()}genix;

	my $pre;

	my $to = sub {
		my $s1 = $pre? $+{s1}: ($+{s1} eq ""? "": " ");
		
		my $x =
		exists $+{space}? ($pre? $+{space}: " "):
		exists $+{nbsp}? " ":
		exists $+{xhr}? $+{xhr}:
		exists $+{tag}? do {
			my $tag = lc $+{tag};
			$pre = 1 if $tag eq "pre";
			exists $+{close}? $WITH_CLOSE_TAG2SPACE{$tag}: $TAG2SPACE{$tag} 
		}:
		exists $+{ctag}? do {
			my $tag = lc $+{ctag};
			$pre = 0 if $tag eq "pre";
			
			$CLOSE_TAG2SPACE{$tag}
		}:
		"";
		
		my $s2 = $pre? $+{s2}: ($+{s2} eq "" || $s1? "": " ");
		
		$x =~ /\n/ ? $x: join "", $s1, $x, $s2
	};

	s{
		(?<s1> \s*) (
		
			  <(script|style|template)\b [^<>]*> .*? </ \g1 \s* >
			| <xhr \b [^<>]*> (?<xhr> .*? ) </xhr \s* >
			| < (?<tag> [a-z]\w* ) [^<>]*? (?<close> / )? \s*>
			| </ (?<ctag> [a-z]\w* ) \s*>
			| <!--.*?-->
		
		) (?<s2> \s*)
		| (?<space> [\ \t\n\r\f]+)
		| (?<nbsp> \xa0)
	}{$to->()}genisx;

	$_
}

# Все, кроме запрещённых:
#  applet, script, style, embed, object, param,
#  video, audio, source, track, frame, frameset, iframe, comment
#  html, head, body, title, meta, base, basefont, bgsound, link
#  form, keygen, output, textarea, select, option, optgroup, legend, label, input
#  plaintext, xmp
# А так же удаляет атрибуты начинающиеся на "on", name, for, formaction и др..
my %SAFE_TAG = map {$_=>1} qw/
a
abbr
acronym
address

area
article
aside

b
bdi
bdo

blockquote
big

blink
br
button

canvas
caption
center
cite
code
col
colgroup
command

datalist
dd
del
details
dfn
dir
div
dl
dt

em

figcaption
figure
font
footer

h1
h2
h3
h4
h5
h6
header
hgroup
hr

i
img

ins
isindex

kbd
keygen

li

main
map
marquee
mark
menu

meter

nav
nobr
noembed
noframes
noscript

ol

p
pre
progress

q

rp
rt
ruby

s
samp
section
small
span
strike
strong
   sub
summary
sup

table
tbody
td
tfoot
th
thead
time

tr
tt

u
ul

var

wbr
/;

my %SAFE_ATTR = map {$_=>1} qw/
pubdate datetime
open optimum

dir lang language style tabindex title high low hreflang icon

max min

href media ping rel rev name type

class

src

alt crossorigin decoding height width importance  intrinsicsize loading sizes srcset

align border hspace vspace longdesc  axis  char charoff summary

colspan rowspan

border cite bgcolor color

coords
/;

# срезает у html-я опасные, а так же неведомые теги
sub safe_html($;$) {
	(local $_, my $link) = @_;

	my $f = sub {
		return "" if !exists $SAFE_TAG{lc $2};
		return "</$2>" if $1 ne "";
		my $tag = $2;
		my $x = $3;
		my @attrs;
		while($x =~ /
			\b (?<attr> [a-z][a-z\d]*) ( \s*=\s* ( (?<quot> ") (?<val> [^"]*)" | (?<quot> ') (?<val> [^']*)' | (?<val> \S*) ) )?
		/gixn) {
			push @attrs, $+{val} eq ""? " $+{attr}"
				: join "", " ", $+{attr}, "=", $+{quot},
					lc $+{attr} ~~ [qw/src href/]
						? Aion::Format::Url::normalize_url($+{val}, $link)
						: $+{val},
					$+{quot}
				if exists $SAFE_ATTR{lc $+{attr}};
		}

		push @attrs, " target=_blank" if lc $tag eq "a";

		"<$tag@attrs>"
	};

	s{<(/\s*)?([a-z][a-z\d:-]*)([^<>]*)>|<!--(?:.*?)-->}{ $f->() }igse;

	$_
}

1;

__END__

=encoding utf-8

=head1 NAME

Aion::Format::Html - library for HTML formatting

=head1 SYNOPSIS

	use Aion::Format::Html;
	
	from_html "<b>&excl;</b>" # => !
	to_html "<a>"             # => &lt;a&gt;

=head1 DESCRIPION

Library for formatting HTML documents.

=head1 SUBROUTINES

=head2 from_html ($html)

Converts HTML to text.

	from_html "Basic is <b>superlanguage</b>!<br>"  # => Basic is superlanguage!\n

=head2 to_html ($html)

Escapes HTML characters.

=head2 safe_html ($html)

Trims dangerous and unknown HTML tags, as well as unknown attributes from known tags.

	safe_html "-<em>-</em><br>-" # => -<em>-</em><br>-
	safe_html "-<em onclick='  '>-</em><br onmouseout=1>-" # => -<em>-</em><br>-
	safe_html "-<xx24>-</xx24>" # => --
	safe_html "-< applet >-</ applet >" # => -< applet >-

=head2 split_on_pages ($html, $symbols_on_page, $by)

Breaks text into pages taking into account html tags.

	[split_on_pages "Alice in wonderland. This is book", 17]  # --> ["Alice in wonderland. ", "This is book"]

=head1 AUTHOR

Yaroslav O. Kosmina L<mailto:darviarush@mail.ru>

=head1 LICENSE

⚖ B<GPLv3>

=head1 COPYRIGHT

The Aion::Format::Html module is copyright © 2023 Yaroslav O. Kosmina. Rusland. All rights reserved.
