# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _convert_request, _format_url_section

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_cancel_synchronization_request(
    resource_group_name: str, account_name: str, share_subscription_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-09-01"))  # type: Literal["2020-09-01"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/cancelSynchronization",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "accountName": _SERIALIZER.url("account_name", account_name, "str"),
        "shareSubscriptionName": _SERIALIZER.url("share_subscription_name", share_subscription_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_source_share_synchronization_settings_request(
    resource_group_name: str,
    account_name: str,
    share_subscription_name: str,
    subscription_id: str,
    *,
    skip_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-09-01"))  # type: Literal["2020-09-01"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSourceShareSynchronizationSettings",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "accountName": _SERIALIZER.url("account_name", account_name, "str"),
        "shareSubscriptionName": _SERIALIZER.url("share_subscription_name", share_subscription_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skipToken"] = _SERIALIZER.query("skip_token", skip_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_synchronization_details_request(
    resource_group_name: str,
    account_name: str,
    share_subscription_name: str,
    subscription_id: str,
    *,
    skip_token: Optional[str] = None,
    filter: Optional[str] = None,
    orderby: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-09-01"))  # type: Literal["2020-09-01"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSynchronizationDetails",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "accountName": _SERIALIZER.url("account_name", account_name, "str"),
        "shareSubscriptionName": _SERIALIZER.url("share_subscription_name", share_subscription_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skipToken"] = _SERIALIZER.query("skip_token", skip_token, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if orderby is not None:
        _params["$orderby"] = _SERIALIZER.query("orderby", orderby, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_synchronizations_request(
    resource_group_name: str,
    account_name: str,
    share_subscription_name: str,
    subscription_id: str,
    *,
    skip_token: Optional[str] = None,
    filter: Optional[str] = None,
    orderby: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-09-01"))  # type: Literal["2020-09-01"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSynchronizations",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "accountName": _SERIALIZER.url("account_name", account_name, "str"),
        "shareSubscriptionName": _SERIALIZER.url("share_subscription_name", share_subscription_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skipToken"] = _SERIALIZER.query("skip_token", skip_token, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if orderby is not None:
        _params["$orderby"] = _SERIALIZER.query("orderby", orderby, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_synchronize_request(
    resource_group_name: str, account_name: str, share_subscription_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-09-01"))  # type: Literal["2020-09-01"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/synchronize",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "accountName": _SERIALIZER.url("account_name", account_name, "str"),
        "shareSubscriptionName": _SERIALIZER.url("share_subscription_name", share_subscription_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(
    resource_group_name: str, account_name: str, share_subscription_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-09-01"))  # type: Literal["2020-09-01"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "accountName": _SERIALIZER.url("account_name", account_name, "str"),
        "shareSubscriptionName": _SERIALIZER.url("share_subscription_name", share_subscription_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_request(
    resource_group_name: str, account_name: str, share_subscription_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-09-01"))  # type: Literal["2020-09-01"]
    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "accountName": _SERIALIZER.url("account_name", account_name, "str"),
        "shareSubscriptionName": _SERIALIZER.url("share_subscription_name", share_subscription_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(
    resource_group_name: str, account_name: str, share_subscription_name: str, subscription_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-09-01"))  # type: Literal["2020-09-01"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "accountName": _SERIALIZER.url("account_name", account_name, "str"),
        "shareSubscriptionName": _SERIALIZER.url("share_subscription_name", share_subscription_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_by_account_request(
    resource_group_name: str,
    account_name: str,
    subscription_id: str,
    *,
    skip_token: Optional[str] = None,
    filter: Optional[str] = None,
    orderby: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-09-01"))  # type: Literal["2020-09-01"]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url("resource_group_name", resource_group_name, "str"),
        "accountName": _SERIALIZER.url("account_name", account_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if skip_token is not None:
        _params["$skipToken"] = _SERIALIZER.query("skip_token", skip_token, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if orderby is not None:
        _params["$orderby"] = _SERIALIZER.query("orderby", orderby, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class ShareSubscriptionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.datashare.DataShareManagementClient`'s
        :attr:`share_subscriptions` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    def _cancel_synchronization_initial(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        share_subscription_synchronization: Union[_models.ShareSubscriptionSynchronization, IO],
        **kwargs: Any
    ) -> _models.ShareSubscriptionSynchronization:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ShareSubscriptionSynchronization]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(share_subscription_synchronization, (IO, bytes)):
            _content = share_subscription_synchronization
        else:
            _json = self._serialize.body(share_subscription_synchronization, "ShareSubscriptionSynchronization")

        request = build_cancel_synchronization_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            share_subscription_name=share_subscription_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._cancel_synchronization_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ShareSubscriptionSynchronization", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("ShareSubscriptionSynchronization", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _cancel_synchronization_initial.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/cancelSynchronization"}  # type: ignore

    @overload
    def begin_cancel_synchronization(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        share_subscription_synchronization: _models.ShareSubscriptionSynchronization,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ShareSubscriptionSynchronization]:
        """Request cancellation of a data share snapshot.

        Request to cancel a synchronization.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the shareSubscription. Required.
        :type share_subscription_name: str
        :param share_subscription_synchronization: Share Subscription Synchronization payload.
         Required.
        :type share_subscription_synchronization:
         ~azure.mgmt.datashare.models.ShareSubscriptionSynchronization
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ShareSubscriptionSynchronization or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.datashare.models.ShareSubscriptionSynchronization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_cancel_synchronization(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        share_subscription_synchronization: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ShareSubscriptionSynchronization]:
        """Request cancellation of a data share snapshot.

        Request to cancel a synchronization.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the shareSubscription. Required.
        :type share_subscription_name: str
        :param share_subscription_synchronization: Share Subscription Synchronization payload.
         Required.
        :type share_subscription_synchronization: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ShareSubscriptionSynchronization or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.datashare.models.ShareSubscriptionSynchronization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_cancel_synchronization(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        share_subscription_synchronization: Union[_models.ShareSubscriptionSynchronization, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ShareSubscriptionSynchronization]:
        """Request cancellation of a data share snapshot.

        Request to cancel a synchronization.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the shareSubscription. Required.
        :type share_subscription_name: str
        :param share_subscription_synchronization: Share Subscription Synchronization payload. Is
         either a model type or a IO type. Required.
        :type share_subscription_synchronization:
         ~azure.mgmt.datashare.models.ShareSubscriptionSynchronization or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ShareSubscriptionSynchronization or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.datashare.models.ShareSubscriptionSynchronization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ShareSubscriptionSynchronization]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._cancel_synchronization_initial(  # type: ignore
                resource_group_name=resource_group_name,
                account_name=account_name,
                share_subscription_name=share_subscription_name,
                share_subscription_synchronization=share_subscription_synchronization,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ShareSubscriptionSynchronization", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                PollingMethod, ARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_cancel_synchronization.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/cancelSynchronization"}  # type: ignore

    @distributed_trace
    def list_source_share_synchronization_settings(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.SourceShareSynchronizationSetting"]:
        """Get source share synchronization settings for a shareSubscription.

        Get synchronization settings set on a share.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the shareSubscription. Required.
        :type share_subscription_name: str
        :param skip_token: Continuation token. Default value is None.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SourceShareSynchronizationSetting or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.datashare.models.SourceShareSynchronizationSetting]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.SourceShareSynchronizationSettingList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_source_share_synchronization_settings_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    share_subscription_name=share_subscription_name,
                    subscription_id=self._config.subscription_id,
                    skip_token=skip_token,
                    api_version=api_version,
                    template_url=self.list_source_share_synchronization_settings.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("SourceShareSynchronizationSettingList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_source_share_synchronization_settings.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSourceShareSynchronizationSettings"}  # type: ignore

    @overload
    def list_synchronization_details(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        share_subscription_synchronization: _models.ShareSubscriptionSynchronization,
        skip_token: Optional[str] = None,
        filter: Optional[str] = None,
        orderby: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Iterable["_models.SynchronizationDetails"]:
        """List data set level details for a share subscription synchronization.

        List synchronization details.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the share subscription. Required.
        :type share_subscription_name: str
        :param share_subscription_synchronization: Share Subscription Synchronization payload.
         Required.
        :type share_subscription_synchronization:
         ~azure.mgmt.datashare.models.ShareSubscriptionSynchronization
        :param skip_token: Continuation token. Default value is None.
        :type skip_token: str
        :param filter: Filters the results using OData syntax. Default value is None.
        :type filter: str
        :param orderby: Sorts the results using OData syntax. Default value is None.
        :type orderby: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SynchronizationDetails or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.datashare.models.SynchronizationDetails]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def list_synchronization_details(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        share_subscription_synchronization: IO,
        skip_token: Optional[str] = None,
        filter: Optional[str] = None,
        orderby: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Iterable["_models.SynchronizationDetails"]:
        """List data set level details for a share subscription synchronization.

        List synchronization details.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the share subscription. Required.
        :type share_subscription_name: str
        :param share_subscription_synchronization: Share Subscription Synchronization payload.
         Required.
        :type share_subscription_synchronization: IO
        :param skip_token: Continuation token. Default value is None.
        :type skip_token: str
        :param filter: Filters the results using OData syntax. Default value is None.
        :type filter: str
        :param orderby: Sorts the results using OData syntax. Default value is None.
        :type orderby: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SynchronizationDetails or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.datashare.models.SynchronizationDetails]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def list_synchronization_details(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        share_subscription_synchronization: Union[_models.ShareSubscriptionSynchronization, IO],
        skip_token: Optional[str] = None,
        filter: Optional[str] = None,
        orderby: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.SynchronizationDetails"]:
        """List data set level details for a share subscription synchronization.

        List synchronization details.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the share subscription. Required.
        :type share_subscription_name: str
        :param share_subscription_synchronization: Share Subscription Synchronization payload. Is
         either a model type or a IO type. Required.
        :type share_subscription_synchronization:
         ~azure.mgmt.datashare.models.ShareSubscriptionSynchronization or IO
        :param skip_token: Continuation token. Default value is None.
        :type skip_token: str
        :param filter: Filters the results using OData syntax. Default value is None.
        :type filter: str
        :param orderby: Sorts the results using OData syntax. Default value is None.
        :type orderby: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SynchronizationDetails or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.datashare.models.SynchronizationDetails]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.SynchronizationDetailsList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(share_subscription_synchronization, (IO, bytes)):
            _content = share_subscription_synchronization
        else:
            _json = self._serialize.body(share_subscription_synchronization, "ShareSubscriptionSynchronization")

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_synchronization_details_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    share_subscription_name=share_subscription_name,
                    subscription_id=self._config.subscription_id,
                    skip_token=skip_token,
                    filter=filter,
                    orderby=orderby,
                    api_version=api_version,
                    content_type=content_type,
                    json=_json,
                    content=_content,
                    template_url=self.list_synchronization_details.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("SynchronizationDetailsList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_synchronization_details.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSynchronizationDetails"}  # type: ignore

    @distributed_trace
    def list_synchronizations(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        skip_token: Optional[str] = None,
        filter: Optional[str] = None,
        orderby: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.ShareSubscriptionSynchronization"]:
        """List Synchronizations in a share subscription.

        List synchronizations of a share subscription.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the share subscription. Required.
        :type share_subscription_name: str
        :param skip_token: Continuation token. Default value is None.
        :type skip_token: str
        :param filter: Filters the results using OData syntax. Default value is None.
        :type filter: str
        :param orderby: Sorts the results using OData syntax. Default value is None.
        :type orderby: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ShareSubscriptionSynchronization or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.datashare.models.ShareSubscriptionSynchronization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ShareSubscriptionSynchronizationList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_synchronizations_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    share_subscription_name=share_subscription_name,
                    subscription_id=self._config.subscription_id,
                    skip_token=skip_token,
                    filter=filter,
                    orderby=orderby,
                    api_version=api_version,
                    template_url=self.list_synchronizations.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("ShareSubscriptionSynchronizationList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_synchronizations.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/listSynchronizations"}  # type: ignore

    def _synchronize_initial(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        synchronize: Union[_models.Synchronize, IO],
        **kwargs: Any
    ) -> _models.ShareSubscriptionSynchronization:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ShareSubscriptionSynchronization]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(synchronize, (IO, bytes)):
            _content = synchronize
        else:
            _json = self._serialize.body(synchronize, "Synchronize")

        request = build_synchronize_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            share_subscription_name=share_subscription_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._synchronize_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ShareSubscriptionSynchronization", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("ShareSubscriptionSynchronization", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _synchronize_initial.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/synchronize"}  # type: ignore

    @overload
    def begin_synchronize(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        synchronize: _models.Synchronize,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ShareSubscriptionSynchronization]:
        """Initiate an asynchronous data share job.

        Initiate a copy.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of share subscription. Required.
        :type share_subscription_name: str
        :param synchronize: Synchronize payload. Required.
        :type synchronize: ~azure.mgmt.datashare.models.Synchronize
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ShareSubscriptionSynchronization or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.datashare.models.ShareSubscriptionSynchronization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_synchronize(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        synchronize: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> LROPoller[_models.ShareSubscriptionSynchronization]:
        """Initiate an asynchronous data share job.

        Initiate a copy.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of share subscription. Required.
        :type share_subscription_name: str
        :param synchronize: Synchronize payload. Required.
        :type synchronize: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ShareSubscriptionSynchronization or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.datashare.models.ShareSubscriptionSynchronization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def begin_synchronize(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        synchronize: Union[_models.Synchronize, IO],
        **kwargs: Any
    ) -> LROPoller[_models.ShareSubscriptionSynchronization]:
        """Initiate an asynchronous data share job.

        Initiate a copy.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of share subscription. Required.
        :type share_subscription_name: str
        :param synchronize: Synchronize payload. Is either a model type or a IO type. Required.
        :type synchronize: ~azure.mgmt.datashare.models.Synchronize or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either ShareSubscriptionSynchronization or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.datashare.models.ShareSubscriptionSynchronization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ShareSubscriptionSynchronization]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._synchronize_initial(  # type: ignore
                resource_group_name=resource_group_name,
                account_name=account_name,
                share_subscription_name=share_subscription_name,
                synchronize=synchronize,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ShareSubscriptionSynchronization", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(
                PollingMethod, ARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs)
            )  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_synchronize.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/synchronize"}  # type: ignore

    @distributed_trace
    def get(
        self, resource_group_name: str, account_name: str, share_subscription_name: str, **kwargs: Any
    ) -> _models.ShareSubscription:
        """Get shareSubscription in an account.

        Get a shareSubscription in an account.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the shareSubscription. Required.
        :type share_subscription_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ShareSubscription or the result of cls(response)
        :rtype: ~azure.mgmt.datashare.models.ShareSubscription
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ShareSubscription]

        request = build_get_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            share_subscription_name=share_subscription_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ShareSubscription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}"}  # type: ignore

    @overload
    def create(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        share_subscription: _models.ShareSubscription,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ShareSubscription:
        """Create shareSubscription in an account.

        Create a shareSubscription in an account.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the shareSubscription. Required.
        :type share_subscription_name: str
        :param share_subscription: create parameters for shareSubscription. Required.
        :type share_subscription: ~azure.mgmt.datashare.models.ShareSubscription
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ShareSubscription or the result of cls(response)
        :rtype: ~azure.mgmt.datashare.models.ShareSubscription
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        share_subscription: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ShareSubscription:
        """Create shareSubscription in an account.

        Create a shareSubscription in an account.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the shareSubscription. Required.
        :type share_subscription_name: str
        :param share_subscription: create parameters for shareSubscription. Required.
        :type share_subscription: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ShareSubscription or the result of cls(response)
        :rtype: ~azure.mgmt.datashare.models.ShareSubscription
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create(
        self,
        resource_group_name: str,
        account_name: str,
        share_subscription_name: str,
        share_subscription: Union[_models.ShareSubscription, IO],
        **kwargs: Any
    ) -> _models.ShareSubscription:
        """Create shareSubscription in an account.

        Create a shareSubscription in an account.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the shareSubscription. Required.
        :type share_subscription_name: str
        :param share_subscription: create parameters for shareSubscription. Is either a model type or a
         IO type. Required.
        :type share_subscription: ~azure.mgmt.datashare.models.ShareSubscription or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ShareSubscription or the result of cls(response)
        :rtype: ~azure.mgmt.datashare.models.ShareSubscription
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ShareSubscription]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(share_subscription, (IO, bytes)):
            _content = share_subscription
        else:
            _json = self._serialize.body(share_subscription, "ShareSubscription")

        request = build_create_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            share_subscription_name=share_subscription_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ShareSubscription", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ShareSubscription", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}"}  # type: ignore

    def _delete_initial(
        self, resource_group_name: str, account_name: str, share_subscription_name: str, **kwargs: Any
    ) -> Optional[_models.OperationResponse]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.OperationResponse]]

        request = build_delete_request(
            resource_group_name=resource_group_name,
            account_name=account_name,
            share_subscription_name=share_subscription_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._delete_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("OperationResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _delete_initial.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}"}  # type: ignore

    @distributed_trace
    def begin_delete(
        self, resource_group_name: str, account_name: str, share_subscription_name: str, **kwargs: Any
    ) -> LROPoller[_models.OperationResponse]:
        """Delete shareSubscription in an account.

        Delete a shareSubscription in an account.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param share_subscription_name: The name of the shareSubscription. Required.
        :type share_subscription_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either OperationResponse or the result of
         cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.datashare.models.OperationResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.OperationResponse]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                account_name=account_name,
                share_subscription_name=share_subscription_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("OperationResponse", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method = cast(PollingMethod, ARMPolling(lro_delay, **kwargs))  # type: PollingMethod
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_delete.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}"}  # type: ignore

    @distributed_trace
    def list_by_account(
        self,
        resource_group_name: str,
        account_name: str,
        skip_token: Optional[str] = None,
        filter: Optional[str] = None,
        orderby: Optional[str] = None,
        **kwargs: Any
    ) -> Iterable["_models.ShareSubscription"]:
        """List of available share subscriptions under an account.

        List share subscriptions in an account.

        :param resource_group_name: The resource group name. Required.
        :type resource_group_name: str
        :param account_name: The name of the share account. Required.
        :type account_name: str
        :param skip_token: Continuation Token. Default value is None.
        :type skip_token: str
        :param filter: Filters the results using OData syntax. Default value is None.
        :type filter: str
        :param orderby: Sorts the results using OData syntax. Default value is None.
        :type orderby: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ShareSubscription or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.datashare.models.ShareSubscription]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.ShareSubscriptionList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_account_request(
                    resource_group_name=resource_group_name,
                    account_name=account_name,
                    subscription_id=self._config.subscription_id,
                    skip_token=skip_token,
                    filter=filter,
                    orderby=orderby,
                    api_version=api_version,
                    template_url=self.list_by_account.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("ShareSubscriptionList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    list_by_account.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions"}  # type: ignore
