% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstalk.R
\name{SharedData}
\alias{SharedData}
\title{Shared data frame}
\description{
An R6 class that represents a shared data frame, or sufficiently data
frame-like object.

The primary use for \code{SharedData} is to be passed to Crosstalk-compatible
widgets in place of a data frame. Each \code{SharedData$new(...)} call makes
a new "group" of widgets that link to each other, but not to widgets in other
groups. You can also use a \code{SharedData} object from Shiny code in order
to react to filtering and brushing from non-widget visualizations (like
ggplot2 plots).
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SharedData-new}{\code{SharedData$new()}}
\item \href{#method-SharedData-origData}{\code{SharedData$origData()}}
\item \href{#method-SharedData-groupName}{\code{SharedData$groupName()}}
\item \href{#method-SharedData-key}{\code{SharedData$key()}}
\item \href{#method-SharedData-data}{\code{SharedData$data()}}
\item \href{#method-SharedData-selection}{\code{SharedData$selection()}}
\item \href{#method-SharedData-clearSelection}{\code{SharedData$clearSelection()}}
\item \href{#method-SharedData-clone}{\code{SharedData$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SharedData-new"></a>}}
\if{latex}{\out{\hypertarget{method-SharedData-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SharedData$new(
  data,
  key = NULL,
  group = createUniqueId(4, prefix = "SharedData")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame-like object, or a Shiny
\link[shiny:reactive]{reactive expression} that returns a data
frame-like object.}

\item{\code{key}}{Character vector or one-sided formula that indicates the name
  of the column that represents the key or ID of the data frame. These
  \emph{must} be unique, and ideally will be something intrinsic to the
  data (a proper ID) rather than a transient property like row index.

  If \code{NULL}, then \code{row.names(data)} will be used.}

\item{\code{group}}{The "identity" of the Crosstalk group that widgets will join
when you pass them this \code{SharedData} object. In some cases, you
will want to have multiple independent \code{SharedData} objects link
up to form a single web of widgets that all share selection and
filtering state; in those cases, you'll give those \code{SharedData}
objects the same group name. (One example: in Shiny, ui.R and server.R
might each need their own \code{SharedData} instance, even though
they're intended to represent a single group.)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SharedData-origData"></a>}}
\if{latex}{\out{\hypertarget{method-SharedData-origData}{}}}
\subsection{Method \code{origData()}}{
Return the data frame that was used to create this
\code{SharedData} instance. If a reactive expression, evaluate the
reactive expression. Equivalent to \code{SharedData$data(FALSE, FALSE,
FALSE)}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SharedData$origData()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SharedData-groupName"></a>}}
\if{latex}{\out{\hypertarget{method-SharedData-groupName}{}}}
\subsection{Method \code{groupName()}}{
Returns the value of \code{group} that was used to create
this instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SharedData$groupName()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SharedData-key"></a>}}
\if{latex}{\out{\hypertarget{method-SharedData-key}{}}}
\subsection{Method \code{key()}}{
Returns the vector of key values. Filtering is not applied.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SharedData$key()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SharedData-data"></a>}}
\if{latex}{\out{\hypertarget{method-SharedData-data}{}}}
\subsection{Method \code{data()}}{
Return the data (or read and return the data if the data is a Shiny
reactive expression).

When running in Shiny, calling \code{data()} is a reactive operation that
will invalidate if the selection or filter change (assuming that
information was requested), or if the original data is a reactive
expression that has invalidated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SharedData$data(withSelection = FALSE, withFilter = TRUE, withKey = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{withSelection}}{If `TRUE`, add a \code{selection_} column with
logical values indicating which rows are in the current selection, or
\code{NA} if no selection is currently active.}

\item{\code{withFilter}}{If `TRUE` (the default), only return rows that are part
of the current filter settings, if any.}

\item{\code{withKey}}{If `TRUE`, add a \code{key_} column with the key values of
each row (normally not needed since the key is either one of the other
columns or else just the row names).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SharedData-selection"></a>}}
\if{latex}{\out{\hypertarget{method-SharedData-selection}{}}}
\subsection{Method \code{selection()}}{
Get or set the current selection in the client.

If called without arguments, returns a logical vector of rows that are
currently selected (brushed), or \code{NULL} if no selection exists.
Intended to be called from a Shiny reactive context, and invalidates
whenever the selection changes.

If called with one or two arguments, sets the selection based on the
given value indirectly, by sending the value to the web browser (assumes
an active Shiny app or Shiny R Markdown document).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SharedData$selection(value, ownerId = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{If provided, a logical vector of `nrow(origData())` length,
indicating which rows are currently selected (brushed).}

\item{\code{ownerId}}{Set this argument to the `outputId` of a widget if
conceptually that widget "initiated" the selection (prevents that
widget from clearing its visual selection box, which is normally
cleared when the selection changes). For example, if setting the
selection based on a [shiny::plotOutput()] brush, then
`ownerId` should be the `outputId` of that `plotOutput`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SharedData-clearSelection"></a>}}
\if{latex}{\out{\hypertarget{method-SharedData-clearSelection}{}}}
\subsection{Method \code{clearSelection()}}{
Clears the selection indirectly, by sending an instruction
to the client that it should do so.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SharedData$clearSelection(ownerId = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ownerId}}{See the [SharedData$selection()] method.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SharedData-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SharedData-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SharedData$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
